/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.openflashchart;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.openflashchart.factory.PentahoOFC4JChartHelper;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public class OpenFlashChartComponent
extends ComponentBase {
    private static final long serialVersionUID = 825147871232129168L;
    private static final Log log = LogFactory.getLog(OpenFlashChartComponent.class);
    private static final String DEFAULT_FLASH_LOC = "openflashchart";
    private static final String DEFAULT_FLASH_SWF = "open-flash-chart-full-embedded-font.swf";
    private static final String CHART_DATA = "chart-data";
    private static final String CHART_WIDTH = "width";
    private static final String CHART_HEIGHT = "height";
    private static final String OFC_URL = "ofc_url";
    public static String CHART_NODE_LOC = "chart";
    private static final String CHART_ATTRIBUTES = "chart-attributes";
    private static final String OFC_LIB_NAME = "ofc_lib_name";
    private static final String BY_ROW_PROP = "by-row";
    private static final String DEFAULT_WIDTH = "100%";
    private static final String DEFAULT_HEIGHT = "100%";
    protected String template = null;
    protected IPentahoResultSet data = null;
    protected static String flashFragment = "<script>function {dataFunction}() { return \"{chartJson}\";}</script><object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\" width=\"{chart-width}\" height=\"{chart-height}\"  id=\"ofco{chartId}\" align=\"middle\"> <param name=\"allowScriptAccess\" value=\"sameDomain\" /> <param name=\"wmode\" value=\"opaque\"><param name=\"movie\" value=\"{ofc-url}/{ofc-libname}?get-data={dataFunction}\" /> <param name=\"quality\" value=\"high\" /> <embed src=\"{ofc-url}/{ofc-libname}?get-data={dataFunction}\" wmode=\"opaque\" quality=\"high\" bgcolor=\"#FFFFFF\" width=\"{chart-width}\" height=\"{chart-height}\"  id=\"ofce{chartId}\" align=\"middle\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" /></object>";

    protected boolean validateAction() {
        if (!this.isDefinedInput(CHART_DATA)) {
            this.inputMissingError(CHART_DATA);
            return false;
        }
        if (!this.isDefinedInput(CHART_ATTRIBUTES) && !this.isDefinedResource(CHART_ATTRIBUTES)) {
            this.inputMissingError(CHART_ATTRIBUTES);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean executeAction() {
        OpenFlashChartComponent.log.debug((Object)"start to run open flash chart component......");
        data = (IPentahoResultSet)this.getInputValue("chart-data");
        if (!data.isScrollable()) {
            this.getLogger().debug((Object)"ResultSet is not scrollable. Copying into memory");
            memSet = data.memoryCopy();
            data.close();
            data = memSet;
        }
        chartWidth = null;
        inputWidth = this.getInputStringValue("width");
        chartWidth = inputWidth == null ? "100%" : inputWidth;
        chartHeight = null;
        inputHeight = this.getInputStringValue("height");
        chartHeight = null == inputHeight ? "100%" : inputHeight;
        ofcURL = this.getInputStringValue("ofc_url");
        if (ofcURL == null || "".equals(ofcURL)) {
            ofcURL = PentahoRequestContextHolder.getRequestContext().getContextPath() + "openflashchart";
        }
        if ((ofclibname = this.getInputStringValue("ofc_lib_name")) == null || "".equals(ofclibname)) {
            ofclibname = "open-flash-chart-full-embedded-font.swf";
        }
        chartAttributeString = null;
        if (this.getInputNames().contains("chart-attributes")) {
            chartAttributeString = this.getInputStringValue("chart-attributes");
        } else if (this.isDefinedResource("chart-attributes")) {
            resource = this.getResource("chart-attributes");
            chartAttributeString = this.getResourceAsString(resource);
        }
        chartNode = null;
        if (chartAttributeString != null) {
            chartAttributeString = this.applyInputsToFormat(chartAttributeString);
            try {
                chartDocument = XmlDom4JHelper.getDocFromString((String)chartAttributeString, (EntityResolver)new PentahoEntityResolver());
                chartNode = chartDocument.selectSingleNode(OpenFlashChartComponent.CHART_NODE_LOC);
                if (chartNode != null) ** GOTO lbl39
                chartNode = chartDocument.selectSingleNode("chart-attributes");
            }
            catch (XmlParseException e) {
                this.getLogger().error((Object)Messages.getInstance().getErrorString("OpenFlashChartComponent.ERROR_0001_CANT_DOCUMENT_FROM_STRING"), (Throwable)e);
                return false;
            }
        } else {
            chartNode = this.getComponentDefinition(true).selectSingleNode("chart-attributes");
        }
lbl39:
        // 3 sources

        if (chartNode == null) {
            this.getLogger().error((Object)Messages.getInstance().getErrorString("OpenFlashChartComponent.ERROR_0002_CHART_DEFINITION_NOT_FOUND"));
            return false;
        }
        byRow = false;
        if (this.getInputStringValue("by-row") != null) {
            byRow = Boolean.valueOf(this.getInputStringValue("by-row"));
        }
        chartJson = this.generateChartJson(data, chartNode, byRow);
        chartId = UUIDUtil.getUUIDAsString().replaceAll("[^\\w]", "");
        props = new Properties();
        props.setProperty("chartId", chartId);
        props.setProperty("dataFunction", "getData" + chartId);
        props.setProperty("chart-width", chartWidth);
        props.setProperty("chart-height", chartHeight);
        props.setProperty("ofc-url", ofcURL);
        props.setProperty("ofc-libname", ofclibname);
        props.setProperty("chartJson", chartJson.replaceAll("\"", "\\\\\""));
        flashContent = TemplateUtil.applyTemplate((String)this.getFlashFragment(), (Properties)props, null);
        OpenFlashChartComponent.log.debug((Object)("html_fragment=" + flashContent));
        if (this.isDefinedOutput("html_fragment")) {
            this.setOutputValue("html_fragment", flashContent);
        }
        if (this.isDefinedOutput("image-tag")) {
            this.setOutputValue("image-tag", flashContent);
        }
        return true;
    }

    protected String generateChartJson(IPentahoResultSet data, Node chartNode, boolean byRow) {
        return PentahoOFC4JChartHelper.generateChartJson(chartNode, data, byRow, log);
    }

    protected String getFlashFragment() {
        return flashFragment;
    }

    public void done() {
    }

    public boolean init() {
        return true;
    }

    public boolean validateSystemSettings() {
        return true;
    }

    public Log getLogger() {
        return log;
    }

    protected Object getInputValue(String inputName) {
        return super.getInputValue(inputName);
    }

    protected String getInputStringValue(String inputName) {
        return super.getInputStringValue(inputName);
    }

    protected boolean isDefinedInput(String inputName) {
        return super.isDefinedInput(inputName);
    }

    protected boolean isDefinedResource(String resourceName) {
        return super.isDefinedResource(resourceName);
    }

    public void inputMissingError(String paramName) {
        super.inputMissingError(paramName);
    }
}

