/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.condition.javascript;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IConditionalExecution;
import org.pentaho.platform.plugin.condition.javascript.RhinoScriptable;
import org.pentaho.platform.plugin.services.connections.javascript.JavaScriptResultSet;

public class ConditionalExecution
implements IConditionalExecution {
    private String script;

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldExecute(Map currentInputs, Log logger) throws Exception {
        boolean shouldExecute = true;
        Context cx = ContextFactory.getGlobal().enterContext();
        try {
            RhinoScriptable scriptable = new RhinoScriptable();
            Scriptable scope = cx.initStandardObjects((ScriptableObject)scriptable);
            ScriptableObject.defineClass((Scriptable)scope, JavaScriptResultSet.class);
            for (Map.Entry mapEntry : currentInputs.entrySet()) {
                Object wrapper;
                String inputName = (String)mapEntry.getKey();
                if (inputName.indexOf(45) >= 0) {
                    logger.info((Object)("Ignoring Input: " + inputName));
                    continue;
                }
                IActionParameter inputParameter = (IActionParameter)mapEntry.getValue();
                Object inputValue = inputParameter.getValue();
                if (inputValue instanceof IPentahoResultSet) {
                    JavaScriptResultSet results = new JavaScriptResultSet();
                    results.setPrototype((Scriptable)scriptable);
                    results.setResultSet((IPentahoResultSet)inputValue);
                    wrapper = Context.javaToJS((Object)inputValue, (Scriptable)results);
                } else {
                    wrapper = Context.javaToJS((Object)inputValue, (Scriptable)scope);
                }
                ScriptableObject.putProperty((Scriptable)scope, (String)inputName, (Object)wrapper);
            }
            Object wrappedOut = Context.javaToJS((Object)System.out, (Scriptable)scope);
            Object wrappedThis = Context.javaToJS((Object)this, (Scriptable)scope);
            ScriptableObject.putProperty((Scriptable)scope, (String)"out", (Object)wrappedOut);
            ScriptableObject.putProperty((Scriptable)scope, (String)"rule", (Object)wrappedThis);
            Object resultObject = cx.evaluateString(scope, this.script, "<cmd>", 1, null);
            Object actualObject = null;
            actualObject = resultObject instanceof NativeJavaObject ? ((NativeJavaObject)resultObject).unwrap() : resultObject;
            if (actualObject instanceof Boolean) {
                boolean bl = (Boolean)actualObject;
                return bl;
            }
            if (actualObject instanceof String) {
                boolean bl = "true".equalsIgnoreCase(actualObject.toString()) || "yes".equalsIgnoreCase(actualObject.toString());
                return bl;
            }
            if (actualObject instanceof Number) {
                boolean bl = ((Number)actualObject).intValue() > 0;
                return bl;
            }
            if (actualObject instanceof IPentahoResultSet) {
                boolean bl = ((IPentahoResultSet)actualObject).getRowCount() > 0;
                return bl;
            }
        }
        finally {
            Context.exit();
        }
        return shouldExecute;
    }
}

