/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.outputs;

import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.output.SimpleContentItem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.outputhandler.BaseOutputHandler;
import org.pentaho.platform.util.logging.Logger;

public class ApacheVFSOutputHandler
extends BaseOutputHandler {
    public IContentItem getFileOutputContentItem() {
        String contentRef = this.getContentRef();
        try {
            String contentName = this.getHandlerId().substring(4) + ":" + contentRef;
            FileSystemManager fsManager = this.getFileSystemManager();
            if (fsManager == null) {
                this.logError(Messages.getInstance().getString("ApacheVFSOutputHandler.ERROR_0001_CANNOT_GET_VFSMGR"));
                return null;
            }
            FileObject file = fsManager.resolveFile(contentName);
            if (file == null) {
                this.logError(Messages.getInstance().getString("ApacheVFSOutputHandler.ERROR_0002_CANNOT_GET_VF", new Object[]{contentName}));
                return null;
            }
            if (!file.isWriteable()) {
                this.logError(Messages.getInstance().getString("ApacheVFSOutputHandler.ERROR_0003_CANNOT_WRITE", new Object[]{contentName}));
                return null;
            }
            FileContent fileContent = file.getContent();
            if (fileContent == null) {
                this.logError(Messages.getInstance().getString("ApacheVFSOutputHandler.ERROR_0004_CANNOT_GET_CTX", new Object[]{contentName}));
                return null;
            }
            OutputStream outputStream = fileContent.getOutputStream();
            SimpleContentItem content = new SimpleContentItem(outputStream);
            return content;
        }
        catch (Throwable t) {
            Logger.error((String)ApacheVFSOutputHandler.class.getName(), (String)Messages.getInstance().getString("ApacheVFSOutputHandler.ERROR_0005_CANNOT_GET_HANDLER", new Object[]{contentRef}), (Throwable)t);
            return null;
        }
    }

    void logError(String string) {
        Logger.error((String)ApacheVFSOutputHandler.class.getName(), (String)string);
    }

    FileSystemManager getFileSystemManager() throws FileSystemException {
        return VFS.getManager();
    }
}

