/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.platform.api.engine.security.userroledao.AlreadyExistsException;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.mimetype.IMimeType;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.usersettings.IAnyUserSettingService;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.TenantUtils;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.LocaleFilesProcessor;
import org.pentaho.platform.plugin.services.importer.PentahoPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importer.SolutionFileImportHelper;
import org.pentaho.platform.plugin.services.importexport.ExportFileNameEncoder;
import org.pentaho.platform.plugin.services.importexport.ExportManifestUserSetting;
import org.pentaho.platform.plugin.services.importexport.ImportSession;
import org.pentaho.platform.plugin.services.importexport.ImportSource;
import org.pentaho.platform.plugin.services.importexport.RepositoryFileBundle;
import org.pentaho.platform.plugin.services.importexport.RoleExport;
import org.pentaho.platform.plugin.services.importexport.UserExport;
import org.pentaho.platform.plugin.services.importexport.exportManifest.ExportManifest;
import org.pentaho.platform.plugin.services.importexport.exportManifest.Parameters;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMetaStore;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMetadata;
import org.pentaho.platform.plugin.services.importexport.exportManifest.bindings.ExportManifestMondrian;
import org.pentaho.platform.plugin.services.importexport.legacy.MondrianCatalogRepositoryHelper;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.pentaho.platform.web.http.api.resources.JobRequest;
import org.pentaho.platform.web.http.api.resources.JobScheduleParam;
import org.pentaho.platform.web.http.api.resources.JobScheduleRequest;
import org.pentaho.platform.web.http.api.resources.SchedulerResource;

public class SolutionImportHandler
implements IPlatformImportHandler {
    private static final Log log = LogFactory.getLog(SolutionImportHandler.class);
    public static final String RESERVEDMAPKEY_LINEAGE_ID = "lineage-id";
    private static final String sep = ";";
    private IUnifiedRepository repository;
    protected Map<String, RepositoryFileImportBundle.Builder> cachedImports;
    private SolutionFileImportHelper solutionHelper;
    private List<IMimeType> mimeTypes;
    private boolean overwriteFile;

    public SolutionImportHandler(List<IMimeType> mimeTypes) {
        this.mimeTypes = mimeTypes;
        this.solutionHelper = new SolutionFileImportHelper();
        this.repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
    }

    public ImportSession getImportSession() {
        return ImportSession.getSession();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void importFile(IPlatformImportBundle bundle) throws PlatformImportException, DomainIdNullException, DomainAlreadyExistsException, DomainStorageException, IOException {
        RepositoryFileImportBundle importBundle = (RepositoryFileImportBundle)bundle;
        ZipInputStream zipImportStream = new ZipInputStream(bundle.getInputStream());
        SolutionRepositoryImportSource importSource = new SolutionRepositoryImportSource(zipImportStream);
        LocaleFilesProcessor localeFilesProcessor = new LocaleFilesProcessor();
        this.setOverwriteFile(bundle.overwriteInRepository());
        IPlatformImporter importer = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
        this.cachedImports = new HashMap<String, RepositoryFileImportBundle.Builder>();
        ExportManifest manifest = this.getImportSession().getManifest();
        String manifestVersion = null;
        if (manifest != null) {
            manifestVersion = manifest.getManifestInformation().getManifestVersion();
        }
        if (manifest != null) {
            Map<String, List<String>> roleToUserMap = this.importUsers(manifest.getUserExports());
            this.importRoles(manifest.getRoleExports(), roleToUserMap);
            List<ExportManifestMetadata> metadataList = manifest.getMetadataList();
            for (ExportManifestMetadata exportManifestMetadata : metadataList) {
                String domainId = exportManifestMetadata.getDomainId();
                boolean overWriteInRepository = this.isOverwriteFile();
                RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder().charSet("UTF-8").hidden(false).schedulable(true).preserveDsw(bundle.isPreserveDsw()).overwriteFile(overWriteInRepository).mime("text/xmi+xml").withParam("domain-id", domainId);
                this.cachedImports.put(exportManifestMetadata.getFile(), bundleBuilder);
            }
            List<ExportManifestMondrian> mondrianList = manifest.getMondrianList();
            for (ExportManifestMondrian exportManifestMondrian : mondrianList) {
                String catName = exportManifestMondrian.getCatalogName();
                Parameters parametersMap = exportManifestMondrian.getParameters();
                StringBuilder parametersStr = new StringBuilder();
                for (String s : parametersMap.keySet()) {
                    parametersStr.append(s).append("=").append((String)parametersMap.get(s)).append(sep);
                }
                RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder().charSet("UTF_8").hidden(false).schedulable(true).name(catName).overwriteFile(this.isOverwriteFile()).mime("application/vnd.pentaho.mondrian+xml").withParam("parameters", parametersStr.toString()).withParam("domain-id", catName);
                String xmlaEnabled = "" + exportManifestMondrian.isXmlaEnabled();
                bundleBuilder.withParam("EnableXmla", xmlaEnabled);
                this.cachedImports.put(exportManifestMondrian.getFile(), bundleBuilder);
                String annotationsFile = exportManifestMondrian.getAnnotationsFile();
                if (annotationsFile == null) continue;
                RepositoryFileImportBundle.Builder annotationsBundle = new RepositoryFileImportBundle.Builder().path(MondrianCatalogRepositoryHelper.ETC_MONDRIAN_JCR_FOLDER + "/" + catName).name("annotations.xml").charSet("UTF_8").overwriteFile(this.isOverwriteFile()).mime("text/xml").hidden(false).schedulable(true).withParam("domain-id", catName);
                this.cachedImports.put(annotationsFile, annotationsBundle);
            }
        }
        this.importMetaStore(manifest, bundle.overwriteInRepository());
        for (ImportSource.IRepositoryFileBundle fileBundle : importSource.getFiles()) {
            void var12_17;
            String repositoryFilePath;
            String fileName = fileBundle.getFile().getName();
            String string = fileBundle.getPath();
            if (manifestVersion != null) {
                fileName = ExportFileNameEncoder.decodeZipFileName(fileName);
                String string2 = ExportFileNameEncoder.decodeZipFileName(string);
            }
            if (this.cachedImports.containsKey(repositoryFilePath = RepositoryFilenameUtils.concat((String)PentahoPlatformImporter.computeBundlePath((String)var12_17), (String)fileName))) {
                byte[] bytes = IOUtils.toByteArray((InputStream)fileBundle.getInputStream());
                RepositoryFileImportBundle.Builder builder = this.cachedImports.get(repositoryFilePath);
                builder.input(new ByteArrayInputStream(bytes));
                importer.importFile(this.build(builder));
                continue;
            }
            RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder();
            ByteArrayInputStream bundleInputStream = null;
            String decodedFilePath = fileBundle.getPath();
            RepositoryFile decodedFile = fileBundle.getFile();
            if (manifestVersion != null) {
                decodedFile = new RepositoryFile.Builder(decodedFile).path(decodedFilePath).name(fileName).title(fileName).build();
                decodedFilePath = ExportFileNameEncoder.decodeZipFileName(fileBundle.getPath());
            }
            if (fileBundle.getFile().isFolder()) {
                bundleBuilder.mime("text/directory");
                bundleBuilder.file(decodedFile);
                fileName = repositoryFilePath;
                repositoryFilePath = importBundle.getPath();
            } else {
                byte[] bytes = IOUtils.toByteArray((InputStream)fileBundle.getInputStream());
                bundleInputStream = new ByteArrayInputStream(bytes);
                if (localeFilesProcessor.isLocaleFile(fileBundle, importBundle.getPath(), bytes)) {
                    log.trace((Object)("Skipping [" + repositoryFilePath + "], it is a locale property file"));
                    continue;
                }
                bundleBuilder.input(bundleInputStream);
                bundleBuilder.mime(this.solutionHelper.getMime(fileName));
                String filePath = decodedFilePath.equals("/") || decodedFilePath.equals("\\") ? "" : decodedFilePath;
                repositoryFilePath = RepositoryFilenameUtils.concat((String)importBundle.getPath(), (String)filePath);
            }
            bundleBuilder.name(fileName);
            bundleBuilder.path(repositoryFilePath);
            String sourcePath = fileBundle.getFile().isFolder() ? fileName : RepositoryFilenameUtils.concat((String)PentahoPlatformImporter.computeBundlePath((String)var12_17), (String)fileName);
            if (manifest != null && manifest.getExportManifestEntity(sourcePath) == null && fileBundle.getFile().isFolder()) continue;
            this.getImportSession().setCurrentManifestKey(sourcePath);
            bundleBuilder.charSet(bundle.getCharset());
            bundleBuilder.overwriteFile(bundle.overwriteInRepository());
            bundleBuilder.applyAclSettings(bundle.isApplyAclSettings());
            bundleBuilder.retainOwnership(bundle.isRetainOwnership());
            bundleBuilder.overwriteAclSettings(bundle.isOverwriteAclSettings());
            bundleBuilder.acl(this.getImportSession().processAclForFile(sourcePath));
            RepositoryFile file = this.getFile(importBundle, fileBundle);
            ImportSession.ManifestFile manifestFile = this.getImportSession().getManifestFile(sourcePath, file != null);
            bundleBuilder.hidden(this.isFileHidden(file, manifestFile, sourcePath));
            bundleBuilder.schedulable(this.isSchedulable(file, manifestFile));
            IPlatformImportBundle platformImportBundle = this.build(bundleBuilder);
            importer.importFile(platformImportBundle);
            if (bundleInputStream == null) continue;
            ((InputStream)bundleInputStream).close();
            bundleInputStream = null;
        }
        if (manifest != null) {
            this.importSchedules(manifest.getScheduleList());
            List<DatabaseConnection> datasourceList = manifest.getDatasourceList();
            if (datasourceList != null) {
                IDatasourceMgmtService datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.get(IDatasourceMgmtService.class);
                for (DatabaseConnection databaseConnection : datasourceList) {
                    if (databaseConnection.getDatabaseType() == null) {
                        log.warn((Object)("Can't import connection " + databaseConnection.getName() + " because it doesn't have a databaseType"));
                        continue;
                    }
                    try {
                        IDatabaseConnection existingDBConnection = datasourceMgmtSvc.getDatasourceByName(databaseConnection.getName());
                        if (existingDBConnection != null && existingDBConnection.getName() != null) {
                            if (!this.isOverwriteFile()) continue;
                            databaseConnection.setId(existingDBConnection.getId());
                            datasourceMgmtSvc.updateDatasourceByName(databaseConnection.getName(), (IDatabaseConnection)databaseConnection);
                            continue;
                        }
                        datasourceMgmtSvc.createDatasource((IDatabaseConnection)databaseConnection);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        localeFilesProcessor.processLocaleFiles(importer);
    }

    List<Job> getAllJobs(SchedulerResource schedulerResource) {
        return schedulerResource.getAllJobs();
    }

    private RepositoryFile getFile(IPlatformImportBundle importBundle, ImportSource.IRepositoryFileBundle fileBundle) {
        String repositoryFilePath = this.repositoryPathConcat(importBundle.getPath(), fileBundle.getPath(), fileBundle.getFile().getName());
        return this.repository.getFile(repositoryFilePath);
    }

    protected void importSchedules(List<JobScheduleRequest> scheduleList) throws PlatformImportException {
        if (CollectionUtils.isNotEmpty(scheduleList)) {
            SchedulerResource schedulerResource = new SchedulerResource();
            schedulerResource.pause();
            for (JobScheduleRequest jobScheduleRequest : scheduleList) {
                boolean jobExists = false;
                List<Job> jobs = this.getAllJobs(schedulerResource);
                if (jobs != null) {
                    HashMap<String, Serializable> mapParamsRequest = new HashMap<String, Serializable>();
                    for (JobScheduleParam paramRequest : jobScheduleRequest.getJobParameters()) {
                        mapParamsRequest.put(paramRequest.getName(), paramRequest.getValue());
                    }
                    for (Job job : jobs) {
                        if (mapParamsRequest.get(RESERVEDMAPKEY_LINEAGE_ID) != null && ((Serializable)mapParamsRequest.get(RESERVEDMAPKEY_LINEAGE_ID)).equals(job.getJobParams().get(RESERVEDMAPKEY_LINEAGE_ID))) {
                            jobExists = true;
                        }
                        if (!this.overwriteFile || !jobExists) continue;
                        JobRequest jobRequest = new JobRequest();
                        jobRequest.setJobId(job.getJobId());
                        schedulerResource.removeJob(jobRequest);
                        jobExists = false;
                        break;
                    }
                }
                if (!jobExists) {
                    try {
                        Response response = this.createSchedulerJob(schedulerResource, jobScheduleRequest);
                        if (response.getStatus() != Response.Status.OK.getStatusCode() || response.getEntity() == null) continue;
                        ImportSession.getSession().addImportedScheduleJobId(response.getEntity().toString());
                    }
                    catch (Exception e) {
                        if (jobScheduleRequest.getInputFile().contains(" ") || jobScheduleRequest.getOutputFile().contains(" ")) {
                            log.info((Object)("Could not import schedule, attempting to replace spaces with underscores and retrying: " + jobScheduleRequest.getInputFile()));
                            File inFile = new File(jobScheduleRequest.getInputFile());
                            File outFile = new File(jobScheduleRequest.getOutputFile());
                            String inputFileName = inFile.getParent() + "/" + inFile.getName().replaceAll(" ", "_");
                            String outputFileName = outFile.getParent() + "/" + outFile.getName().replaceAll(" ", "_");
                            jobScheduleRequest.setInputFile(inputFileName);
                            jobScheduleRequest.setOutputFile(outputFileName);
                            try {
                                Response response;
                                if (File.separator != "/") {
                                    jobScheduleRequest.setInputFile(inputFileName.replace(File.separator, "/"));
                                    jobScheduleRequest.setOutputFile(outputFileName.replace(File.separator, "/"));
                                }
                                if ((response = this.createSchedulerJob(schedulerResource, jobScheduleRequest)).getStatus() != Response.Status.OK.getStatusCode() || response.getEntity() == null) continue;
                                ImportSession.getSession().addImportedScheduleJobId(response.getEntity().toString());
                            }
                            catch (Exception ex) {
                                log.error((Object)Messages.getInstance().getString("SolutionImportHandler.ERROR_0001_ERROR_CREATING_SCHEDULE", new Object[]{e.getMessage()}), (Throwable)ex);
                            }
                            continue;
                        }
                        log.error((Object)Messages.getInstance().getString("SolutionImportHandler.ERROR_0001_ERROR_CREATING_SCHEDULE", new Object[]{e.getMessage()}));
                    }
                    continue;
                }
                log.info((Object)Messages.getInstance().getString("DefaultImportHandler.ERROR_0009_OVERWRITE_CONTENT", new Object[]{jobScheduleRequest.toString()}));
            }
            schedulerResource.start();
        }
    }

    protected void importMetaStore(ExportManifest manifest, boolean overwrite) {
        ExportManifestMetaStore manifestMetaStore;
        if (manifest != null && (manifestMetaStore = manifest.getMetaStore()) != null) {
            RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder().path(manifestMetaStore.getFile()).name(manifestMetaStore.getName()).withParam("description", manifestMetaStore.getDescription()).charSet("UTF-8").overwriteFile(overwrite).mime("application/vnd.pentaho.metastore");
            this.cachedImports.put(manifestMetaStore.getFile(), bundleBuilder);
        }
    }

    protected Map<String, List<String>> importUsers(List<UserExport> users) {
        HashMap<String, List<String>> roleToUserMap = new HashMap<String, List<String>>();
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class);
        Tenant tenant = new Tenant("/pentaho/" + TenantUtils.getDefaultTenant(), Boolean.valueOf(true));
        if (users != null && roleDao != null) {
            for (UserExport user : users) {
                String password = user.getPassword();
                log.debug((Object)("Importing user: " + user.getUsername()));
                for (String role : user.getRoles()) {
                    List<String> userList;
                    if (!roleToUserMap.containsKey(role)) {
                        userList = new ArrayList();
                        roleToUserMap.put(role, userList);
                    } else {
                        userList = (List)roleToUserMap.get(role);
                    }
                    userList.add(user.getUsername());
                }
                String[] userRoles = user.getRoles().toArray(new String[0]);
                try {
                    roleDao.createUser((ITenant)tenant, user.getUsername(), password, null, userRoles);
                }
                catch (AlreadyExistsException e) {
                    log.info((Object)Messages.getInstance().getString("USER.Already.Exists", new Object[]{user.getUsername()}));
                    try {
                        if (this.isOverwriteFile()) {
                            roleDao.setUserRoles((ITenant)tenant, user.getUsername(), userRoles);
                            roleDao.setPassword((ITenant)tenant, user.getUsername(), password);
                        }
                    }
                    catch (Exception ex) {
                        log.debug((Object)"Failed to set roles or password for existing user on import", (Throwable)ex);
                    }
                }
                catch (Exception e) {
                    log.error((Object)Messages.getInstance().getString("ERROR.CreatingUser", new Object[]{user.getUsername()}));
                }
                this.importUserSettings(user);
            }
        }
        return roleToUserMap;
    }

    protected void importGlobalUserSettings(List<ExportManifestUserSetting> globalSettings) {
        IUserSettingService settingService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class);
        if (settingService != null) {
            for (ExportManifestUserSetting globalSetting : globalSettings) {
                if (this.isOverwriteFile()) {
                    settingService.setGlobalUserSetting(globalSetting.getName(), globalSetting.getValue());
                    continue;
                }
                IUserSetting userSetting = settingService.getGlobalUserSetting(globalSetting.getName(), null);
                if (userSetting != null) continue;
                settingService.setGlobalUserSetting(globalSetting.getName(), globalSetting.getValue());
            }
        }
    }

    protected void importUserSettings(UserExport user) {
        IUserSettingService settingService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class);
        IAnyUserSettingService userSettingService = null;
        if (settingService != null && settingService instanceof IAnyUserSettingService) {
            userSettingService = (IAnyUserSettingService)settingService;
        }
        if (userSettingService != null) {
            List<ExportManifestUserSetting> exportedSettings = user.getUserSettings();
            try {
                for (ExportManifestUserSetting exportedSetting : exportedSettings) {
                    if (this.isOverwriteFile()) {
                        userSettingService.setUserSetting(user.getUsername(), exportedSetting.getName(), exportedSetting.getValue());
                        continue;
                    }
                    IUserSetting userSetting = userSettingService.getUserSetting(user.getUsername(), exportedSetting.getName(), null);
                    if (userSetting != null) continue;
                    userSettingService.setUserSetting(user.getUsername(), exportedSetting.getName(), exportedSetting.getValue());
                }
            }
            catch (SecurityException e) {
                log.error((Object)Messages.getInstance().getString("ERROR.ImportingUserSetting", new Object[]{user.getUsername()}));
                log.debug((Object)Messages.getInstance().getString("ERROR.ImportingUserSetting", new Object[]{user.getUsername()}), (Throwable)e);
            }
        }
    }

    protected void importRoles(List<RoleExport> roles, Map<String, List<String>> roleToUserMap) {
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class);
        Tenant tenant = new Tenant("/pentaho/" + TenantUtils.getDefaultTenant(), Boolean.valueOf(true));
        IRoleAuthorizationPolicyRoleBindingDao roleBindingDao = (IRoleAuthorizationPolicyRoleBindingDao)PentahoSystem.get(IRoleAuthorizationPolicyRoleBindingDao.class);
        HashSet<String> existingRoles = new HashSet<String>();
        if (roles != null) {
            for (RoleExport role : roles) {
                log.debug((Object)("Importing role: " + role.getRolename()));
                try {
                    List<String> users = roleToUserMap.get(role.getRolename());
                    String[] userarray = users == null ? new String[]{} : users.toArray(new String[0]);
                    IPentahoRole iPentahoRole = roleDao.createRole((ITenant)tenant, role.getRolename(), null, userarray);
                }
                catch (AlreadyExistsException e) {
                    existingRoles.add(role.getRolename());
                    log.info((Object)Messages.getInstance().getString("ROLE.Already.Exists", new Object[]{role.getRolename()}));
                }
                try {
                    if (existingRoles.contains(role.getRolename())) {
                        if (!this.isOverwriteFile()) continue;
                        roleBindingDao.setRoleBindings((ITenant)tenant, role.getRolename(), role.getPermissions());
                        continue;
                    }
                    roleBindingDao.setRoleBindings((ITenant)tenant, role.getRolename(), role.getPermissions());
                }
                catch (Exception e) {
                    log.info((Object)Messages.getInstance().getString("ERROR.SettingRolePermissions", new Object[]{role.getRolename()}), (Throwable)e);
                }
            }
        }
    }

    private boolean isFileHidden(RepositoryFile file, ImportSession.ManifestFile manifestFile, String sourcePath) {
        Boolean result = manifestFile.isFileHidden();
        if (result != null) {
            return result;
        }
        if (file != null) {
            return file.isHidden();
        }
        result = this.solutionHelper.isInHiddenList(sourcePath);
        return result != false;
    }

    private boolean isSchedulable(RepositoryFile file, ImportSession.ManifestFile manifestFile) {
        Boolean result = manifestFile.isFileSchedulable();
        if (result != null) {
            return result;
        }
        if (file != null) {
            return file.isSchedulable();
        }
        return true;
    }

    private String repositoryPathConcat(String path, String ... subPaths) {
        for (String subPath : subPaths) {
            path = RepositoryFilenameUtils.concat((String)path, (String)subPath);
        }
        return path;
    }

    @Override
    public List<IMimeType> getMimeTypes() {
        return this.mimeTypes;
    }

    public IPlatformImportBundle build(RepositoryFileImportBundle.Builder builder) {
        return builder != null ? builder.build() : null;
    }

    public Response createSchedulerJob(SchedulerResource scheduler, JobScheduleRequest jobScheduleRequest) throws IOException {
        Response rs;
        Response response = rs = scheduler != null ? scheduler.createJob(jobScheduleRequest) : null;
        if (jobScheduleRequest.getJobState() != Job.JobState.NORMAL) {
            JobRequest jobRequest = new JobRequest();
            jobRequest.setJobId(rs.getEntity().toString());
            scheduler.pauseJob(jobRequest);
        }
        return rs;
    }

    public boolean isOverwriteFile() {
        return this.overwriteFile;
    }

    public void setOverwriteFile(boolean overwriteFile) {
        this.overwriteFile = overwriteFile;
    }

    class SolutionRepositoryImportSource {
        private ZipInputStream zipInputStream;
        private List<ImportSource.IRepositoryFileBundle> files;

        public SolutionRepositoryImportSource(ZipInputStream zipInputStream) {
            this.zipInputStream = zipInputStream;
            this.files = new ArrayList<ImportSource.IRepositoryFileBundle>();
            this.initialize();
        }

        protected void initialize() {
            try {
                ZipEntry entry = this.zipInputStream.getNextEntry();
                while (entry != null) {
                    String entryName = RepositoryFilenameUtils.separatorsToRepository((String)entry.getName());
                    File tempFile = null;
                    boolean isDir = entry.isDirectory();
                    if (!isDir) {
                        if (!SolutionImportHandler.this.solutionHelper.isInApprovedExtensionList(entryName)) {
                            this.zipInputStream.closeEntry();
                            entry = this.zipInputStream.getNextEntry();
                            continue;
                        }
                        tempFile = File.createTempFile("zip", null);
                        tempFile.deleteOnExit();
                        FileOutputStream fos = new FileOutputStream(tempFile);
                        IOUtils.copy((InputStream)this.zipInputStream, (OutputStream)fos);
                        fos.close();
                    }
                    File file = new File(entryName);
                    RepositoryFile repoFile = new RepositoryFile.Builder(file.getName()).folder(isDir).hidden(false).build();
                    String parentDir = new File(entryName).getParent() == null ? "/" : new File(entryName).getParent() + "/";
                    RepositoryFileBundle repoFileBundle = new RepositoryFileBundle(repoFile, null, parentDir, tempFile, "UTF-8", null);
                    if (file.getName().equals("exportManifest.xml")) {
                        this.initializeAclManifest(repoFileBundle);
                    } else {
                        this.files.add(repoFileBundle);
                    }
                    this.zipInputStream.closeEntry();
                    entry = this.zipInputStream.getNextEntry();
                }
                this.zipInputStream.close();
            }
            catch (IOException exception) {
                String errorMessage = Messages.getInstance().getErrorString("", new Object[]{exception.getLocalizedMessage()});
                log.trace((Object)errorMessage);
            }
        }

        private void initializeAclManifest(ImportSource.IRepositoryFileBundle file) {
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)file.getInputStream());
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                SolutionImportHandler.this.getImportSession().setManifest(ExportManifest.fromXml(in));
            }
            catch (Exception e) {
                log.trace((Object)e);
            }
        }

        public List<ImportSource.IRepositoryFileBundle> getFiles() {
            return this.files;
        }
    }
}

