/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.plugin.services.importexport.ExportException;
import org.pentaho.platform.plugin.services.importexport.ExportHandler;

public abstract class BaseExportProcessor {
    private String path;
    List<ExportHandler> exportHandlerList = new ArrayList<ExportHandler>();
    IUnifiedRepository unifiedRepository;
    protected static final String EXPORT_MANIFEST_FILENAME = "exportManifest.xml";
    protected static final String EXPORT_INFO_DATE_FORMAT = "dd-MM-yyyy";
    protected static final String EXPORT_INFO_TIME_FORMAT = "hh:mm:ss z";
    protected static final String EXPORT_TEMP_FILENAME_PREFIX = "repoExport";
    protected static final String EXPORT_TEMP_FILENAME_EXT = ".zip";
    protected static final String LOCALE_EXT = ".locale";

    public void addExportHandler(ExportHandler exportHandler) {
        this.exportHandlerList.add(exportHandler);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public IUnifiedRepository getUnifiedRepository() {
        return this.unifiedRepository;
    }

    public void setUnifiedRepository(IUnifiedRepository unifiedRepository) {
        this.unifiedRepository = unifiedRepository;
    }

    public abstract File performExport(RepositoryFile var1) throws ExportException, IOException;

    public abstract void exportDirectory(RepositoryFile var1, OutputStream var2, String var3) throws ExportException, IOException;

    public abstract void exportFile(RepositoryFile var1, OutputStream var2, String var3) throws ExportException, IOException;
}

