/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport.legacy;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.plugin.services.importexport.ImportSource;
import org.pentaho.platform.plugin.services.importexport.RepositoryFileBundle;
import org.pentaho.platform.plugin.services.importexport.legacy.AbstractImportSource;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.springframework.util.Assert;

public class FileSolutionRepositoryImportSource
extends AbstractImportSource {
    private static final Log log = LogFactory.getLog(FileSolutionRepositoryImportSource.class);
    private String charSet;
    private String filename;
    private final String sourceParentFilePath;
    private final List<ImportSource.IRepositoryFileBundle> files = new ArrayList<ImportSource.IRepositoryFileBundle>();
    private boolean recursive;

    public FileSolutionRepositoryImportSource(File sourceFile, String charSet) {
        this(sourceFile, sourceFile.getName(), charSet);
    }

    public FileSolutionRepositoryImportSource(File sourceFile, String filename, String charSet) {
        Assert.notNull((Object)sourceFile);
        Assert.hasText((String)filename);
        Assert.hasText((String)charSet);
        this.filename = filename;
        this.charSet = charSet;
        this.recursive = sourceFile.isDirectory();
        this.sourceParentFilePath = sourceFile.getAbsoluteFile().getPath();
        this.addFileToList(sourceFile, false);
        log.debug((Object)("File list built - size=" + this.files.size()));
    }

    @Override
    public Iterable<ImportSource.IRepositoryFileBundle> getFiles() {
        return this.files;
    }

    @Override
    public int getCount() {
        return this.files.size();
    }

    protected void addFileToList(File currentFile, boolean extractFilename) {
        if (currentFile == null || !currentFile.exists() || currentFile.isDirectory() && currentFile.getName().equals(".svn")) {
            return;
        }
        String filename = extractFilename ? currentFile.getName() : this.filename;
        this.files.add(this.getFile(currentFile, filename));
        if (currentFile.isDirectory()) {
            for (File child : currentFile.listFiles()) {
                this.addFileToList(child, true);
            }
        }
    }

    protected ImportSource.IRepositoryFileBundle getFile(File currentFile, String filename) {
        String name = filename;
        boolean directory = currentFile.isDirectory();
        boolean hidden = false;
        Date lastModifiedDate = new Date(currentFile.lastModified());
        RepositoryFile repoFile = new RepositoryFile.Builder(name).folder(directory).hidden(false).lastModificationDate(lastModifiedDate).build();
        String repoPath = this.getRepositoryPath(currentFile);
        String extension = RepositoryFilenameUtils.getExtension((String)filename);
        return new RepositoryFileBundle(repoFile, null, repoPath, currentFile, this.charSet, this.getMimeType(extension.toLowerCase()));
    }

    protected String getRepositoryPath(File currentFile) {
        String repositoryPath = "";
        if (this.recursive) {
            String parentFilePath = currentFile.getAbsoluteFile().getParent();
            repositoryPath = StringUtils.substring((String)parentFilePath, (int)this.sourceParentFilePath.length());
        }
        return repositoryPath;
    }
}

