/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IContentGeneratorInfo;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPlatformPlugin;
import org.pentaho.platform.api.engine.IPluginLifecycleListener;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginManagerListener;
import org.pentaho.platform.api.engine.IPluginProvider;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.IServiceConfig;
import org.pentaho.platform.api.engine.IServiceManager;
import org.pentaho.platform.api.engine.ISolutionFileMetaProvider;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.engine.PlatformPluginRegistrationException;
import org.pentaho.platform.api.engine.PluginBeanDefinition;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.api.engine.PluginLifecycleException;
import org.pentaho.platform.api.engine.PluginServiceDefinition;
import org.pentaho.platform.api.engine.ServiceException;
import org.pentaho.platform.api.engine.ServiceInitializationException;
import org.pentaho.platform.api.engine.perspective.IPluginPerspectiveManager;
import org.pentaho.platform.api.engine.perspective.pojo.IPluginPerspective;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.StandaloneSpringPentahoObjectFactory;
import org.pentaho.platform.engine.core.system.objfac.spring.PentahoBeanScopeValidatorPostProcessor;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.pluginmgr.PluginClassLoader;
import org.pentaho.platform.plugin.services.pluginmgr.PluginMessageLogger;
import org.pentaho.platform.plugin.services.pluginmgr.servicemgr.ServiceConfig;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.ui.xul.XulOverlay;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DefaultPluginManager
implements IPluginManager {
    private static final Log logger = LogFactory.getLog(DefaultPluginManager.class);
    private static final String DEFAULT_PERSPECTIVE = "generatedContent";
    private static final String METAPROVIDER_KEY_PREFIX = "METAPROVIDER-";
    protected Map<String, ClassLoader> classLoaderMap = Collections.synchronizedMap(new HashMap());
    protected Map<String, GenericApplicationContext> beanFactoryMap = Collections.synchronizedMap(new HashMap());
    protected Map<String, IPlatformPlugin> registeredPlugins = new Hashtable<String, IPlatformPlugin>();
    protected Map<String, IContentInfo> contentTypeByExtension = Collections.synchronizedMap(new HashMap());
    protected List<XulOverlay> overlaysCache = Collections.synchronizedList(new ArrayList());

    public Set<String> getContentTypes() {
        return Collections.unmodifiableSet(this.contentTypeByExtension.keySet());
    }

    public List<XulOverlay> getOverlays() {
        return Collections.unmodifiableList(this.overlaysCache);
    }

    public IContentInfo getContentTypeInfo(String type) {
        return this.contentTypeByExtension.get(type);
    }

    private void unloadPlugins() {
        this.overlaysCache.clear();
        this.classLoaderMap.clear();
        this.contentTypeByExtension.clear();
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            try {
                plugin.unLoaded();
            }
            catch (Throwable t) {
                String msg = Messages.getInstance().getErrorString("PluginManager.ERROR_0014_PLUGIN_FAILED_TO_PROPERLY_UNLOAD", new Object[]{plugin.getId()});
                Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
                PluginMessageLogger.add(msg);
            }
        }
        this.registeredPlugins.clear();
    }

    public List<String> getRegisteredPlugins() {
        ArrayList<String> pluginIds = new ArrayList<String>(this.registeredPlugins.size());
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            pluginIds.add(plugin.getId());
        }
        return pluginIds;
    }

    @Deprecated
    public final boolean reload(IPentahoSession session) {
        return this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean reload() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        boolean anyErrors = false;
        IPluginProvider pluginProvider = (IPluginProvider)PentahoSystem.get(IPluginProvider.class, (String)"IPluginProvider", (IPentahoSession)session);
        List providedPlugins = null;
        try {
            Map<String, IPlatformPlugin> map = this.registeredPlugins;
            synchronized (map) {
                this.unloadPlugins();
            }
            providedPlugins = pluginProvider.getPlugins(session);
        }
        catch (PlatformPluginRegistrationException e1) {
            Iterator msg = Messages.getInstance().getErrorString("PluginManager.ERROR_0012_PLUGIN_DISCOVERY_FAILED");
            Logger.error((String)this.getClass().toString(), (String)((Object)msg), (Throwable)e1);
            PluginMessageLogger.add((String)((Object)msg));
            anyErrors = true;
        }
        List e1 = providedPlugins;
        synchronized (e1) {
            String msg;
            for (IPlatformPlugin plugin : providedPlugins) {
                try {
                    this.registeredPlugins.put(plugin.getId(), plugin);
                    ClassLoader loader = this.setPluginClassLoader(plugin);
                    this.initializeBeanFactory(plugin, loader);
                }
                catch (Throwable t) {
                    anyErrors = true;
                    msg = Messages.getInstance().getErrorString("PluginManager.ERROR_0011_FAILED_TO_REGISTER_PLUGIN", new Object[]{plugin.getId()});
                    Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
                    PluginMessageLogger.add(msg);
                }
            }
            this.registeredPlugins.clear();
            for (IPlatformPlugin plugin : providedPlugins) {
                try {
                    GenericApplicationContext beanFactory = this.beanFactoryMap.get(plugin.getId());
                    if (beanFactory != null) {
                        beanFactory.refresh();
                    }
                    this.registerPlugin(plugin);
                    this.registeredPlugins.put(plugin.getId(), plugin);
                }
                catch (Throwable t) {
                    anyErrors = true;
                    msg = Messages.getInstance().getErrorString("PluginManager.ERROR_0011_FAILED_TO_REGISTER_PLUGIN", new Object[]{plugin.getId()});
                    Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
                    PluginMessageLogger.add(msg);
                }
            }
        }
        IServiceManager svcManager = (IServiceManager)PentahoSystem.get(IServiceManager.class, null);
        if (svcManager != null) {
            try {
                svcManager.initServices();
            }
            catch (ServiceInitializationException e) {
                String msg = Messages.getInstance().getErrorString("PluginManager.ERROR_0022_SERVICE_INITIALIZATION_FAILED");
                Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)e);
                PluginMessageLogger.add(msg);
            }
        }
        return !anyErrors;
    }

    private static void bootStrapPlugin(IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        Object listener = null;
        try {
            if (!StringUtils.isEmpty((String)plugin.getLifecycleListenerClassname())) {
                listener = loader.loadClass(plugin.getLifecycleListenerClassname()).newInstance();
            }
        }
        catch (Throwable t) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0017_COULD_NOT_LOAD_PLUGIN_LIFECYCLE_LISTENER", new Object[]{plugin.getId(), plugin.getLifecycleListenerClassname()}), t);
        }
        if (listener != null) {
            if (!IPluginLifecycleListener.class.isAssignableFrom(listener.getClass())) {
                throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0016_PLUGIN_LIFECYCLE_LISTENER_WRONG_TYPE", new Object[]{plugin.getId(), plugin.getLifecycleListenerClassname()}));
            }
            plugin.addLifecycleListener((IPluginLifecycleListener)listener);
        }
    }

    private void registerPlugin(IPlatformPlugin plugin) throws PlatformPluginRegistrationException, PluginLifecycleException {
        if (StringUtils.isEmpty((String)plugin.getId())) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0026_PLUGIN_INVALID", new Object[]{plugin.getSourceDescription()}));
        }
        if (this.registeredPlugins.containsKey(plugin.getId())) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0024_PLUGIN_ALREADY_LOADED_BY_SAME_NAME", new Object[]{plugin.getId()}));
        }
        ClassLoader loader = this.setPluginClassLoader(plugin);
        DefaultPluginManager.bootStrapPlugin(plugin, loader);
        plugin.init();
        this.registerContentTypes(plugin, loader);
        this.registerContentGenerators(plugin, loader);
        this.registerPerspectives(plugin, loader);
        this.overlaysCache.addAll(plugin.getOverlays());
        this.registerServices(plugin, loader);
        PluginMessageLogger.add(Messages.getInstance().getString("PluginManager.PLUGIN_REGISTERED", new Object[]{plugin.getId()}));
        try {
            plugin.loaded();
        }
        catch (Throwable t) {
            String msg = Messages.getInstance().getErrorString("PluginManager.ERROR_0015_PLUGIN_LOADED_HANDLING_FAILED", new Object[]{plugin.getId()});
            Logger.error((String)this.getClass().toString(), (String)msg, (Throwable)t);
            PluginMessageLogger.add(msg);
        }
    }

    private void registerPerspectives(IPlatformPlugin plugin, ClassLoader loader) {
        for (IPluginPerspective pluginPerspective : plugin.getPluginPerspectives()) {
            ((IPluginPerspectiveManager)PentahoSystem.get(IPluginPerspectiveManager.class)).addPluginPerspective(pluginPerspective);
        }
    }

    protected void registerContentTypes(IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        for (IContentInfo info : plugin.getContentInfos()) {
            this.contentTypeByExtension.put(info.getExtension(), info);
            String metaProviderClass = (String)plugin.getMetaProviderMap().get(info.getExtension());
            if (StringUtils.isEmpty((String)metaProviderClass)) continue;
            Class<?> clazz = null;
            String defaultErrMsg = Messages.getInstance().getErrorString("PluginManager.ERROR_0013_FAILED_TO_SET_CONTENT_TYPE_META_PROVIDER", new Object[]{metaProviderClass, info.getExtension()});
            try {
                clazz = loader.loadClass(metaProviderClass);
            }
            catch (Exception e) {
                throw new PlatformPluginRegistrationException(defaultErrMsg, (Throwable)e);
            }
            if (!ISolutionFileMetaProvider.class.isAssignableFrom(clazz)) {
                throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0019_WRONG_TYPE_FOR_CONTENT_TYPE_META_PROVIDER", new Object[]{metaProviderClass, info.getExtension()}));
            }
            this.assertUnique(plugin.getId(), METAPROVIDER_KEY_PREFIX + info.getExtension());
            AbstractBeanDefinition beanDef = BeanDefinitionBuilder.rootBeanDefinition((String)metaProviderClass).setScope("prototype").getBeanDefinition();
            this.beanFactoryMap.get(plugin.getId()).registerBeanDefinition(METAPROVIDER_KEY_PREFIX + info.getExtension(), (BeanDefinition)beanDef);
        }
    }

    protected BeanFactory getNativeBeanFactory(IPlatformPlugin plugin, final ClassLoader loader) {
        Object nativeFactory = null;
        if (plugin.getBeanFactory() != null) {
            ListableBeanFactory testFactory = plugin.getBeanFactory();
            if (testFactory instanceof ConfigurableBeanFactory) {
                ((ConfigurableBeanFactory)testFactory).setBeanClassLoader(loader);
            } else {
                logger.warn((Object)Messages.getInstance().getString("PluginManager.WARN_WRONG_BEAN_FACTORY_TYPE"));
            }
            nativeFactory = testFactory;
        } else {
            File f = new File(((PluginClassLoader)loader).getPluginDir(), "plugin.spring.xml");
            if (f.exists()) {
                logger.debug((Object)("Found plugin spring file @ " + f.getAbsolutePath()));
                FileSystemResource fsr = new FileSystemResource(f);
                GenericApplicationContext appCtx = new GenericApplicationContext(){

                    protected void prepareBeanFactory(ConfigurableListableBeanFactory clBeanFactory) {
                        super.prepareBeanFactory(clBeanFactory);
                        clBeanFactory.setBeanClassLoader(loader);
                    }

                    public ClassLoader getClassLoader() {
                        return loader;
                    }
                };
                XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appCtx);
                xmlReader.setBeanClassLoader(loader);
                xmlReader.loadBeanDefinitions((Resource)fsr);
                nativeFactory = appCtx;
            }
        }
        return nativeFactory;
    }

    protected void initializeBeanFactory(IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        if (!(loader instanceof PluginClassLoader)) {
            logger.warn((Object)"Can't determine plugin dir to load spring file because classloader is not of type PluginClassLoader.  This is since we are probably in a unit test");
            return;
        }
        BeanFactory nativeBeanFactory = this.getNativeBeanFactory(plugin, loader);
        GenericApplicationContext beanFactory = null;
        if (nativeBeanFactory != null && nativeBeanFactory instanceof GenericApplicationContext) {
            beanFactory = (GenericApplicationContext)nativeBeanFactory;
        } else {
            beanFactory = new GenericApplicationContext();
            beanFactory.setClassLoader(loader);
            beanFactory.getBeanFactory().setBeanClassLoader(loader);
            if (nativeBeanFactory != null) {
                beanFactory.getBeanFactory().setParentBeanFactory(nativeBeanFactory);
            }
        }
        beanFactory.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PentahoBeanScopeValidatorPostProcessor());
        this.beanFactoryMap.put(plugin.getId(), beanFactory);
        Iterator iterator = plugin.getBeans().iterator();
        while (iterator.hasNext()) {
            PluginBeanDefinition def;
            def.setBeanId((def = (PluginBeanDefinition)iterator.next()).getBeanId() == null ? def.getClassname() : def.getBeanId());
            this.assertUnique(plugin.getId(), def.getBeanId());
            AbstractBeanDefinition beanDef = BeanDefinitionBuilder.rootBeanDefinition((String)def.getClassname()).setScope("prototype").getBeanDefinition();
            beanFactory.registerBeanDefinition(def.getBeanId(), (BeanDefinition)beanDef);
        }
        StandaloneSpringPentahoObjectFactory pentahoFactory = new StandaloneSpringPentahoObjectFactory("Plugin Factory ( " + plugin.getId() + " )");
        pentahoFactory.init(null, (Object)beanFactory);
    }

    protected void assertUnique(String pluginId, String beanId) throws PlatformPluginRegistrationException {
        if (this.beanFactoryMap.get(pluginId).containsBean(beanId)) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0018_BEAN_ALREADY_REGISTERED", new Object[]{beanId, pluginId}));
        }
    }

    private void registerServices(IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        IServiceManager svcManager = (IServiceManager)PentahoSystem.get(IServiceManager.class, null);
        for (PluginServiceDefinition pws : plugin.getServices()) {
            for (ServiceConfig ws : this.createServiceConfigs(pws, plugin, loader)) {
                try {
                    svcManager.registerService((IServiceConfig)ws);
                }
                catch (ServiceException e) {
                    throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0025_SERVICE_REGISTRATION_FAILED", new Object[]{ws.getId(), plugin.getId()}), (Throwable)e);
                }
            }
        }
    }

    private Collection<ServiceConfig> createServiceConfigs(PluginServiceDefinition pws, IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        ArrayList<ServiceConfig> services = new ArrayList<ServiceConfig>();
        if (pws.getTypes() == null || pws.getTypes().length < 1) {
            throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0023_SERVICE_TYPE_UNSPECIFIED", new Object[]{pws.getId()}));
        }
        for (String type : pws.getTypes()) {
            String serviceId;
            String serviceClassName;
            ServiceConfig ws = new ServiceConfig();
            ws.setServiceType(type);
            ws.setTitle(pws.getTitle());
            ws.setDescription(pws.getDescription());
            String string = serviceClassName = StringUtils.isEmpty((String)pws.getServiceClass()) ? pws.getServiceBeanId() : pws.getServiceClass();
            if (!StringUtils.isEmpty((String)pws.getId())) {
                serviceId = pws.getId();
            } else {
                serviceId = serviceClassName;
                if (serviceClassName.indexOf(46) > 0) {
                    serviceId = serviceClassName.substring(serviceClassName.lastIndexOf(46) + 1);
                }
            }
            ws.setId(serviceId);
            String serviceClassKey = ws.getServiceType() + "-" + ws.getId() + "/" + serviceClassName;
            this.assertUnique(plugin.getId(), serviceClassKey);
            AbstractBeanDefinition beanDef = BeanDefinitionBuilder.rootBeanDefinition((String)serviceClassName).setScope("prototype").getBeanDefinition();
            this.beanFactoryMap.get(plugin.getId()).registerBeanDefinition(serviceClassKey, (BeanDefinition)beanDef);
            if (!this.isBeanRegistered(serviceClassKey)) {
                throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0020_NO_SERVICE_CLASS_REGISTERED", new Object[]{serviceClassKey}));
            }
            try {
                ws.setServiceClass(this.loadClass(serviceClassKey));
                ArrayList classes = new ArrayList();
                if (pws.getExtraClasses() != null) {
                    for (String extraClass : pws.getExtraClasses()) {
                        classes.add(this.loadClass(extraClass));
                    }
                }
                ws.setExtraClasses(classes);
            }
            catch (PluginBeanException e) {
                throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0021_SERVICE_CLASS_LOAD_FAILED", new Object[]{serviceClassKey}), (Throwable)e);
            }
            services.add(ws);
        }
        return services;
    }

    private ClassLoader setPluginClassLoader(IPlatformPlugin plugin) throws PlatformPluginRegistrationException {
        ClassLoader loader = this.classLoaderMap.get(plugin.getId());
        if (loader == null) {
            String pluginDirPath = PentahoSystem.getApplicationContext().getSolutionPath("system/" + plugin.getSourceDescription());
            pluginDirPath = pluginDirPath.replace("//", "/");
            Logger.debug((Object)this, (String)("plugin dir for " + plugin.getId() + " is [" + pluginDirPath + "]"));
            File pluginDir = new File(pluginDirPath);
            if (!(pluginDir.exists() && pluginDir.isDirectory() && pluginDir.canRead())) {
                throw new PlatformPluginRegistrationException(Messages.getInstance().getErrorString("PluginManager.ERROR_0027_PLUGIN_DIR_UNAVAILABLE", new Object[]{pluginDir.getAbsolutePath()}));
            }
            loader = new PluginClassLoader(pluginDir, this.getClass().getClassLoader());
            if (plugin.getLoaderType() == IPlatformPlugin.ClassLoaderType.OVERRIDING) {
                ((PluginClassLoader)loader).setOverrideLoad(true);
            }
            this.classLoaderMap.put(plugin.getId(), loader);
        }
        return loader;
    }

    public ClassLoader getClassLoader(IPlatformPlugin plugin) {
        return this.getClassLoader(plugin.getId());
    }

    public ClassLoader getClassLoader(String pluginId) {
        return this.classLoaderMap.get(pluginId);
    }

    public ListableBeanFactory getBeanFactory(String pluginId) {
        return this.beanFactoryMap.get(pluginId).getBeanFactory();
    }

    private void registerContentGenerators(IPlatformPlugin plugin, ClassLoader loader) throws PlatformPluginRegistrationException {
        for (IContentGeneratorInfo cgInfo : plugin.getContentGenerators()) {
            AbstractBeanDefinition beanDef = BeanDefinitionBuilder.rootBeanDefinition((String)cgInfo.getClassname()).setScope("prototype").getBeanDefinition();
            GenericApplicationContext factory = this.beanFactoryMap.get(plugin.getId());
            factory.registerBeanDefinition(cgInfo.getId(), (BeanDefinition)beanDef);
            factory.registerAlias(cgInfo.getId(), cgInfo.getType());
            PluginMessageLogger.add(Messages.getInstance().getString("PluginManager.USER_CONTENT_GENERATOR_REGISTERED", new Object[]{cgInfo.getId(), plugin.getId()}));
        }
    }

    public Object getBean(String beanId, Class<?> requiredType) {
        if (beanId == null) {
            throw new IllegalArgumentException("beanId cannot be null");
        }
        Object bean = null;
        for (GenericApplicationContext beanFactory : this.beanFactoryMap.values()) {
            if (!beanFactory.containsBean(beanId)) continue;
            if (requiredType == null) {
                bean = beanFactory.getBean(beanId);
                continue;
            }
            bean = beanFactory.getBean(beanId, requiredType);
        }
        if (bean == null) {
            throw new NoSuchBeanDefinitionException("Could not find bean with id " + beanId);
        }
        return bean;
    }

    public Object getBean(String beanId) throws PluginBeanException {
        if (beanId == null) {
            throw new IllegalArgumentException("beanId cannot be null");
        }
        Object bean = null;
        for (GenericApplicationContext beanFactory : this.beanFactoryMap.values()) {
            if (!beanFactory.containsBean(beanId)) continue;
            try {
                bean = beanFactory.getBean(beanId);
            }
            catch (Throwable ex) {
                throw new PluginBeanException(ex);
            }
        }
        if (bean == null) {
            throw new PluginBeanException(Messages.getInstance().getString("PluginManager.WARN_CLASS_NOT_REGISTERED", new Object[]{beanId}));
        }
        return bean;
    }

    public IContentGenerator getContentGenerator(String type, String perspectiveName) {
        IContentGenerator cg = null;
        if (perspectiveName == null || perspectiveName.equals(DEFAULT_PERSPECTIVE)) {
            cg = (IContentGenerator)this.getBean(type, IContentGenerator.class);
        } else {
            String beanId = perspectiveName == null ? type : type + "." + perspectiveName;
            try {
                cg = (IContentGenerator)this.getBean(beanId, IContentGenerator.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                try {
                    cg = (IContentGenerator)this.getBean(perspectiveName, IContentGenerator.class);
                }
                catch (NoSuchBeanDefinitionException e2) {
                    throw new NoSuchBeanDefinitionException("Failed to find bean: " + e.getMessage() + " : " + e2.getMessage());
                }
            }
        }
        return cg;
    }

    public IAction getAction(String type, String perspectiveName) {
        IAction action = null;
        String beanId = perspectiveName == null ? type : type + "." + perspectiveName;
        try {
            action = (IAction)this.getBean(beanId, IAction.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            try {
                action = (IAction)this.getBean(perspectiveName, IAction.class);
            }
            catch (NoSuchBeanDefinitionException e2) {
                throw new NoSuchBeanDefinitionException("Failed to find bean: " + e.getMessage() + " : " + e2.getMessage());
            }
        }
        return action;
    }

    public Class<?> loadClass(String beanId) throws PluginBeanException {
        if (beanId == null) {
            throw new IllegalArgumentException("beanId cannot be null");
        }
        Class type = null;
        for (GenericApplicationContext beanFactory : this.beanFactoryMap.values()) {
            if (!beanFactory.containsBean(beanId)) continue;
            try {
                type = beanFactory.getType(beanId);
                break;
            }
            catch (Throwable ex) {
                throw new PluginBeanException(ex);
            }
        }
        if (type == null) {
            throw new PluginBeanException(Messages.getInstance().getString("PluginManager.WARN_CLASS_NOT_REGISTERED", new Object[]{beanId}));
        }
        return type;
    }

    public boolean isBeanRegistered(String beanId) {
        if (beanId == null) {
            throw new IllegalArgumentException("beanId cannot be null");
        }
        boolean registered = false;
        for (GenericApplicationContext beanFactory : this.beanFactoryMap.values()) {
            if (!beanFactory.containsBean(beanId)) continue;
            registered = true;
        }
        return registered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAllPlugins() {
        Map<String, IPlatformPlugin> map = this.registeredPlugins;
        synchronized (map) {
            this.unloadPlugins();
        }
    }

    public Object getPluginSetting(IPlatformPlugin plugin, String key, String defaultValue) {
        return this.getPluginSetting(plugin.getId(), key, defaultValue);
    }

    public Object getPluginSetting(String pluginId, String key, String defaultValue) {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        ClassLoader classLoader = this.classLoaderMap.get(pluginId);
        return resLoader.getPluginSetting(classLoader, key, defaultValue);
    }

    private Collection<String> getBeanIdsForType(String pluginId, Class<?> clazz) {
        String[] names;
        ArrayList<String> ids = new ArrayList<String>();
        ConfigurableListableBeanFactory fac = this.beanFactoryMap.get(pluginId).getBeanFactory();
        for (String beanName : names = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)fac, clazz)) {
            ids.add(beanName);
            for (String beanAlias : fac.getAliases(beanName)) {
                ids.add(beanAlias);
            }
        }
        return ids;
    }

    public String getPluginIdForType(String contentType) {
        for (String pluginId : this.getRegisteredPlugins()) {
            Iterator<String> iterator = this.getBeanIdsForType(pluginId, IContentGenerator.class).iterator();
            while (iterator.hasNext()) {
                String beanId;
                String serviceContentType = beanId = iterator.next();
                if (beanId.contains(".")) {
                    serviceContentType = beanId.substring(0, beanId.indexOf(46));
                }
                if (!contentType.equals(serviceContentType)) continue;
                return pluginId;
            }
        }
        return null;
    }

    @Deprecated
    public IContentGenerator getContentGeneratorForType(String type, IPentahoSession session) throws ObjectFactoryException {
        try {
            return this.getContentGenerator(type, null);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new ObjectFactoryException((Throwable)e);
        }
    }

    public String getPluginIdForClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        for (String pluginId : this.classLoaderMap.keySet()) {
            ClassLoader maybeClassLoader = this.classLoaderMap.get(pluginId);
            if (!maybeClassLoader.equals(classLoader)) continue;
            return pluginId;
        }
        return null;
    }

    private String trimLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    protected boolean isRequested(String servicePath, String requestPath) {
        String[] servicePathElements;
        String[] requestPathElements = this.trimLeadingSlash(requestPath).split("/");
        if (requestPathElements.length < (servicePathElements = this.trimLeadingSlash(servicePath).split("/")).length) {
            return false;
        }
        for (int i = 0; i < servicePathElements.length; ++i) {
            if (requestPathElements[i].equals(servicePathElements[i])) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public String getServicePlugin(String path) {
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            String pluginId = this.getStaticResourcePluginId(plugin, path);
            if (pluginId != null) {
                return pluginId;
            }
            for (IContentGeneratorInfo contentGenerator : plugin.getContentGenerators()) {
                String cgId = contentGenerator.getId();
                if (!this.isRequested(cgId, path)) continue;
                return plugin.getId();
            }
        }
        return null;
    }

    private String getStaticResourcePluginId(IPlatformPlugin plugin, String path) {
        Map resourceMap = plugin.getStaticResourceMap();
        for (String url : resourceMap.keySet()) {
            if (!this.isRequested(url, path)) continue;
            return plugin.getId();
        }
        return null;
    }

    @Deprecated
    public boolean isStaticResource(String path) {
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            String pluginId = this.getStaticResourcePluginId(plugin, path);
            if (pluginId == null) continue;
            return true;
        }
        return false;
    }

    public boolean isPublic(String pluginId, String path) {
        IPlatformPlugin plugin = this.registeredPlugins.get(pluginId);
        if (plugin == null) {
            return false;
        }
        Map resourceMap = plugin.getStaticResourceMap();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        for (String pluginRelativeDir : resourceMap.values()) {
            if (!path.startsWith(pluginRelativeDir)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public InputStream getStaticResource(String path) {
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            Map resourceMap = plugin.getStaticResourceMap();
            for (String url : resourceMap.keySet()) {
                if (!this.isRequested(url, path)) continue;
                IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
                ClassLoader classLoader = this.classLoaderMap.get(plugin.getId());
                String resourcePath = path.replace(url, (CharSequence)resourceMap.get(url));
                return resLoader.getResourceAsStream(classLoader, resourcePath);
            }
        }
        return null;
    }

    public List<String> getExternalResourcesForContext(String context) {
        ArrayList<String> resources = new ArrayList<String>();
        for (IPlatformPlugin plugin : this.registeredPlugins.values()) {
            List pluginRes = plugin.getExternalResourcesForContext(context);
            if (pluginRes == null) continue;
            resources.addAll(pluginRes);
        }
        return resources;
    }

    public List<String> getPluginRESTPerspectivesForType(String contentType) {
        ArrayList<String> pluginPerspectives = new ArrayList<String>();
        for (String pluginId : this.getRegisteredPlugins()) {
            Iterator<String> iterator = this.getBeanIdsForType(pluginId, IContentGenerator.class).iterator();
            while (iterator.hasNext()) {
                String beanId;
                String serviceContentType = beanId = iterator.next();
                if (beanId.contains(".")) {
                    serviceContentType = beanId.substring(0, beanId.indexOf(46));
                }
                if (serviceContentType == null || !serviceContentType.equals(contentType) || !beanId.contains(".")) continue;
                pluginPerspectives.add(beanId.substring(beanId.lastIndexOf(46), beanId.length()));
            }
        }
        return pluginPerspectives;
    }

    public List<String> getPluginRESTPerspectivesForId(String id) {
        ArrayList<String> pluginPerspectives = new ArrayList<String>();
        for (String pluginId : this.getRegisteredPlugins()) {
            if (!id.equals(pluginId)) continue;
            for (String beanId : this.getBeanIdsForType(pluginId, IContentGenerator.class)) {
                if (!beanId.contains(".")) continue;
                pluginPerspectives.add(beanId.substring(beanId.lastIndexOf(46) + 1, beanId.length()));
            }
        }
        return pluginPerspectives;
    }

    public void addPluginManagerListener(IPluginManagerListener listener) {
    }
}

