/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.pluginmgr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.plugin.services.pluginmgr.PluginClassLoader;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.LocaleHelper;

public class PluginResourceLoader
implements IPluginResourceLoader {
    private File rootDir = null;
    private PluginClassLoader overrideClassloader;
    private String settingsPath = "/settings.xml";

    public void setSettingsPath(String settingsPath) {
        this.settingsPath = settingsPath;
    }

    @Deprecated
    public void setOverrideClassloader(PluginClassLoader pluginClassloader) {
        this.overrideClassloader = pluginClassloader;
    }

    protected PluginClassLoader getOverrideClassloader() {
        return this.overrideClassloader;
    }

    public void setRootDir(File rootDir) {
        this.rootDir = rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getResourceAsBytes(Class<? extends Object> clazz, String resourcePath) {
        InputStream in = this.getResourceAsStream(clazz, resourcePath);
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(in);
        }
        catch (IOException e) {
            Logger.debug((Object)this, (String)"Cannot open stream to resource", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return out.toByteArray();
    }

    public String getResourceAsString(Class<? extends Object> clazz, String resourcePath) throws UnsupportedEncodingException {
        return this.getResourceAsString(clazz, resourcePath, LocaleHelper.getSystemEncoding());
    }

    public String getResourceAsString(Class<? extends Object> clazz, String resourcePath, String charsetName) throws UnsupportedEncodingException {
        byte[] bytes = this.getResourceAsBytes(clazz, resourcePath);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, charsetName);
    }

    public String getSystemRelativePluginPath(ClassLoader classLoader) {
        File dir = this.getPluginDir(classLoader);
        if (dir == null) {
            return null;
        }
        String path = dir.getAbsolutePath().replace("\\", "/");
        int pos = path.lastIndexOf("/system/");
        if (pos != -1) {
            path = path.substring(pos + 8);
        }
        return path;
    }

    protected File getPluginDir(ClassLoader classLoader) {
        if (this.rootDir != null) {
            return this.rootDir;
        }
        if (classLoader instanceof PluginClassLoader) {
            return ((PluginClassLoader)classLoader).getPluginDir();
        }
        return null;
    }

    protected ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader classLoader;
        PluginClassLoader _overrideClassloader = this.getOverrideClassloader();
        ClassLoader classLoader2 = classLoader = _overrideClassloader != null ? _overrideClassloader : clazz.getClassLoader();
        if (!PluginClassLoader.class.isAssignableFrom(classLoader.getClass())) {
            Logger.warn((Object)this, (String)Messages.getInstance().getString("PluginResourceLoader.WARN_CLASS_LOADED_OUTSIDE_OF_PLUGIN_ENV", new Object[]{clazz.getName(), PluginClassLoader.class.getSimpleName(), this.getClass().getSimpleName()}));
        }
        return classLoader;
    }

    public InputStream getResourceAsStream(Class<?> clazz, String resourcePath) {
        ClassLoader classLoader = this.getClassLoader(clazz);
        return this.getResourceAsStream(classLoader, resourcePath);
    }

    public InputStream getResourceAsStream(ClassLoader classLoader, String resourcePath) {
        if (this.getOverrideClassloader() != null) {
            classLoader = this.getOverrideClassloader();
        }
        InputStream in = null;
        File root = this.getPluginDir(classLoader);
        if (root != null) {
            File f = new File(root, resourcePath);
            if (f.canRead()) {
                try {
                    in = new BufferedInputStream(new FileInputStream(f));
                }
                catch (FileNotFoundException e) {
                    Logger.debug((Object)this, (String)"Cannot open stream to resource", (Throwable)e);
                }
            } else {
                in = classLoader.getResourceAsStream(resourcePath);
                if (in == null) {
                    Logger.debug((Object)this, (String)("Cannot find resource defined by path [" + resourcePath + "]"));
                }
            }
        }
        return in;
    }

    public List<URL> findResources(Class<?> clazz, String namePattern) {
        ClassLoader classLoader = this.getClassLoader(clazz);
        return this.findResources(classLoader, namePattern);
    }

    public List<URL> findResources(ClassLoader classLoader, String namePattern) {
        String dirPattern = "";
        String filePattern = "*";
        if (namePattern.contains("/")) {
            String pattern = namePattern.substring(0, namePattern.lastIndexOf(47));
            if (pattern.length() > 0) {
                dirPattern = pattern;
            }
            if ((pattern = namePattern.substring(namePattern.lastIndexOf(47) + 1, namePattern.length())).length() > 0) {
                filePattern = pattern;
            }
        } else {
            filePattern = namePattern;
        }
        WildcardFileFilter fileFilter = new WildcardFileFilter(filePattern);
        IOFileFilter dirFilter = TrueFileFilter.INSTANCE;
        Collection files = FileUtils.listFiles((File)new File(this.getPluginDir(classLoader), dirPattern), (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        Iterator fileIter = files.iterator();
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        while (fileIter.hasNext()) {
            try {
                urls.add(((File)fileIter.next()).toURI().toURL());
            }
            catch (MalformedURLException e) {
                Logger.warn((Object)this, (String)"Could not create url", (Throwable)e);
            }
        }
        return urls;
    }

    public ResourceBundle getResourceBundle(Class<?> clazz, String resourcePath) {
        ResourceBundle bundle = ResourceBundle.getBundle(resourcePath, LocaleHelper.getLocale(), this.getClassLoader(clazz));
        return bundle;
    }

    public String getPluginSetting(Class<?> pluginClass, String key) {
        return this.getPluginSetting(pluginClass, key, null);
    }

    public String getPluginSetting(Class<?> pluginClass, String key, String defaultVal) {
        ClassLoader classLoader = this.getClassLoader(pluginClass);
        String pluginPath = this.getSystemRelativePluginPath(classLoader);
        File absPluginPath = this.getPluginDir(classLoader);
        if (pluginPath == null) {
            Logger.debug((Object)this, (String)Messages.getInstance().getString("PluginResourceLoader.WARN_PLUGIN_PATH_BAD", new Object[]{"" + pluginClass, this.settingsPath, key}));
            return defaultVal;
        }
        File settingsFile = new File(absPluginPath, this.settingsPath);
        if (!settingsFile.exists()) {
            Logger.debug((Object)this, (String)Messages.getInstance().getErrorString("SYSTEMSETTINGS.ERROR_0002_FILE_NOT_IN_SOLUTION", new Object[]{settingsFile.getAbsolutePath()}));
            return defaultVal;
        }
        return PentahoSystem.getSystemSetting((String)(pluginPath + this.settingsPath), (String)key, (String)defaultVal);
    }

    public String getPluginSetting(ClassLoader classLoader, String key, String defaultVal) {
        String pluginPath;
        if (this.getOverrideClassloader() != null) {
            classLoader = this.getOverrideClassloader();
        }
        if ((pluginPath = this.getSystemRelativePluginPath(classLoader)) == null) {
            Logger.debug((Object)this, (String)Messages.getInstance().getString("PluginResourceLoader.WARN_PLUGIN_PATH_BAD", new Object[]{"" + classLoader, this.settingsPath, key}));
            return defaultVal;
        }
        File absPluginPath = this.getPluginDir(classLoader);
        File settingsFile = new File(absPluginPath, this.settingsPath);
        if (!settingsFile.exists()) {
            Logger.debug((Object)this, (String)Messages.getInstance().getErrorString("SYSTEMSETTINGS.ERROR_0002_FILE_NOT_IN_SOLUTION", new Object[]{settingsFile.getAbsolutePath()}));
            return defaultVal;
        }
        return PentahoSystem.getSystemSetting((String)(pluginPath + this.settingsPath), (String)key, (String)defaultVal);
    }
}

