/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap;

import java.util.Arrays;
import java.util.Collection;
import org.pentaho.platform.api.engine.security.IAuthenticationRoleMapper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class DefaultLdapAuthenticationProvider
extends LdapAuthenticationProvider {
    private IAuthenticationRoleMapper roleMapper;
    private String authenticatedRole;

    public DefaultLdapAuthenticationProvider(LdapAuthenticator authenticator, IAuthenticationRoleMapper roleMapper) {
        super(authenticator);
        this.roleMapper = roleMapper;
        this.setAuthenticatedRole(null);
    }

    public DefaultLdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator, IAuthenticationRoleMapper roleMapper) {
        super(authenticator, authoritiesPopulator);
        this.roleMapper = roleMapper;
        this.setAuthenticatedRole(null);
    }

    public DefaultLdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator, IAuthenticationRoleMapper roleMapper, String authenticatedRole) {
        super(authenticator, authoritiesPopulator);
        this.roleMapper = roleMapper;
        this.setAuthenticatedRole(authenticatedRole);
    }

    protected Collection<? extends GrantedAuthority> loadUserAuthorities(DirContextOperations userData, String username, String password) {
        GrantedAuthority[] authorities = super.loadUserAuthorities(userData, username, password).toArray(new GrantedAuthority[0]);
        if (this.roleMapper != null) {
            for (int i = 0; i < authorities.length; ++i) {
                if (authorities[i] == null) continue;
                authorities[i] = new SimpleGrantedAuthority(this.roleMapper.toPentahoRole(authorities[i].getAuthority()));
            }
        }
        return Arrays.asList(authorities);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication authenticate = super.authenticate(authentication);
        for (GrantedAuthority authority : authenticate.getAuthorities()) {
            if (!authority.getAuthority().equals(this.authenticatedRole)) continue;
            return authenticate;
        }
        throw new AuthenticationServiceException("The user doesn't have '" + this.authenticatedRole + "' role.");
    }

    private void setAuthenticatedRole(String authenticatedRole) {
        this.authenticatedRole = authenticatedRole == null ? (String)PentahoSystem.get(String.class, (String)"singleTenantAuthenticatedAuthorityName", null) : authenticatedRole;
    }
}

