/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.webservices;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.AxisServlet;

public class AxisServletHooks
extends AxisServlet {
    private static final long serialVersionUID = 3169157817280586159L;
    protected AxisService axisService;
    protected AxisOperation axisOperation;
    protected OperationContext operationContext;
    protected ServiceContext serviceContext;
    protected MessageContext messageContext;

    public MessageContext getMessageContext() {
        return this.messageContext;
    }

    public void setContext(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    public void setConfiguration(AxisConfiguration axisConfiguration) {
        this.axisConfiguration = axisConfiguration;
    }

    public void setServiceContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void setServletConfig(ServletConfig servletConfig) throws ServletException {
        if (servletConfig != null) {
            this.init(servletConfig);
        }
    }

    public MessageContext createMessageContext(HttpServletRequest request, HttpServletResponse response, boolean invocationType) throws IOException {
        this.messageContext = super.createMessageContext(request, response, invocationType);
        if (this.axisOperation == null) {
            char delim;
            int idx2;
            String contentType = request.getContentType();
            int idx = contentType.indexOf("action=");
            if (idx != -1 && (idx2 = contentType.indexOf(delim = contentType.charAt(idx + 7), idx + 8)) != -1) {
                String actionStr = contentType.substring(idx + 8, idx2);
                String operationName = actionStr.substring(4);
                this.axisOperation = this.axisService.getOperationByAction(operationName);
            }
            this.operationContext = this.serviceContext.createOperationContext(this.axisOperation);
        }
        this.messageContext.setAxisService(this.axisService);
        this.messageContext.setOperationContext(this.operationContext);
        this.messageContext.setAxisOperation(this.axisOperation);
        return this.messageContext;
    }

    public void handlePut(String httpMethodString, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        new AxisServlet.RestRequestProcessor((AxisServlet)this, httpMethodString, request, response).processXMLRequest();
    }

    public void handleGet(String httpMethodString, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AxisServlet.RestRequestProcessor processor = new AxisServlet.RestRequestProcessor((AxisServlet)this, httpMethodString, request, response);
        processor.processURLRequest();
    }

    public void handlePost(String httpMethodString, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doPost(request, response);
    }

    public void setAxisService(AxisService axisService) {
        this.axisService = axisService;
    }

    public void setAxisOperation(AxisOperation axisOperation) {
        this.axisOperation = axisOperation;
    }

    public void setOperationContext(OperationContext operationContext) {
        this.operationContext = operationContext;
    }
}

