/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.webservices.content;

import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.plugin.services.webservices.AxisServletHooks;
import org.pentaho.platform.plugin.services.webservices.AxisUtil;
import org.pentaho.platform.plugin.services.webservices.content.AxisWebServiceRequestDispatcher;
import org.pentaho.platform.plugin.services.webservices.messages.Messages;

public class AxisServiceExecutor
extends AxisWebServiceRequestDispatcher
implements OutTransportInfo {
    private static final long serialVersionUID = -8815968682881342687L;

    @Override
    public void createServiceContent(AxisService axisService, String operationName, AxisConfiguration axisConfiguration, ConfigurationContext context, OutputStream out) throws Exception {
        IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
        HttpServletRequest request = (HttpServletRequest)pathParams.getParameter("httprequest");
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.equalsIgnoreCase("wsdl")) continue;
            axisService.printWSDL(out, AxisUtil.getWebServiceExecuteUrl());
            return;
        }
        HttpServletResponse response = (HttpServletResponse)pathParams.getParameter("httpresponse");
        ServletConfig servletConfig = (ServletConfig)pathParams.getParameter("servletconfig");
        AxisServiceGroup axisServiceGroup = new AxisServiceGroup(context.getAxisConfiguration());
        axisServiceGroup.addService(axisService);
        ServiceGroupContext serviceGroupContext = new ServiceGroupContext(context, axisServiceGroup);
        ServiceContext serviceContext = serviceGroupContext.getServiceContext(axisService);
        AxisOperation axisOperation = axisService.getOperationByAction(operationName);
        OperationContext operationContext = serviceContext.createOperationContext(axisOperation);
        AxisServletHooks hooks = new AxisServletHooks();
        hooks.setContext(context);
        hooks.setServletConfig(servletConfig);
        hooks.setConfiguration(axisConfiguration);
        hooks.initContextRoot(request);
        hooks.setAxisService(axisService);
        hooks.setAxisOperation(axisOperation);
        hooks.setOperationContext(operationContext);
        hooks.setServiceContext(serviceContext);
        hooks.setAxisOperation(axisOperation);
        hooks.setOperationContext(operationContext);
        if (request != null && response != null) {
            try {
                PentahoSessionHolder.setSession((IPentahoSession)this.userSession);
                String method = request.getMethod();
                if ("GET".equalsIgnoreCase(method)) {
                    hooks.handleGet(method, request, response);
                } else if ("POST".equalsIgnoreCase(request.getMethod())) {
                    hooks.handlePost(method, request, response);
                } else if ("PUT".equalsIgnoreCase(request.getMethod())) {
                    hooks.handlePut(method, request, response);
                }
            }
            catch (Exception e) {
                this.processAxisFault(hooks.getMessageContext(), out, e);
                this.error(Messages.getInstance().getErrorString("RunService.ERROR_0001_ERROR_DURING_EXECUTION"), e);
            }
        }
    }

    public String getMimeType() {
        return "text/xml";
    }

    public Log getLogger() {
        return LogFactory.getLog(AxisServiceExecutor.class);
    }

    public void setContentType(String contentType) {
        IContentItem contentItem = this.outputHandler.getOutputContentItem("response", "content", this.instanceId, this.getMimeType());
        contentItem.setMimeType(contentType);
    }
}

