/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.webservices.content;

import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IServiceConfig;
import org.pentaho.platform.plugin.services.webservices.AxisUtil;
import org.pentaho.platform.plugin.services.webservices.SystemSolutionAxisConfigurator;
import org.pentaho.platform.plugin.services.webservices.content.AbstractAxisServiceContentGenerator;
import org.pentaho.platform.plugin.services.webservices.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class HtmlAxisServiceLister
extends AbstractAxisServiceContentGenerator {
    private static final long serialVersionUID = -1772210710764038165L;

    @Override
    public void createContent(AxisConfiguration axisConfiguration, ConfigurationContext context, OutputStream out) throws Exception {
        HashMap serviceMap = axisConfiguration.getServices();
        StringBuilder sb = new StringBuilder();
        this.getPageTitle(serviceMap, sb);
        Collection servicecol = serviceMap.values();
        for (AxisService axisService : servicecol) {
            this.getTitleSection(axisService, axisConfiguration, sb);
            this.getWsdlSection(axisService, sb);
            this.getRunSection(axisService, sb);
            this.getOperationsSection(axisService, sb);
        }
        this.getPageFooter(serviceMap, sb);
        out.write(sb.toString().getBytes(LocaleHelper.getSystemEncoding()));
    }

    protected void getPageTitle(HashMap serviceMap, StringBuilder sb) {
        sb.append("<div id=\"webservicediv\">");
        sb.append("<h1>").append(Messages.getInstance().getString("ListServices.USER_WEB_SERVICES")).append("</h1>\n");
        if (serviceMap.isEmpty()) {
            sb.append(Messages.getInstance().getString("ListServices.USER_NO_SERVICES"));
        }
    }

    protected void getTitleSection(AxisService axisService, AxisConfiguration axisConfiguration, StringBuilder sb) {
        IServiceConfig wsDef = AxisUtil.getSourceDefinition(axisService, (SystemSolutionAxisConfigurator)axisConfiguration.getConfigurator());
        sb.append("<table>\n<tr>\n<td colspan=\"2\"><h2>").append(wsDef.getTitle()).append("</h2></td></tr>\n<tr><td>");
        String serviceDescription = axisService.getDocumentation();
        if (serviceDescription == null || "".equals(serviceDescription)) {
            serviceDescription = Messages.getInstance().getString("WebServicePlugin.USER_NO_DESCRIPTION");
        }
        sb.append(Messages.getInstance().getString("WebServicePlugin.USER_SERVICE_DESCRIPTION")).append("</td><td>").append(serviceDescription).append("</td></tr>\n");
        sb.append("<tr><td>").append(Messages.getInstance().getString("WebServicePlugin.USER_SERVICE_STATUS")).append("</td><td>");
        if (axisService.isActive()) {
            sb.append(Messages.getInstance().getString("WebServicePlugin.USER_ENABLED"));
        } else {
            sb.append(Messages.getInstance().getString("WebServicePlugin.USER_DISABLED"));
        }
    }

    protected void getWsdlSection(AxisService axisService, StringBuilder sb) {
        String wsdlUrl = AxisUtil.getWebServiceWsdlUrl();
        sb.append("<tr><td>").append(Messages.getInstance().getString("WebServicePlugin.USER_SERVICE_WSDL")).append("</td><td><a href=\"").append(wsdlUrl + axisService.getName()).append("\">").append(wsdlUrl + axisService.getName()).append("</a></td></tr>\n");
    }

    protected void getRunSection(AxisService axisService, StringBuilder sb) {
        String serviceUrl = AxisUtil.getWebServiceExecuteUrl();
        sb.append("<tr><td>").append(Messages.getInstance().getString("WebServicePlugin.USER_SERVICE_URL")).append("</td><td><a href=\"").append(serviceUrl + axisService.getName()).append("\">").append(serviceUrl + axisService.getName()).append("</a></td></tr>\n");
    }

    protected void getOperationsSection(AxisService axisService, StringBuilder sb) {
        String serviceUrl = AxisUtil.getWebServiceExecuteUrl();
        Iterator it = axisService.getOperations();
        sb.append("<tr><td valign=\"top\">").append(Messages.getInstance().getString("WebServicePlugin.USER_OPERATIONS")).append("</td><td>");
        if (!it.hasNext()) {
            sb.append(Messages.getInstance().getString("WebServicePlugin.USER_NO_OPERATIONS"));
        } else {
            while (it.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)it.next();
                String opName = axisOperation.getName().getLocalPart();
                String opUrl = serviceUrl + axisService.getName() + "/" + opName;
                sb.append("<a href=\"").append(opUrl).append("\">").append(opName).append("</a>");
                if (!it.hasNext()) continue;
                sb.append("<br/>");
            }
            sb.append("</td></tr>\n</table>\n");
        }
    }

    protected void getPageFooter(HashMap serviceMap, StringBuilder sb) {
        sb.append("</div");
    }

    public String getMimeType() {
        return "text/html";
    }

    public Log getLogger() {
        return LogFactory.getLog(HtmlAxisServiceLister.class);
    }
}

