/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.html.themes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.ui.IThemeManager;
import org.pentaho.platform.api.ui.IThemeResolver;
import org.pentaho.platform.api.ui.ModuleThemeInfo;
import org.pentaho.platform.api.ui.Theme;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.html.themes.PluginThemeResolver;
import org.pentaho.platform.web.html.themes.ServletContextThemeResolver;

public class DefaultThemeManager
implements IThemeManager {
    private static final String THEME_CACHE_REGION = "Themes";
    private static final String SYSTEM_THEMES = "System_Themes";
    private static final String MODULE_THEMES = "Local_Themes";
    private static ICacheManager cache = PentahoSystem.getCacheManager(null);
    private static final Log logger = LogFactory.getLog(DefaultThemeManager.class);
    private List<IThemeResolver> resolvers = new ArrayList<IThemeResolver>();

    public DefaultThemeManager() {
        this.resolvers.add(new PluginThemeResolver());
        this.resolvers.add(new ServletContextThemeResolver());
    }

    public List<String> getSystemThemeIds() {
        ArrayList<String> allThemes = new ArrayList<String>();
        boolean themesFoundInCache = false;
        Set regionKeys = cache.getAllKeysFromRegionCache(THEME_CACHE_REGION);
        if (regionKeys != null && !regionKeys.isEmpty()) {
            for (String key : regionKeys) {
                if (!key.startsWith(SYSTEM_THEMES)) continue;
                themesFoundInCache = true;
                allThemes.add(key.substring(SYSTEM_THEMES.length() + 1));
            }
        }
        if (!themesFoundInCache) {
            Map<String, Theme> themes = this.collectAllSystemThemes();
            for (String name : themes.keySet()) {
                allThemes.add(name);
            }
        }
        return allThemes;
    }

    public Theme getSystemTheme(String themeId) {
        Theme theme = (Theme)cache.getFromRegionCache(THEME_CACHE_REGION, (Object)("System_Themes-" + themeId));
        if (theme == null && (theme = this.collectAllSystemThemes().get(themeId)) == null) {
            logger.error((Object)("Unable to find requested system theme: " + themeId));
        }
        return theme;
    }

    public Theme getModuleTheme(String moduleName, String themeId) {
        if (themeId == null) {
            return null;
        }
        Theme theme = null;
        ModuleThemeInfo moduleThemeInfo = (ModuleThemeInfo)cache.getFromRegionCache(THEME_CACHE_REGION, (Object)("Local_Themes-" + moduleName));
        if (moduleThemeInfo == null && (moduleThemeInfo = this.collectAllModuleThemes().get(moduleName)) == null) {
            logger.debug((Object)("Unable to retrieve module theme for (" + moduleName + ") as the module theme definition was not found"));
            return null;
        }
        for (Theme t : moduleThemeInfo.getModuleThemes()) {
            if (!t.getId().equals(themeId)) continue;
            theme = t;
            break;
        }
        if (theme == null) {
            logger.error((Object)MessageFormat.format("Unable to find requested module theme: %s module: %s", themeId, moduleName));
        }
        return theme;
    }

    public ModuleThemeInfo getModuleThemeInfo(String moduleName) {
        ModuleThemeInfo moduleThemeInfo = (ModuleThemeInfo)cache.getFromRegionCache(THEME_CACHE_REGION, (Object)("Local_Themes-" + moduleName));
        if (moduleThemeInfo == null && (moduleThemeInfo = this.collectAllModuleThemes().get(moduleName)) == null) {
            logger.debug((Object)("Unable to retrieve module theme for (" + moduleName + ") as the module theme definition was not found"));
            return null;
        }
        return moduleThemeInfo;
    }

    public Map<String, ModuleThemeInfo> collectAllModuleThemes() {
        HashMap<String, ModuleThemeInfo> moduleThemes = new HashMap<String, ModuleThemeInfo>();
        for (IThemeResolver resolver : this.resolvers) {
            Map moduleInfo = resolver.getModuleThemes();
            for (String moduleName : moduleInfo.keySet()) {
                cache.putInRegionCache(THEME_CACHE_REGION, (Object)("Local_Themes-" + moduleName), moduleInfo.get(moduleName));
            }
            moduleThemes.putAll(moduleInfo);
        }
        return moduleThemes;
    }

    public Map<String, Theme> collectAllSystemThemes() {
        HashMap<String, Theme> systemThemes = new HashMap<String, Theme>();
        for (IThemeResolver resolver : this.resolvers) {
            Map themes = resolver.getSystemThemes();
            for (String themeId : themes.keySet()) {
                cache.putInRegionCache(THEME_CACHE_REGION, (Object)("System_Themes-" + themeId), themes.get(themeId));
            }
            systemThemes.putAll(themes);
        }
        return systemThemes;
    }

    public void refresh() {
        cache.clearRegionCache(THEME_CACHE_REGION);
        this.collectAllSystemThemes();
        this.collectAllModuleThemes();
    }

    public void setThemeResolvers(List<IThemeResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public List<IThemeResolver> getThemeResolvers() {
        return this.resolvers;
    }

    static {
        cache.addCacheRegion(THEME_CACHE_REGION);
    }
}

