/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginOperation;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.engine.PluginBeanException;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.RepositoryDownloadWhitelist;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.unified.webservices.ExecutableFileTypeDto;
import org.pentaho.platform.util.RepositoryPathEncoder;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.ContentGeneratorDescriptor;
import org.pentaho.platform.web.http.api.resources.FileResource;
import org.pentaho.platform.web.http.api.resources.GeneratorStreamingOutput;
import org.pentaho.platform.web.http.api.resources.JerseyUtil;
import org.pentaho.platform.web.http.api.resources.PluginResource;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

@Path(value="/repos")
public class RepositoryResource
extends AbstractJaxRSResource {
    protected IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
    private static final Log logger = LogFactory.getLog(RepositoryResource.class);
    public static final String GENERATED_CONTENT_PERSPECTIVE = "generatedContent";
    protected IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
    protected RepositoryDownloadWhitelist whitelist;

    @GET
    @Path(value="{pathId : .+}/content")
    @Produces(value={"*/*"})
    @Facet(name="Unsupported")
    public Response doGetFileOrDir(@PathParam(value="pathId") String pathId) throws FileNotFoundException {
        FileResource fileResource = new FileResource(this.httpServletResponse);
        fileResource.setWhitelist(this.whitelist);
        return fileResource.doGetFileOrDir(pathId);
    }

    @GET
    @Path(value="{pathId : .+}/default")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=303, condition="Successfully get the resource."), @ResponseCode(code=404, condition="Failed to find the resource.")})
    public Response doExecuteDefault(@PathParam(value="pathId") String pathId) throws FileNotFoundException, MalformedURLException, URISyntaxException {
        String perspective = null;
        StringBuffer buffer = null;
        String url = null;
        String path = FileResource.idToPath(pathId);
        String extension = path.substring(path.lastIndexOf(46) + 1);
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)PentahoSessionHolder.getSession());
        IContentInfo info = pluginManager.getContentTypeInfo(extension);
        for (IPluginOperation operation : info.getOperations()) {
            if (!operation.getId().equalsIgnoreCase("RUN")) continue;
            perspective = operation.getPerspective();
            break;
        }
        if (perspective == null) {
            perspective = GENERATED_CONTENT_PERSPECTIVE;
        }
        buffer = this.httpServletRequest.getRequestURL();
        String queryString = this.httpServletRequest.getQueryString();
        url = buffer.substring(0, buffer.lastIndexOf("/") + 1) + perspective + (queryString != null && queryString.length() > 0 ? "?" + this.httpServletRequest.getQueryString() : "");
        return Response.seeOther((URI)new URL(url).toURI()).build();
    }

    @Path(value="/{contextId}/{resourceId : .+}")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully get the resource."), @ResponseCode(code=404, condition="Failed to find the resource.")})
    public Response doFormPost(@PathParam(value="contextId") String contextId, @PathParam(value="resourceId") String resourceId, MultivaluedMap<String, String> formParams) throws ObjectFactoryException, PluginBeanException, IOException, URISyntaxException {
        this.httpServletRequest = JerseyUtil.correctPostRequest(formParams, this.httpServletRequest);
        if (logger.isDebugEnabled()) {
            for (Object key : this.httpServletRequest.getParameterMap().keySet()) {
                logger.debug((Object)("param [" + key + "]"));
            }
        }
        return this.doService(contextId, resourceId);
    }

    @Path(value="/{contextId}/{resourceId : .+}")
    @GET
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully get the resource."), @ResponseCode(code=404, condition="Failed to find the resource.")})
    public Response doGet(@PathParam(value="contextId") String contextId, @PathParam(value="resourceId") String resourceId) throws ObjectFactoryException, PluginBeanException, IOException, URISyntaxException {
        if (logger.isDebugEnabled()) {
            for (Object key : this.httpServletRequest.getParameterMap().keySet()) {
                logger.debug((Object)("param [" + key + "]"));
            }
        }
        return this.doService(contextId, resourceId);
    }

    @Path(value="/executableTypes")
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public Response getExecutableTypes() {
        ArrayList<ExecutableFileTypeDto> executableTypes = new ArrayList<ExecutableFileTypeDto>();
        for (String contentType : this.pluginManager.getContentTypes()) {
            IContentInfo contentInfo = this.pluginManager.getContentTypeInfo(contentType);
            ExecutableFileTypeDto executableFileType = new ExecutableFileTypeDto();
            executableFileType.setDescription(contentInfo.getDescription());
            executableFileType.setExtension(contentInfo.getExtension());
            executableFileType.setTitle(contentInfo.getTitle());
            executableFileType.setCanSchedule(this.hasOperationId(contentInfo.getOperations(), "SCHEDULE_NEW"));
            executableFileType.setCanEdit(this.hasOperationId(contentInfo.getOperations(), "EDIT"));
            executableTypes.add(executableFileType);
        }
        GenericEntity<List<ExecutableFileTypeDto>> entity = new GenericEntity<List<ExecutableFileTypeDto>>(executableTypes){};
        return Response.ok((Object)entity).build();
    }

    private boolean hasOperationId(List<IPluginOperation> operations, String operationId) {
        if (operations != null && StringUtils.isNotBlank((String)operationId)) {
            for (IPluginOperation operation : operations) {
                if (operation == null || !StringUtils.isNotBlank((String)operation.getId()) || !operation.getId().equals(operationId) || !StringUtils.isNotBlank((String)operation.getPerspective())) continue;
                return true;
            }
        }
        return false;
    }

    protected Response doService(String contextId, String resourceId) throws ObjectFactoryException, PluginBeanException, IOException, URISyntaxException {
        this.ctxt("Is [{0}] a repository file id?", contextId);
        if (contextId.startsWith(":") || contextId.matches("^[A-z]\t:.*")) {
            RepositoryFile file = this.repository.getFile(FileResource.idToPath(contextId));
            if (file == null) {
                logger.error((Object)MessageFormat.format("Repository file [{0}] not found", contextId));
                return Response.serverError().build();
            }
            Response response = null;
            this.ctxt("Yep, [{0}] is a repository file id", contextId);
            String ext = RepositoryFilenameUtils.getExtension((String)file.getName());
            String pluginId = this.pluginManager.getPluginIdForType(ext);
            if (pluginId == null) {
                response = this.getUrlResponse(file, resourceId);
                if (response != null) {
                    return response;
                }
                logger.error((Object)MessageFormat.format("No plugin was found to service content of type [{0}]", ext));
                return Response.serverError().build();
            }
            response = this.getPluginFileResponse(pluginId, resourceId);
            if (response != null) {
                return response;
            }
            response = this.getRepositoryFileResponse(file.getPath(), resourceId);
            if (response != null) {
                return response;
            }
            RepositoryFileCGFactory fac = new RepositoryFileCGFactory(resourceId, file);
            response = this.getContentGeneratorResponse(fac);
            if (response != null) {
                return response;
            }
        } else {
            this.ctxt("Nope, [{0}] is not a repository file id", contextId);
            this.ctxt("Is [{0}] is a repository file extension?", contextId);
            String pluginId = this.pluginManager.getPluginIdForType(contextId);
            if (pluginId != null) {
                this.ctxt("Yep, [{0}] is a repository file extension", contextId);
                Response response = this.getPluginFileResponse(pluginId, resourceId);
                if (response != null) {
                    return response;
                }
                ContentTypeCGFactory fac = new ContentTypeCGFactory(resourceId, contextId);
                response = this.getContentGeneratorResponse(fac);
                if (response != null) {
                    return response;
                }
            } else {
                this.ctxt("Nope, [{0}] is not a repository file extension", contextId);
                this.ctxt("Is [{0}] is a plugin id?", contextId);
                if (this.pluginManager.getRegisteredPlugins().contains(contextId)) {
                    this.ctxt("Yep, [{0}] is a plugin id", contextId);
                    pluginId = contextId;
                    Response response = this.getPluginFileResponse(pluginId, resourceId);
                    if (response != null) {
                        return response;
                    }
                    DirectCGFactory fac = new DirectCGFactory(resourceId, contextId);
                    response = this.getContentGeneratorResponse(fac);
                    if (response != null) {
                        return response;
                    }
                } else {
                    this.ctxt("Nope, [{0}] is not a plugin id", contextId);
                    logger.warn((Object)MessageFormat.format("Failed to resolve context [{0}]", contextId));
                }
            }
        }
        logger.warn((Object)MessageFormat.format("End of the resolution chain. No resource [{0}] found in context [{1}].", resourceId, contextId));
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    protected Response getUrlResponse(RepositoryFile file, String resourceId) throws MalformedURLException, URISyntaxException {
        String ext = file.getName().substring(file.getName().indexOf(46) + 1);
        if (!ext.equals("url") || !resourceId.equals(GENERATED_CONTENT_PERSPECTIVE)) {
            return null;
        }
        String url = this.extractUrl(file);
        if (!url.trim().startsWith("http")) {
            url = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL() + url;
        }
        return Response.seeOther((URI)new URL(url).toURI()).build();
    }

    protected Response getContentGeneratorResponse(CGFactory fac) {
        IContentGenerator contentGenerator;
        this.rsc("Is [{0}] a content generator ID?", fac.getContentGeneratorId());
        try {
            contentGenerator = fac.create();
        }
        catch (NoSuchBeanDefinitionException e) {
            this.rsc("Nope, [{0}] is not a content generator ID.", fac.getContentGeneratorId());
            return null;
        }
        if (contentGenerator == null) {
            this.rsc("Nope, [{0}] is not a content generator ID.", fac.getContentGeneratorId());
            return null;
        }
        this.rsc("Yep, [{0}] is a content generator ID. Executing (where command path is {1})..", fac.getContentGeneratorId(), fac.getCommand());
        GeneratorStreamingOutput gso = fac.getStreamingOutput(contentGenerator);
        return Response.ok((Object)gso).build();
    }

    protected Response getPluginFileResponse(String pluginId, String filePath) throws IOException {
        PluginResource pluginResource;
        Response readFileResponse;
        this.rsc("Is [{0}] a path to a plugin file?", filePath);
        if (this.pluginManager.isPublic(pluginId, filePath) && (readFileResponse = (pluginResource = new PluginResource(this.httpServletResponse)).readFile(pluginId, filePath)).getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
            this.rsc("Yep, [{0}] is a path to a static plugin file", filePath);
            return readFileResponse;
        }
        this.rsc("Nope, [{0}] is not a path to a static plugin file", filePath);
        return null;
    }

    protected Response getRepositoryFileResponse(String filePath, String relPath) throws IOException {
        this.rsc("Is [{0}] a relative path to a repository file, relative to [{1}]?", relPath, filePath);
        FileResource fileResource = new FileResource(this.httpServletResponse);
        fileResource.setWhitelist(this.whitelist);
        String path = RepositoryFilenameUtils.separatorsToRepository((String)RepositoryFilenameUtils.concat((String)filePath, (String)("../" + relPath)));
        Response response = fileResource.doGetFileOrDir(RepositoryPathEncoder.encodeRepositoryPath((String)path).substring(1));
        if (response.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
            this.rsc("Yep, [{0}] is a repository file", path);
            return response;
        }
        this.rsc("Nope, [{0}] is not a repository file", path);
        return null;
    }

    private void ctxt(String msg, Object ... args) {
        this.debug("[RESOLVING CONTEXT ID] ==> " + msg, args);
    }

    private void rsc(String msg, Object ... args) {
        this.debug("[RESOLVING RESOURCE ID] ==> " + msg, args);
    }

    private void debug(String msg, Object ... args) {
        logger.debug((Object)MessageFormat.format(msg, args));
    }

    protected String extractUrl(RepositoryFile file) {
        SimpleRepositoryFileData data = null;
        data = (SimpleRepositoryFileData)this.repository.getDataForRead(file.getId(), SimpleRepositoryFileData.class);
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)data.getInputStream(), (Writer)writer);
        }
        catch (IOException e) {
            return "";
        }
        String props = writer.toString();
        StringTokenizer tokenizer = new StringTokenizer(props, "\n");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            int pos = line.indexOf(61);
            if (pos <= 0) continue;
            String propname = line.substring(0, pos);
            String value = line.substring(pos + 1);
            if (value != null && value.length() > 0 && value.charAt(value.length() - 1) == '\r') {
                value = value.substring(0, value.length() - 1);
            }
            if (!"URL".equalsIgnoreCase(propname)) continue;
            return value;
        }
        return "";
    }

    public RepositoryDownloadWhitelist getWhitelist() {
        return this.whitelist;
    }

    public void setWhitelist(RepositoryDownloadWhitelist whitelist) {
        this.whitelist = whitelist;
    }

    class DirectCGFactory
    extends CGFactory {
        String pluginId;

        public DirectCGFactory(String contentGeneratorPath, String pluginId) {
            super(contentGeneratorPath);
            this.pluginId = pluginId;
        }

        @Override
        IContentGenerator create() {
            return RepositoryResource.this.pluginManager.getContentGenerator(null, this.contentGeneratorId);
        }

        @Override
        GeneratorStreamingOutput getStreamingOutput(IContentGenerator cg) {
            return new GeneratorStreamingOutput(cg, this, RepositoryResource.this.httpServletRequest, RepositoryResource.this.httpServletResponse, RepositoryResource.this.acceptableMediaTypes, null, this.command);
        }

        @Override
        public String getServicingFileType() {
            return null;
        }

        @Override
        public String getPluginId() {
            return this.pluginId;
        }
    }

    class ContentTypeCGFactory
    extends CGFactory {
        String repoFileExt;

        public ContentTypeCGFactory(String contentGeneratorPath, String repoFileExt) {
            super(contentGeneratorPath);
            this.repoFileExt = repoFileExt;
        }

        @Override
        public IContentGenerator create() {
            return RepositoryResource.this.pluginManager.getContentGenerator(this.repoFileExt, this.contentGeneratorId);
        }

        @Override
        GeneratorStreamingOutput getStreamingOutput(IContentGenerator cg) {
            return new GeneratorStreamingOutput(cg, this, RepositoryResource.this.httpServletRequest, RepositoryResource.this.httpServletResponse, RepositoryResource.this.acceptableMediaTypes, null, this.command);
        }

        @Override
        public String getServicingFileType() {
            return this.repoFileExt;
        }

        @Override
        public String getPluginId() {
            return ((IPluginManager)PentahoSystem.get(IPluginManager.class)).getPluginIdForType(this.repoFileExt);
        }
    }

    class RepositoryFileCGFactory
    extends ContentTypeCGFactory {
        RepositoryFile file;

        public RepositoryFileCGFactory(String contentGeneratorPath, RepositoryFile file) {
            super(contentGeneratorPath, file.getName().substring(file.getName().lastIndexOf(46) + 1));
            this.file = file;
        }

        @Override
        GeneratorStreamingOutput getStreamingOutput(IContentGenerator cg) {
            return new GeneratorStreamingOutput(cg, this, RepositoryResource.this.httpServletRequest, RepositoryResource.this.httpServletResponse, RepositoryResource.this.acceptableMediaTypes, this.file, this.command);
        }
    }

    abstract class CGFactory
    implements ContentGeneratorDescriptor {
        String contentGeneratorId;
        String command;

        public CGFactory(String contentGeneratorPath) {
            if (contentGeneratorPath.contains("/")) {
                this.contentGeneratorId = contentGeneratorPath.substring(0, contentGeneratorPath.indexOf(47));
                this.command = contentGeneratorPath.substring(contentGeneratorPath.indexOf(47) + 1);
                RepositoryResource.this.debug("decomposing path [{0}] into content generator id [{1}] and command [{2}]", new Object[]{contentGeneratorPath, this.contentGeneratorId, this.command});
            } else {
                this.contentGeneratorId = contentGeneratorPath;
            }
        }

        @Override
        public String getContentGeneratorId() {
            return this.contentGeneratorId;
        }

        public String getCommand() {
            return this.command;
        }

        abstract IContentGenerator create();

        abstract GeneratorStreamingOutput getStreamingOutput(IContentGenerator var1);
    }
}

