/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.services;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;

public class RepositoryPublishService {
    private static final Log logger = LogFactory.getLog(RepositoryPublishService.class);
    protected IAuthorizationPolicy policy;
    protected IPlatformImporter platformImporter;

    @Deprecated
    public void writeFile(String pathId, InputStream fileContents, Boolean overwriteFile) throws PlatformImportException, PentahoAccessControlException {
        try {
            this.validateAccess();
        }
        catch (PentahoAccessControlException e) {
            logger.error((Object)e);
            throw e;
        }
        IPlatformImportBundle bundle = this.buildBundle(pathId, fileContents, overwriteFile);
        try {
            this.getPlatformImporter().importFile(bundle);
        }
        catch (PlatformImportException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new InternalError();
        }
    }

    public void publishFile(String pathId, InputStream fileContents, Boolean overwriteFile) throws PlatformImportException, PentahoAccessControlException {
        try {
            this.validateAccess();
        }
        catch (PentahoAccessControlException e) {
            logger.error((Object)e);
            throw e;
        }
        IPlatformImportBundle bundle = this.prepareBundle(pathId, fileContents, overwriteFile);
        try {
            this.getPlatformImporter().importFile(bundle);
        }
        catch (PlatformImportException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException();
        }
    }

    protected void validateAccess() throws PentahoAccessControlException {
        if (!this.getPolicy().isAllowed("org.pentaho.security.publish")) {
            throw new PentahoAccessControlException("Access Denied");
        }
    }

    protected IAuthorizationPolicy getPolicy() {
        if (this.policy == null) {
            this.policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        }
        return this.policy;
    }

    protected IPlatformImporter getPlatformImporter() {
        if (this.platformImporter == null) {
            this.platformImporter = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
        }
        return this.platformImporter;
    }

    @Deprecated
    protected IPlatformImportBundle buildBundle(String pathId, InputStream fileContents, Boolean overwriteFile) {
        File file = new File(pathId);
        RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder().input(fileContents).charSet("UTF-8").hidden(false).schedulable(true).mime("text/xml").path(file.getParent()).name(file.getName()).overwriteFile(overwriteFile);
        return bundleBuilder.build();
    }

    protected IPlatformImportBundle prepareBundle(String fullPath, InputStream fileContents, Boolean overwriteFile) {
        return new RepositoryFileImportBundle.Builder().input(fileContents).charSet("UTF-8").hidden(false).schedulable(true).mime("text/xml").path("/" + FilenameUtils.getPathNoEndSeparator((String)fullPath)).name(FilenameUtils.getName((String)fullPath)).overwriteFile(overwriteFile).build();
    }
}

