/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.utils;

import java.io.InputStream;
import java.util.Map;
import org.pentaho.platform.api.mimetype.IPlatformMimeResolver;
import org.pentaho.platform.api.repository2.unified.Converter;
import org.pentaho.platform.api.repository2.unified.IRepositoryContentConverterHandler;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.RepositoryFilenameUtils;

public class RepositoryFileHelper {
    public static IRepositoryFileData getFileData(RepositoryFile repositoryFile) {
        IRepositoryFileData repositoryFileData = null;
        if (!repositoryFile.isFolder()) {
            String ext = RepositoryFilenameUtils.getExtension((String)repositoryFile.getName());
            if (ext == null || ext.isEmpty()) {
                return null;
            }
            IRepositoryContentConverterHandler converterHandler = (IRepositoryContentConverterHandler)PentahoSystem.get(IRepositoryContentConverterHandler.class);
            if (converterHandler == null) {
                return null;
            }
            Map converters = converterHandler.getConverters();
            Converter converter = (Converter)converters.get(ext);
            if (converter == null) {
                return null;
            }
            IPlatformMimeResolver mimeResolver = (IPlatformMimeResolver)PentahoSystem.get(IPlatformMimeResolver.class);
            if (mimeResolver == null) {
                return null;
            }
            String mimeType = mimeResolver.resolveMimeTypeForFileName(repositoryFile.getName()).getName();
            if (mimeType == null || mimeType.isEmpty()) {
                return null;
            }
            InputStream inputStream = converter.convert(repositoryFile.getId());
            if (inputStream == null) {
                return null;
            }
            repositoryFileData = converter.convert(inputStream, "UTF-8", mimeType);
            if (repositoryFileData == null) {
                return null;
            }
        }
        return repositoryFileData;
    }
}

