/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.context;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IServerStatusProvider;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.status.PeriodicStatusLogger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.PentahoHttpSessionHelper;
import org.pentaho.platform.web.http.context.WebApplicationContext;
import org.pentaho.platform.web.http.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolutionContextListener
implements ServletContextListener {
    protected static String solutionPath;
    protected static String contextPath;
    private static final String DEFAULT_SPRING_CONFIG_FILE_NAME = "pentahoObjects.spring.xml";
    private ServletContext context;
    private static final IServerStatusProvider serverStatusProvider;
    Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent event) {
        IConfiguration config;
        Locale[] locales;
        String textDirection;
        this.context = event.getServletContext();
        String encoding = this.getServerParameter("encoding");
        if (encoding != null) {
            LocaleHelper.setSystemEncoding((String)encoding);
        }
        if ((textDirection = this.getServerParameter("text-direction")) != null) {
            LocaleHelper.setTextDirection((String)textDirection);
        }
        String localeLanguage = this.getServerParameter("locale-language");
        String localeCountry = this.getServerParameter("locale-country");
        boolean localeSet = false;
        if (!StringUtils.isEmpty((String)localeLanguage) && !StringUtils.isEmpty((String)localeCountry) && (locales = Locale.getAvailableLocales()) != null) {
            for (Locale element : locales) {
                if (!element.getLanguage().equals(localeLanguage) || !element.getCountry().equals(localeCountry)) continue;
                LocaleHelper.setLocale((Locale)element);
                localeSet = true;
                break;
            }
        }
        if (!localeSet) {
            LocaleHelper.setLocale((Locale)Locale.getDefault());
        }
        LocaleHelper.setDefaultLocale((Locale)LocaleHelper.getLocale());
        this.logger.info(Messages.getInstance().getString("SolutionContextListener.INFO_INITIALIZING"));
        this.logger.info(Messages.getInstance().getString("SolutionContextListener.INFO_SERVLET_CONTEXT", new Object[]{this.context}));
        contextPath = this.context.getRealPath("");
        this.logger.info(Messages.getInstance().getString("SolutionContextListener.INFO_CONTEXT_PATH", new Object[]{contextPath}));
        solutionPath = PentahoHttpSessionHelper.getSolutionPath(this.context);
        if (StringUtils.isEmpty((String)solutionPath)) {
            String errorMsg = Messages.getInstance().getErrorString("SolutionContextListener.ERROR_0001_NO_ROOT_PATH");
            this.logger.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        this.logger.info(Messages.getInstance().getString("SolutionContextListener.INFO_ROOT_PATH", new Object[]{solutionPath}));
        String fullyQualifiedServerUrl = this.getServerParameter("fully-qualified-server-url");
        if (fullyQualifiedServerUrl == null) {
            fullyQualifiedServerUrl = "http://localhost:8080/pentaho/";
        }
        WebApplicationContext applicationContext = new WebApplicationContext(solutionPath, fullyQualifiedServerUrl, this.context.getRealPath(""), this.context);
        Properties props = new Properties();
        ISystemConfig systemConfig = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
        if (systemConfig != null && (config = systemConfig.getConfiguration("server")) != null) {
            try {
                props.putAll((Map<?, ?>)config.getProperties());
            }
            catch (IOException e) {
                this.logger.error("Could not find/read the server.properties file.");
            }
        }
        Enumeration initParmNames = this.context.getInitParameterNames();
        while (initParmNames.hasMoreElements()) {
            String initParmName = (String)initParmNames.nextElement();
            props.setProperty(initParmName, this.getServerParameter(initParmName, true));
        }
        applicationContext.setProperties(props);
        this.setSystemCfgFile(this.context);
        this.setObjectFactory(this.context);
        serverStatusProvider.setStatus(IServerStatusProvider.ServerStatus.STARTING);
        serverStatusProvider.setStatusMessages(new String[]{"Caution, the system is initializing. Do not shut down or restart the system at this time."});
        PeriodicStatusLogger.start();
        boolean initOk = false;
        try {
            initOk = PentahoSystem.init((IApplicationContext)applicationContext);
        }
        finally {
            this.updateStatusMessages(initOk);
            PeriodicStatusLogger.stop();
        }
        this.showInitializationMessage(initOk, fullyQualifiedServerUrl);
    }

    private void updateStatusMessages(boolean initOk) {
        if (initOk) {
            serverStatusProvider.setStatusMessages(new String[]{"The system has finished initializing."});
        } else {
            serverStatusProvider.setStatusMessages(new String[]{"Warning, one or more errors occurred during the initialization process."});
        }
    }

    protected WebApplicationContext createWebApplicationContext(String fullyQualifiedServerUrl, ServletContext context) {
        return new WebApplicationContext(solutionPath, fullyQualifiedServerUrl, context.getRealPath(""), context);
    }

    private void setObjectFactory(ServletContext context) {
        IPentahoObjectFactory pentahoObjectFactory;
        String SYSTEM_FOLDER = "/system";
        String pentahoObjectFactoryClassName = this.getServerParameter("pentahoObjectFactory");
        String pentahoObjectFactoryConfigFile = this.getServerParameter("pentahoObjectFactoryCfgFile");
        if (StringUtils.isEmpty((String)pentahoObjectFactoryConfigFile)) {
            pentahoObjectFactoryConfigFile = solutionPath + "/system" + "/" + DEFAULT_SPRING_CONFIG_FILE_NAME;
        } else if (-1 == pentahoObjectFactoryConfigFile.indexOf("/")) {
            pentahoObjectFactoryConfigFile = solutionPath + "/system" + "/" + pentahoObjectFactoryConfigFile;
        }
        try {
            Class<?> classObject = Class.forName(pentahoObjectFactoryClassName);
            pentahoObjectFactory = (IPentahoObjectFactory)classObject.newInstance();
        }
        catch (Exception e) {
            String msg = Messages.getInstance().getErrorString("SolutionContextListener.ERROR_0002_BAD_OBJECT_FACTORY", new Object[]{pentahoObjectFactoryClassName});
            throw new RuntimeException(msg, e);
        }
        pentahoObjectFactory.init(pentahoObjectFactoryConfigFile, (Object)context);
        PentahoSystem.registerPrimaryObjectFactory((IPentahoObjectFactory)pentahoObjectFactory);
    }

    private void setSystemCfgFile(ServletContext context) {
        String webSpecifiedSysCfgPath;
        String jvmSpecifiedSysCfgPath = System.getProperty("PENTAHO_SYS_CFG_PATH");
        if (StringUtils.isBlank((String)jvmSpecifiedSysCfgPath) && StringUtils.isNotBlank((String)(webSpecifiedSysCfgPath = this.getServerParameter("pentaho-system-cfg")))) {
            System.setProperty("PENTAHO_SYS_CFG_PATH", webSpecifiedSysCfgPath);
        }
    }

    public void showInitializationMessage(boolean initOk, String fullyQualifiedServerUrl) {
        if (PentahoSystem.getObjectFactory().objectDefined(IVersionHelper.class.getSimpleName())) {
            IVersionHelper helper = (IVersionHelper)PentahoSystem.get(IVersionHelper.class, null);
            if (initOk) {
                System.out.println(Messages.getInstance().getString("SolutionContextListener.INFO_SYSTEM_READY", new Object[]{"(" + helper.getVersionInformation(PentahoSystem.class) + ")", fullyQualifiedServerUrl, solutionPath}));
            } else {
                System.err.println(Messages.getInstance().getString("SolutionContextListener.INFO_SYSTEM_NOT_READY", new Object[]{"(" + helper.getVersionInformation(PentahoSystem.class) + ")", fullyQualifiedServerUrl, solutionPath}));
            }
        }
    }

    protected String getContextPath() {
        return contextPath;
    }

    protected String getRootPath() {
        return solutionPath;
    }

    public void contextDestroyed(ServletContextEvent event) {
        PentahoSystem.shutdown();
        if (LocaleHelper.getLocale() == null) {
            LocaleHelper.setLocale((Locale)Locale.getDefault());
        }
        this.logger.info(Messages.getInstance().getString("SolutionContextListener.INFO_SYSTEM_EXITING"));
    }

    private String getServerParameter(String paramName) {
        return this.getServerParameter(paramName, false);
    }

    private String getServerParameter(String paramName, boolean suppressWarning) {
        String result = this.context.getInitParameter(paramName);
        if (result == null) {
            ISystemConfig config = (ISystemConfig)PentahoSystem.get(ISystemConfig.class);
            result = config.getProperty("server." + paramName);
        } else if (!suppressWarning) {
            this.logger.warn(Messages.getInstance().getString("SolutionContextListener.WARN_WEB_XML_PARAM_DEPRECATED", new Object[]{paramName, result}));
        }
        return result;
    }

    static {
        serverStatusProvider = IServerStatusProvider.LOCATOR.getProvider();
    }
}

