/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.engine.core.system.BasePentahoRequestContext;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;

public class PentahoRequestContextFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(PentahoRequestContextFilter.class);
    static final String FILTER_APPLIED = "__pentaho_request_context_filter_applied";
    private volatile IPentahoRequestContext requestContext;

    private synchronized void initContext(HttpServletRequest httpRequest) {
        if (this.requestContext == null) {
            this.requestContext = new BasePentahoRequestContext(httpRequest.getContextPath());
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        httpRequest.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        try {
            if (this.requestContext == null) {
                this.initContext(httpRequest);
            }
            PentahoRequestContextHolder.setRequestContext((IPentahoRequestContext)this.requestContext);
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        finally {
            PentahoRequestContextHolder.removeRequestContext();
            httpRequest.removeAttribute(FILTER_APPLIED);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"PentahoRequestContextHolder now cleared, as request processing completed");
            }
        }
    }
}

