/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import javax.sql.DataSource;
import mondrian.spi.DataSourceResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.messages.Messages;

public class PentahoDataSourceResolver
implements DataSourceResolver {
    private static final Log logger = LogFactory.getLog(PentahoDataSourceResolver.class);

    public DataSource lookup(String dataSourceName) throws Exception {
        DataSource datasource = null;
        String unboundDsName = null;
        IDBDatasourceService datasourceSvc = null;
        try {
            datasourceSvc = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, PentahoSessionHolder.getSession());
            unboundDsName = datasourceSvc.getDSUnboundName(dataSourceName);
            datasource = datasourceSvc.getDataSource(unboundDsName);
        }
        catch (ObjectFactoryException e) {
            logger.error((Object)Messages.getInstance().getErrorString("PentahoXmlaServlet.ERROR_0002_UNABLE_TO_INSTANTIATE"), (Throwable)e);
            throw e;
        }
        catch (DBDatasourceServiceException e) {
            logger.warn((Object)Messages.getInstance().getString("PentahoXmlaServlet.WARN_0001_UNABLE_TO_FIND_UNBOUND_NAME", new Object[]{dataSourceName, unboundDsName}), (Throwable)e);
            try {
                datasource = datasourceSvc.getDataSource(dataSourceName);
            }
            catch (DBDatasourceServiceException dbse) {
                logger.error((Object)Messages.getInstance().getErrorString("PentahoXmlaServlet.ERROR_0002_UNABLE_TO_INSTANTIATE"), (Throwable)e);
                throw dbse;
            }
        }
        return datasource;
    }
}

