/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.mondrian;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DriverDataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.JndiDataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MondrianUtil;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.ui.datasources.jdbc.connection.DriverConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JndiConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.ui.DataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.JdbcConnectionPanel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.SimpleDataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.mondrian.Messages;
import org.pentaho.reporting.ui.datasources.mondrian.MondrianSecurityDialog;

public abstract class SimpleMondrianDataSourceEditor
extends CommonDialog {
    private JTextField filenameField;
    private JTextField cubeConnectionNameField;
    private SimpleDataSourceDialogModel dialogModel;
    private DesignTimeContext context;
    private MondrianSecurityDialog securityDialog;
    private String jdbcUserText;
    private String jdbcUserField;
    private String jdbcPasswordText;
    private String jdbcPasswordField;
    private String roleText;
    private String roleField;

    public SimpleMondrianDataSourceEditor(DesignTimeContext context) {
        this.init(context);
    }

    public SimpleMondrianDataSourceEditor(DesignTimeContext context, Dialog owner) {
        super(owner);
        this.init(context);
    }

    public SimpleMondrianDataSourceEditor(DesignTimeContext context, Frame owner) {
        super(owner);
        this.init(context);
    }

    protected void init(DesignTimeContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setModal(true);
        this.securityDialog = new MondrianSecurityDialog((Dialog)((Object)this), context);
        this.context = context;
        this.dialogModel = new SimpleDataSourceDialogModel();
        ConfirmEnableHandler confirmAction = new ConfirmEnableHandler();
        this.dialogModel.addPropertyChangeListener((PropertyChangeListener)confirmAction);
        this.cubeConnectionNameField = new JTextField(null, 0);
        this.cubeConnectionNameField.setColumns(30);
        this.cubeConnectionNameField.getDocument().addDocumentListener(confirmAction);
        this.filenameField = new JTextField(null, 0);
        this.filenameField.setColumns(30);
        this.filenameField.getDocument().addDocumentListener(confirmAction);
        super.init();
    }

    protected Component createContentPane() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add("North", this.createConnectionTopPanel());
        contentPanel.add("Center", (Component)new JdbcConnectionPanel((DataSourceDialogModel)this.dialogModel, this.context));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return contentPanel;
    }

    private JPanel createConnectionTopPanel() {
        JPanel masterPanel = new JPanel();
        masterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.anchor = 17;
        masterPanel.add((Component)new JLabel(Messages.getString("MondrianDataSourceEditor.SchemaFileLabel", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        masterPanel.add((Component)this.filenameField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        masterPanel.add((Component)new JButton(new BrowseAction()), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        masterPanel.add(Box.createHorizontalStrut(20), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        masterPanel.add((Component)new JButton(new EditSecurityAction()), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        gbc.anchor = 17;
        masterPanel.add((Component)new JLabel(Messages.getString("MondrianDataSourceEditor.CubeConnectionName", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 5.0;
        masterPanel.add((Component)this.cubeConnectionNameField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.fill = 2;
        masterPanel.add((Component)new JButton(new RefreshSchemaNameAction()), gbc);
        return masterPanel;
    }

    protected abstract AbstractMDXDataFactory createDataFactory();

    public DataFactory performConfiguration(AbstractMDXDataFactory dataFactory) {
        this.setConfirmed(false);
        this.getDialogModel().clear();
        this.roleText = null;
        this.roleField = null;
        this.jdbcUserText = null;
        this.jdbcUserField = null;
        this.jdbcPasswordText = null;
        this.jdbcPasswordField = null;
        if (dataFactory != null) {
            this.roleText = dataFactory.getRole();
            this.roleField = dataFactory.getRoleField();
            this.jdbcUserText = dataFactory.getJdbcUser();
            this.jdbcUserField = dataFactory.getJdbcUserField();
            this.jdbcPasswordText = dataFactory.getJdbcPassword();
            this.jdbcPasswordField = dataFactory.getJdbcPasswordField();
            CubeFileProvider fileProvider = dataFactory.getCubeFileProvider();
            if (fileProvider != null) {
                this.setSchemaFileName(fileProvider.getDesignTimeFile());
            } else {
                this.setSchemaFileName("");
            }
            JdbcConnectionDefinition definition = this.createConnectionDefinition(dataFactory);
            this.getDialogModel().addConnection(definition);
            this.getDialogModel().getConnections().setSelectedItem(definition);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        if (!this.isConfirmed()) {
            return null;
        }
        return this.createDataFactory();
    }

    protected JdbcConnectionDefinition createConnectionDefinition(AbstractMDXDataFactory dataFactory) {
        DataSourceProvider provider;
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        String customName = dataFactory.getDesignTimeName();
        if (customName == null) {
            customName = Messages.getString("MondrianDataSourceEditor.CustomConnection", new Object[0]);
        }
        if ((provider = dataFactory.getDataSourceProvider()) instanceof DriverDataSourceProvider) {
            DriverDataSourceProvider dcp = (DriverDataSourceProvider)provider;
            DefaultComboBoxModel model = this.dialogModel.getConnections();
            for (int i = 0; i < model.getSize(); ++i) {
                DriverConnectionDefinition dcd;
                JdbcConnectionDefinition definition = (JdbcConnectionDefinition)model.getElementAt(i);
                if (!(definition instanceof DriverConnectionDefinition) || !ObjectUtilities.equal((Object)(dcd = (DriverConnectionDefinition)definition).getDriverClass(), (Object)dcp.getDriver()) || !ObjectUtilities.equal((Object)dcd.getUsername(), (Object)dcp.getProperty("user")) || !ObjectUtilities.equal((Object)dcd.getPassword(), (Object)dcp.getProperty("password")) || !ObjectUtilities.equal((Object)dcd.getConnectionString(), (Object)dcp.getUrl()) || !ObjectUtilities.equal((Object)dcd.getName(), (Object)dcp.getProperty("::pentaho-reporting::name"))) continue;
                return definition;
            }
            String[] strings = dcp.getPropertyNames();
            Properties p = new Properties();
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                p.put(string, dcp.getProperty(string));
            }
            return new DriverConnectionDefinition(customName, dcp.getDriver(), dcp.getUrl(), dataFactory.getJdbcUser(), dataFactory.getJdbcPassword(), dcp.getProperty("::pentaho-reporting::hostname"), dcp.getProperty("::pentaho-reporting::database-name"), dcp.getProperty("::pentaho-reporting::database-type"), dcp.getProperty("::pentaho-reporting::port"), p);
        }
        if (provider instanceof JndiDataSourceProvider) {
            JndiDataSourceProvider jcp = (JndiDataSourceProvider)provider;
            DefaultComboBoxModel model = this.dialogModel.getConnections();
            for (int i = 0; i < model.getSize(); ++i) {
                JndiConnectionDefinition dcd;
                JdbcConnectionDefinition definition = (JdbcConnectionDefinition)model.getElementAt(i);
                if (!(definition instanceof JndiConnectionDefinition) || !ObjectUtilities.equal((Object)(dcd = (JndiConnectionDefinition)definition).getJndiName(), (Object)jcp.getConnectionPath())) continue;
                return dcd;
            }
            return new JndiConnectionDefinition(customName, jcp.getConnectionPath(), null, dataFactory.getJdbcUser(), dataFactory.getJdbcPassword());
        }
        return null;
    }

    protected String getFileName() {
        return this.filenameField.getText();
    }

    public void setFileName(String fileName) {
        this.filenameField.setText(fileName);
    }

    protected SimpleDataSourceDialogModel getDialogModel() {
        return this.dialogModel;
    }

    protected void setSchemaFileName(String schema) {
        this.filenameField.setText(schema);
    }

    protected String getSchemaFileName() {
        return this.filenameField.getText();
    }

    protected void configureConnection(AbstractMDXDataFactory dataFactory) {
        CubeFileProvider cubeFileProvider = (CubeFileProvider)ClassicEngineBoot.getInstance().getObjectFactory().get(CubeFileProvider.class);
        cubeFileProvider.setDesignTimeFile(this.getSchemaFileName());
        cubeFileProvider.setCubeConnectionName(this.cubeConnectionNameField.getText());
        dataFactory.setCubeFileProvider(cubeFileProvider);
        dataFactory.setRole(this.roleText);
        dataFactory.setRoleField(this.roleField);
        dataFactory.setJdbcUser(this.jdbcUserText);
        dataFactory.setJdbcUserField(this.jdbcUserField);
        dataFactory.setJdbcPassword(this.jdbcPasswordText);
        dataFactory.setJdbcPasswordField(this.jdbcPasswordField);
        JdbcConnectionDefinition connectionDefinition = (JdbcConnectionDefinition)this.getDialogModel().getConnections().getSelectedItem();
        dataFactory.setDesignTimeName(connectionDefinition.getName());
        if (connectionDefinition instanceof DriverConnectionDefinition) {
            DriverConnectionDefinition dcd = (DriverConnectionDefinition)connectionDefinition;
            dataFactory.setJdbcUser(dcd.getUsername());
            dataFactory.setJdbcPassword(dcd.getPassword());
            DriverDataSourceProvider dataSourceProvider = new DriverDataSourceProvider();
            dataSourceProvider.setUrl(dcd.getConnectionString());
            dataSourceProvider.setDriver(dcd.getDriverClass());
            Properties properties = dcd.getProperties();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if ("user".equals(key) || "password".equals(key)) continue;
                dataSourceProvider.setProperty(key, properties.getProperty(key));
            }
            dataFactory.setDataSourceProvider((DataSourceProvider)dataSourceProvider);
        } else {
            JndiConnectionDefinition jcd = (JndiConnectionDefinition)connectionDefinition;
            dataFactory.setDataSourceProvider((DataSourceProvider)new JndiDataSourceProvider(jcd.getJndiName()));
            dataFactory.setJdbcUser(jcd.getUsername());
            dataFactory.setJdbcPassword(jcd.getPassword());
        }
    }

    protected void autoRefreshSchemaName() {
        if (!StringUtils.isEmpty((String)this.cubeConnectionNameField.getText())) {
            return;
        }
        this.cubeConnectionNameField.setText(this.lookupSchemaName());
    }

    private String lookupSchemaName() {
        AbstractReportDefinition report = this.context.getReport();
        MasterReport masterReport = DesignTimeUtil.getMasterReport((Element)report);
        ResourceManager resourceManager = masterReport.getResourceManager();
        ResourceKey contextKey = masterReport.getContentBase();
        String designTimeFile = this.filenameField.getText();
        return MondrianUtil.parseSchemaName((ResourceManager)resourceManager, (ResourceKey)contextKey, (String)designTimeFile);
    }

    protected void refreshSchemaName() {
        this.cubeConnectionNameField.setText("");
        this.autoRefreshSchemaName();
    }

    private class RefreshSchemaNameAction
    extends AbstractAction {
        private RefreshSchemaNameAction() {
            this.putValue("Name", Messages.getString("MondrianDataSourceEditor.UpdateSchema.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleMondrianDataSourceEditor.this.refreshSchemaName();
        }
    }

    private class EditSecurityAction
    extends AbstractAction {
        private EditSecurityAction() {
            this.putValue("Name", Messages.getString("MondrianDataSourceEditor.EditSecurityAction.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SimpleMondrianDataSourceEditor.this.securityDialog.setRoleField(SimpleMondrianDataSourceEditor.this.roleField);
            SimpleMondrianDataSourceEditor.this.securityDialog.setRole(SimpleMondrianDataSourceEditor.this.roleText);
            SimpleMondrianDataSourceEditor.this.securityDialog.setJdbcPassword(SimpleMondrianDataSourceEditor.this.jdbcPasswordText);
            SimpleMondrianDataSourceEditor.this.securityDialog.setJdbcPasswordField(SimpleMondrianDataSourceEditor.this.jdbcPasswordField);
            SimpleMondrianDataSourceEditor.this.securityDialog.setJdbcUser(SimpleMondrianDataSourceEditor.this.jdbcUserText);
            SimpleMondrianDataSourceEditor.this.securityDialog.setJdbcUserField(SimpleMondrianDataSourceEditor.this.jdbcUserField);
            if (SimpleMondrianDataSourceEditor.this.securityDialog.performEdit()) {
                SimpleMondrianDataSourceEditor.this.roleText = SimpleMondrianDataSourceEditor.this.securityDialog.getRole();
                SimpleMondrianDataSourceEditor.this.roleField = SimpleMondrianDataSourceEditor.this.securityDialog.getRoleField();
                SimpleMondrianDataSourceEditor.this.jdbcUserText = SimpleMondrianDataSourceEditor.this.securityDialog.getJdbcUser();
                SimpleMondrianDataSourceEditor.this.jdbcUserField = SimpleMondrianDataSourceEditor.this.securityDialog.getJdbcUserField();
                SimpleMondrianDataSourceEditor.this.jdbcPasswordText = SimpleMondrianDataSourceEditor.this.securityDialog.getJdbcPassword();
                SimpleMondrianDataSourceEditor.this.jdbcPasswordField = SimpleMondrianDataSourceEditor.this.securityDialog.getJdbcPasswordField();
            }
        }
    }

    private class ConfirmEnableHandler
    implements PropertyChangeListener,
    DocumentListener {
        private ConfirmEnableHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.revalidate();
        }

        private void revalidate() {
            SimpleDataSourceDialogModel dialogModel = SimpleMondrianDataSourceEditor.this.getDialogModel();
            SimpleMondrianDataSourceEditor.this.getConfirmAction().setEnabled(dialogModel.isConnectionSelected() && !StringUtils.isEmpty((String)SimpleMondrianDataSourceEditor.this.filenameField.getText(), (boolean)true));
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.revalidate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.revalidate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.revalidate();
        }
    }

    private class BrowseAction
    extends AbstractAction {
        protected BrowseAction() {
            this.putValue("Name", Messages.getString("MondrianDataSourceEditor.Browse.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File reportContextFile = DesignTimeUtil.getContextAsFile((AbstractReportDefinition)SimpleMondrianDataSourceEditor.this.context.getReport());
            File initiallySelectedFile = !StringUtils.isEmpty((String)SimpleMondrianDataSourceEditor.this.getFileName(), (boolean)true) ? (reportContextFile == null ? new File(SimpleMondrianDataSourceEditor.this.getFileName()) : new File(reportContextFile.getParentFile(), SimpleMondrianDataSourceEditor.this.getFileName())) : null;
            FileFilter[] fileFilters = new FileFilter[]{new FilesystemFilter(new String[]{".xml"}, Messages.getString("MondrianDataSourceEditor.FileName", new Object[0]) + " (*.xml)", true)};
            CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("mondrian");
            fileChooser.setSelectedFile(initiallySelectedFile);
            fileChooser.setFilters(fileFilters);
            if (!fileChooser.showDialog((Component)((Object)SimpleMondrianDataSourceEditor.this), 0)) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String path = reportContextFile != null ? IOUtils.getInstance().createRelativePath(file.getPath(), reportContextFile.getAbsolutePath()) : file.getPath();
            SimpleMondrianDataSourceEditor.this.setFileName(path);
            SimpleMondrianDataSourceEditor.this.autoRefreshSchemaName();
        }
    }
}

