/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.java14config;

import java.util.Enumeration;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigStorage;
import org.pentaho.reporting.engine.classic.core.modules.misc.configstore.base.ConfigStoreException;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;

public class Java14ConfigStorage
implements ConfigStorage {
    private Preferences base;

    public Java14ConfigStorage(Preferences base) {
        this.base = base;
    }

    public void store(String configPath, Configuration config) throws ConfigStoreException {
        if (!ConfigFactory.isValidPath((String)configPath)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        try {
            Enumeration keys = config.getConfigProperties();
            Preferences pref = this.base.node(configPath);
            pref.clear();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = config.getConfigProperty(key);
                if (value == null) continue;
                pref.put(key, value);
            }
            pref.sync();
        }
        catch (BackingStoreException be) {
            throw new ConfigStoreException("Failed to store config" + configPath, (Exception)be);
        }
    }

    public Configuration load(String configPath, Configuration defaults) throws ConfigStoreException {
        if (!ConfigFactory.isValidPath((String)configPath)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        try {
            Properties props = new Properties();
            Preferences pref = this.base.node(configPath);
            String[] keysArray = pref.keys();
            for (int i = 0; i < keysArray.length; ++i) {
                String key = keysArray[i];
                String string = pref.get(key, null);
                if (string == null) continue;
                props.setProperty(key, string);
            }
            HierarchicalConfiguration config = new HierarchicalConfiguration(defaults);
            for (String string : props.keySet()) {
                config.setConfigProperty(string, props.getProperty(string));
            }
            return config;
        }
        catch (BackingStoreException be) {
            throw new ConfigStoreException("Failed to load config" + configPath, (Exception)be);
        }
    }

    public boolean isAvailable(String configPath) {
        if (!ConfigFactory.isValidPath((String)configPath)) {
            throw new IllegalArgumentException("The give path is not valid.");
        }
        try {
            return this.base.nodeExists(configPath);
        }
        catch (BackingStoreException bse) {
            return false;
        }
    }
}

