/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.java14print;

import java.awt.print.PageFormat;
import java.awt.print.Paper;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaName;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.print.PrintUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PrintReportProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class Java14PrintUtil {
    private static final Log logger = LogFactory.getLog(Java14PrintUtil.class);
    public static final int CONFIGURATION_VALID = 0;
    public static final int CONFIGURATION_REPAGINATE = 1;
    public static final int CONFIGURATION_SHOW_DIALOG = 2;
    private static final double POINTS_PER_INCH = 72.0;

    private Java14PrintUtil() {
    }

    public static int isValidConfiguration(PrintRequestAttributeSet attributes, MasterReport report) {
        PrintRequestAttributeSet reportAttributes = Java14PrintUtil.copyConfiguration(null, report);
        Attribute[] printAttribs = reportAttributes.toArray();
        boolean invalidConfig = false;
        for (int i = 0; i < printAttribs.length; ++i) {
            Attribute attrib = printAttribs[i];
            if (attributes.containsValue(attrib)) continue;
            invalidConfig = true;
            break;
        }
        if (!invalidConfig) {
            return 0;
        }
        if (attributes.containsKey(PageRanges.class)) {
            return 2;
        }
        return 1;
    }

    public static PrintRequestAttributeSet copyConfiguration(PrintRequestAttributeSet attributes, MasterReport report) {
        if (attributes == null) {
            attributes = new HashPrintRequestAttributeSet();
        }
        PageDefinition pdef = report.getPageDefinition();
        PageFormat format = pdef.getPageFormat(0);
        Paper paper = format.getPaper();
        MediaSizeName media = MediaSize.findMedia((float)(paper.getWidth() / 72.0), (float)(paper.getHeight() / 72.0), 25400);
        attributes.add(media);
        MediaPrintableArea printableArea = new MediaPrintableArea((float)(paper.getImageableX() / 72.0), (float)(paper.getImageableY() / 72.0), (float)(paper.getImageableWidth() / 72.0), (float)(paper.getImageableHeight() / 72.0), 25400);
        attributes.add(printableArea);
        attributes.add(Java14PrintUtil.mapOrientation(format.getOrientation()));
        return attributes;
    }

    public static PrintRequestAttributeSet copyAuxillaryAttributes(PrintRequestAttributeSet attributes, MasterReport report) {
        String jobName;
        if (attributes == null) {
            attributes = new HashPrintRequestAttributeSet();
        }
        if (!attributes.containsKey(JobName.class) && (jobName = report.getReportConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.print.JobName", report.getTitle())) != null) {
            attributes.add(new JobName(jobName, null));
        }
        if (!attributes.containsKey(Copies.class)) {
            int numberOfCopies = PrintUtil.getNumberOfCopies((Configuration)report.getReportConfiguration());
            attributes.add(new Copies(numberOfCopies));
        }
        return attributes;
    }

    public static PageFormat extractPageFormat(PrintRequestAttributeSet attributeSet) {
        Media media = (Media)attributeSet.get(Media.class);
        MediaPrintableArea printableArea = (MediaPrintableArea)attributeSet.get(MediaPrintableArea.class);
        OrientationRequested orientationRequested = (OrientationRequested)attributeSet.get(OrientationRequested.class);
        MediaSize mediaSize = Java14PrintUtil.lookupMediaSize(media);
        if (mediaSize == null) {
            logger.warn((Object)"Unknown media encountered, unable to compute page sizes.");
        }
        PageFormat pageFormat = new PageFormat();
        pageFormat.setPaper(Java14PrintUtil.createPaper(mediaSize, printableArea));
        if (OrientationRequested.PORTRAIT.equals(orientationRequested)) {
            pageFormat.setOrientation(1);
        } else if (OrientationRequested.LANDSCAPE.equals(orientationRequested)) {
            pageFormat.setOrientation(0);
        } else if (OrientationRequested.REVERSE_LANDSCAPE.equals(orientationRequested)) {
            pageFormat.setOrientation(2);
        } else if (OrientationRequested.REVERSE_PORTRAIT.equals(orientationRequested)) {
            pageFormat.setOrientation(1);
        }
        return pageFormat;
    }

    private static Paper createPaper(MediaSize mediaSize, MediaPrintableArea printableArea) {
        Paper paper = new Paper();
        if (mediaSize != null) {
            paper.setSize((double)mediaSize.getX(25400) * 72.0, (double)mediaSize.getY(25400) * 72.0);
        }
        if (printableArea != null) {
            paper.setImageableArea((double)printableArea.getX(25400) * 72.0, (double)printableArea.getY(25400) * 72.0, (double)printableArea.getWidth(25400) * 72.0, (double)printableArea.getHeight(25400) * 72.0);
        }
        return paper;
    }

    private static MediaSize lookupMediaSize(Media media) {
        if (media instanceof MediaSizeName) {
            return MediaSize.getMediaSizeForName((MediaSizeName)media);
        }
        if (media instanceof MediaName) {
            if (media.equals(MediaName.ISO_A4_TRANSPARENT) || media.equals(MediaName.ISO_A4_WHITE)) {
                return MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
            }
            if (media.equals(MediaName.NA_LETTER_TRANSPARENT) || media.equals(MediaName.NA_LETTER_WHITE)) {
                return MediaSize.getMediaSizeForName(MediaSizeName.NA_LETTER);
            }
        }
        return null;
    }

    private static OrientationRequested mapOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                return OrientationRequested.LANDSCAPE;
            }
            case 2: {
                return OrientationRequested.REVERSE_LANDSCAPE;
            }
            case 1: {
                return OrientationRequested.PORTRAIT;
            }
        }
        throw new IllegalArgumentException("The given value is no valid PageFormat orientation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDirectly(MasterReport report, PrintService printService) throws PrintException, ReportProcessingException {
        if (printService == null) {
            printService = Java14PrintUtil.lookupPrintService();
        } else if (!printService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE)) {
            throw new PrintException("The print service implementation does not support the Pageable Flavor.");
        }
        PrintRequestAttributeSet attributes = Java14PrintUtil.copyConfiguration(null, report);
        attributes = Java14PrintUtil.copyAuxillaryAttributes(attributes, report);
        PrintReportProcessor reportPane = new PrintReportProcessor(report);
        DocPrintJob job = printService.createPrintJob();
        SimpleDoc document = new SimpleDoc(reportPane, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        try {
            job.print(document, attributes);
        }
        finally {
            reportPane.close();
        }
    }

    private static PrintService lookupPrintService() throws PrintException {
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        if (defaultService != null && defaultService.isDocFlavorSupported(DocFlavor.SERVICE_FORMATTED.PAGEABLE)) {
            return defaultService;
        }
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (services.length == 0) {
            throw new PrintException("Unable to find a matching print service implementation.");
        }
        PrintService printService = services[0];
        return printService;
    }

    public static boolean print(MasterReport report) throws PrintException, ReportProcessingException {
        return Java14PrintUtil.print(report, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(MasterReport report, ReportProgressListener progressListener) throws PrintException, ReportProcessingException {
        PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
        if (services.length == 0) {
            throw new PrintException("Unable to find a matching print service implementation.");
        }
        PrintRequestAttributeSet attributes = Java14PrintUtil.copyConfiguration(null, report);
        attributes = Java14PrintUtil.copyAuxillaryAttributes(attributes, report);
        PrintService service = ServiceUI.printDialog(null, 50, 50, services, Java14PrintUtil.lookupPrintService(), DocFlavor.SERVICE_FORMATTED.PAGEABLE, attributes);
        if (service == null) {
            return false;
        }
        PrintReportProcessor reportPane = new PrintReportProcessor(report);
        if (progressListener != null) {
            reportPane.addReportProgressListener(progressListener);
        }
        try {
            reportPane.fireProcessingStarted();
            DocPrintJob job = service.createPrintJob();
            SimpleDoc document = new SimpleDoc(reportPane, DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
            job.print(document, attributes);
        }
        finally {
            reportPane.fireProcessingFinished();
            reportPane.close();
            if (progressListener != null) {
                reportPane.removeReportProgressListener(progressListener);
            }
        }
        return true;
    }
}

