/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.sparklines;

import java.awt.Color;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.ColumnAggregationExpression;
import org.pentaho.reporting.libraries.libsparklines.BarGraphDrawable;
import org.pentaho.reporting.libraries.libsparklines.LineGraphDrawable;
import org.pentaho.reporting.libraries.libsparklines.PieGraphDrawable;

public class SparklineExpression
extends ColumnAggregationExpression {
    public static final Color DEFAULT_COLOR = Color.GRAY;
    public static final Color DEFAULT_HIGH_COLOR = Color.BLACK;
    public static final Color DEFAULT_MEDIUM_COLOR = Color.YELLOW;
    public static final Color DEFAULT_LOW_COLOR = Color.GREEN;
    public static final Color DEFAULT_LAST_COLOR = Color.RED;
    private String type = "bar";
    private Color color = DEFAULT_COLOR;
    private Color backgroundColor;
    private Color highColor = DEFAULT_HIGH_COLOR;
    private Color mediumColor;
    private Color lowColor = DEFAULT_LOW_COLOR;
    private Color lastColor;
    private Double highSlice;
    private Double mediumSlice;
    private Double lowSlice;
    private int spacing = 2;
    private boolean counterClockWise = false;
    private int startAngle = 0;
    private String rawDataField;

    public SparklineExpression() {
        this.mediumColor = DEFAULT_MEDIUM_COLOR;
        this.lastColor = DEFAULT_LAST_COLOR;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRawDataField() {
        return this.rawDataField;
    }

    public void setRawDataField(String rawDataField) {
        this.rawDataField = rawDataField;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getHighColor() {
        return this.highColor;
    }

    public void setHighColor(Color highColor) {
        this.highColor = highColor;
    }

    public Color getLastColor() {
        return this.lastColor;
    }

    public void setLastColor(Color lastColor) {
        this.lastColor = lastColor;
    }

    public Color getMediumColor() {
        return this.mediumColor;
    }

    public void setMediumColor(Color mediumColor) {
        this.mediumColor = mediumColor;
    }

    public Color getLowColor() {
        return this.lowColor;
    }

    public void setLowColor(Color lowColor) {
        this.lowColor = lowColor;
    }

    public Double getHighSlice() {
        return this.highSlice;
    }

    public void setHighSlice(Double highSlice) {
        this.highSlice = highSlice;
    }

    public Double getMediumSlice() {
        return this.mediumSlice;
    }

    public void setMediumSlice(Double mediumSlice) {
        this.mediumSlice = mediumSlice;
    }

    public Double getLowSlice() {
        return this.lowSlice;
    }

    public void setLowSlice(Double lowSlice) {
        this.lowSlice = lowSlice;
    }

    public boolean isCounterClockWise() {
        return this.counterClockWise;
    }

    public void setCounterClockWise(boolean counterClockWise) {
        this.counterClockWise = counterClockWise;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(int startAngle) {
        this.startAngle = startAngle;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public Object getValue() {
        Number[] data = this.getData();
        if ("line".equals(this.type)) {
            LineGraphDrawable drawable = new LineGraphDrawable();
            drawable.setBackground(this.backgroundColor);
            drawable.setColor(this.color);
            drawable.setSpacing(this.spacing);
            drawable.setData(data);
            return drawable;
        }
        if ("bar".equals(this.type)) {
            BarGraphDrawable drawable = new BarGraphDrawable();
            drawable.setBackground(this.backgroundColor);
            drawable.setColor(this.color);
            drawable.setHighColor(this.highColor);
            drawable.setLastColor(this.lastColor);
            drawable.setData(data);
            drawable.setSpacing(this.spacing);
            return drawable;
        }
        if ("pie".equals(this.type)) {
            PieGraphDrawable drawable = new PieGraphDrawable();
            if (data.length < 1) {
                return null;
            }
            drawable.setValue(data[0]);
            drawable.setColor(this.color);
            drawable.setBackground(this.backgroundColor);
            drawable.setLowColor(this.lowColor);
            drawable.setHighColor(this.highColor);
            drawable.setMediumColor(this.mediumColor);
            drawable.setCounterClockWise(this.counterClockWise);
            drawable.setStartAngle(this.startAngle);
            if (this.lowSlice != null) {
                drawable.setLowSlice((Number)this.lowSlice);
            }
            if (this.mediumSlice != null) {
                drawable.setMediumSlice((Number)this.mediumSlice);
            }
            if (this.highSlice != null) {
                drawable.setHighSlice((Number)this.highSlice);
            }
            return drawable;
        }
        return null;
    }

    protected Number[] getData() {
        Object o;
        Number[] retval;
        if (this.rawDataField != null && (retval = ElementTypeUtils.getData((Object)(o = this.getDataRow().get(this.rawDataField)))) != null) {
            return retval;
        }
        ArrayList<Number> numbers = new ArrayList<Number>();
        Object[] values = this.getFieldValues();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (!(value instanceof Number)) continue;
            Number n = (Number)value;
            numbers.add(n);
        }
        return numbers.toArray(new Number[numbers.size()]);
    }
}

