/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hive.jdbc.HiveDriver;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationFileSystemManager;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.api.mapred.RunningJob;
import org.pentaho.hadoop.shim.common.CommonHadoopShim;
import org.pentaho.hadoop.shim.common.ConfigurationProxyV2;
import org.pentaho.hadoop.shim.common.DistributedCacheUtilImpl;
import org.pentaho.hdfs.vfs.HDFSFileProvider;

public class HadoopShimImpl
extends CommonHadoopShim {
    @Override
    protected String getDefaultNamenodePort() {
        return "8020";
    }

    @Override
    protected String getDefaultJobtrackerPort() {
        return "8021";
    }

    @Override
    public void onLoad(HadoopConfiguration config, HadoopConfigurationFileSystemManager fsm) throws Exception {
        fsm.addProvider(config, "hdfs", config.getIdentifier(), (FileProvider)new HDFSFileProvider());
        this.setDistributedCacheUtil(new DistributedCacheUtilImpl(config){

            @Override
            public void addFileToClassPath(Path file, org.apache.hadoop.conf.Configuration conf) throws IOException {
                String classpath = conf.get("mapred.job.classpath.files");
                conf.set("mapred.job.classpath.files", classpath == null ? file.toString() : classpath + this.getClusterPathSeparator() + file.toString());
                FileSystem fs = FileSystem.get((URI)file.toUri(), (org.apache.hadoop.conf.Configuration)conf);
                URI uri = fs.makeQualified(file).toUri();
                DistributedCache.addCacheFile((URI)uri, (org.apache.hadoop.conf.Configuration)conf);
            }

            @Override
            public String getClusterPathSeparator() {
                return System.getProperty("hadoop.cluster.path.separator", ",");
            }
        });
    }

    @Override
    public RunningJob submitJob(Configuration c) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            RunningJob runningJob = c.submit();
            return runningJob;
        }
        catch (ClassNotFoundException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public Configuration createConfiguration() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            ConfigurationProxyV2 configurationProxyV2 = new ConfigurationProxyV2();
            return configurationProxyV2;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create configuration for new mapreduce api: ", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    public void configureConnectionInformation(String namenodeHost, String namenodePort, String jobtrackerHost, String jobtrackerPort, Configuration conf, List<String> logMessages) throws Exception {
        String runtimeFsDefaultName = conf.get("pentaho.runtime.fs.default.name");
        String runtimeFsDefaultScheme = conf.get("pentaho.runtime.fs.default.scheme", "hdfs");
        String runtimeJobTracker = conf.get("pentaho.runtime.job.tracker");
        if (runtimeFsDefaultName == null) {
            if (namenodeHost == null || namenodeHost.trim().length() == 0) {
                throw new Exception("No hdfs host specified!");
            }
            if (namenodePort != null && namenodePort.trim().length() != 0 && !"-1".equals(namenodePort.trim())) {
                namenodePort = ":" + namenodePort;
            } else {
                namenodePort = "";
                logMessages.add("No hdfs port specified - HA? ");
            }
            runtimeFsDefaultName = runtimeFsDefaultScheme + "://" + namenodeHost + namenodePort;
        }
        if (runtimeJobTracker == null) {
            if (jobtrackerHost == null || jobtrackerHost.trim().length() == 0) {
                throw new Exception("No job tracker host specified!");
            }
            if (jobtrackerPort == null || jobtrackerPort.trim().length() == 0) {
                jobtrackerPort = this.getDefaultJobtrackerPort();
                logMessages.add("No job tracker port specified - using default: " + jobtrackerPort);
            }
            runtimeJobTracker = jobtrackerHost + ":" + jobtrackerPort;
        }
        conf.set("fs.default.name", runtimeFsDefaultName);
        conf.set("mapred.job.tracker", runtimeJobTracker);
    }

    static {
        JDBC_DRIVER_MAP.put("hive2", HiveDriver.class);
    }
}

