/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.util.ArrayList;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.AbstractKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.DocumentHelper;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.EmbeddedKettleDataFactoryMetaData;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaArgument;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.FormulaParameter;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EmbeddedKettleTransformationProducer
extends AbstractKettleTransformationProducer {
    private static final long serialVersionUID = 1900310938438244134L;
    private static final Log logger = LogFactory.getLog(EmbeddedKettleTransformationProducer.class);
    private String pluginId;
    private byte[] rawBytes;

    public EmbeddedKettleTransformationProducer(FormulaArgument[] definedArgumentNames, FormulaParameter[] definedVariableNames, String pluginId, byte[] transformationRaw) {
        super("", "output", null, null, definedArgumentNames, definedVariableNames);
        this.pluginId = pluginId;
        if (transformationRaw == null) {
            EmbeddedKettleDataFactoryMetaData md = (EmbeddedKettleDataFactoryMetaData)DataFactoryRegistry.getInstance().getMetaData(pluginId);
            this.rawBytes = (byte[])md.getBytes().clone();
        } else {
            this.rawBytes = (byte[])transformationRaw.clone();
        }
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public byte[] getTransformationRaw() {
        return (byte[])this.rawBytes.clone();
    }

    @Override
    protected TransMeta loadTransformation(Repository repository, ResourceManager resourceManager, ResourceKey contextKey) throws ReportDataFactoryException, KettleException {
        return this.loadTransformation(contextKey);
    }

    private TransMeta loadTransformation(ResourceKey contextKey) throws KettleMissingPluginsException, KettlePluginException, KettleXMLException {
        Document document = DocumentHelper.loadDocumentFromBytes(this.getTransformationRaw());
        Node node = XMLHandler.getSubNode((Node)document, (String)"transformation");
        TransMeta meta = new TransMeta();
        meta.loadXML(node, null, true, null, null);
        String filename = this.computeFullFilename(contextKey);
        if (filename != null) {
            logger.debug((Object)("Computed Transformation Location: " + filename));
            meta.setFilename(filename);
        }
        return meta;
    }

    @Override
    public Object getQueryHash(ResourceManager resourceManager, ResourceKey resourceKey) {
        ArrayList<Object> retval = this.internalGetQueryHash();
        retval.add(this.pluginId);
        if (this.rawBytes != null) {
            retval.add(DigestUtils.sha256Hex((byte[])this.rawBytes));
        } else {
            retval.add(Boolean.FALSE);
        }
        return retval;
    }

    @Override
    public String getTransformationFile() {
        return null;
    }
}

