/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.cda.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaQueryEntry;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class CdaDataFactoryBundleWriteHandler
implements BundleDataFactoryWriterHandler {
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory rawDataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/cda-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for cda-Data-Source");
        }
        OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
        DefaultTagDescription tagDescription = new DefaultTagDescription(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.extensions.datasources.cda.tag-def.");
        XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/cda");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "cda-datasource", rootAttrs, false);
        CdaDataFactory dataFactory = (CdaDataFactory)rawDataFactory;
        AttributeList configAttrs = new AttributeList();
        if (!StringUtils.isEmpty((String)dataFactory.getBaseUrl())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "base-url", dataFactory.getBaseUrl());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getBaseUrlField())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "base-url-field", dataFactory.getBaseUrlField());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getSolution())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "solution", dataFactory.getSolution());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getPath())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "path", dataFactory.getPath());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getFile())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "file", dataFactory.getFile());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getUsername())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "username", dataFactory.getUsername());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getPassword())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "password", PasswordEncryptionService.getInstance().encrypt(dataFactory.getPassword()));
        }
        configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "use-local-call", String.valueOf(dataFactory.isUseLocalCall()));
        configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "is-sugar-mode", String.valueOf(dataFactory.isSugarMode()));
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "config", configAttrs, true);
        String[] queryNames = dataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            CdaQueryEntry query = dataFactory.getQueryEntry(queryName);
            AttributeList queryAttr = new AttributeList();
            queryAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "query", query.getId());
            queryAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "name", query.getName());
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "query", queryAttr, false);
            ParameterMapping[] parameterMappings = query.getParameters();
            for (int j = 0; j < parameterMappings.length; ++j) {
                ParameterMapping parameterMapping = parameterMappings[j];
                AttributeList paramAttr = new AttributeList();
                paramAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "datarow-name", parameterMapping.getName());
                paramAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "variable-name", parameterMapping.getAlias());
                xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "variable", paramAttr, true);
            }
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
        return fileName;
    }
}

