/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.cda.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PasswordEncryptionService;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.DataFactoryWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaQueryEntry;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class CdaDataFactoryWriteHandler
implements DataFactoryWriteHandler {
    public void write(ReportWriterContext reportWriter, XmlWriter xmlWriter, DataFactory rawDataFactory) throws IOException, ReportWriterException {
        CdaDataFactory dataFactory = (CdaDataFactory)rawDataFactory;
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/cda");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "cda-datasource", rootAttrs, false);
        AttributeList configAttrs = new AttributeList();
        if (!StringUtils.isEmpty((String)dataFactory.getBaseUrl())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "base-url", dataFactory.getBaseUrl());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getBaseUrlField())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "base-url-field", dataFactory.getBaseUrlField());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getSolution())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "solution", dataFactory.getSolution());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getPath())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "path", dataFactory.getPath());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getFile())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "file", dataFactory.getFile());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getUsername())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "username", dataFactory.getUsername());
        }
        if (!StringUtils.isEmpty((String)dataFactory.getPassword())) {
            configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "password", PasswordEncryptionService.getInstance().encrypt(dataFactory.getPassword()));
        }
        configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "use-local-call", String.valueOf(dataFactory.isUseLocalCall()));
        configAttrs.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "is-sugar-mode", String.valueOf(dataFactory.isSugarMode()));
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "config", configAttrs, true);
        String[] queryNames = dataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            CdaQueryEntry query = dataFactory.getQueryEntry(queryName);
            AttributeList queryAttr = new AttributeList();
            queryAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "query", query.getId());
            queryAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "name", query.getName());
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "query", queryAttr, false);
            ParameterMapping[] parameterMappings = query.getParameters();
            for (int j = 0; j < parameterMappings.length; ++j) {
                ParameterMapping parameterMapping = parameterMappings[j];
                AttributeList paramAttr = new AttributeList();
                paramAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "datarow-name", parameterMapping.getName());
                paramAttr.setAttribute("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "variable-name", parameterMapping.getAlias());
                xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/cda", "variable", paramAttr, true);
            }
            xmlWriter.writeCloseTag();
        }
    }
}

