/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionPrepareCallCommand
implements Command {
    private static final long serialVersionUID = 3258125843279655728L;
    private String _sql;
    private Integer _resultSetType;
    private Integer _resultSetConcurrency;
    private Integer _resultSetHoldability;

    public ConnectionPrepareCallCommand() {
    }

    public ConnectionPrepareCallCommand(String sql) {
        this._sql = sql;
    }

    public ConnectionPrepareCallCommand(String sql, int resultSetType, int resultSetConcurrency) {
        this._sql = sql;
        this._resultSetType = new Integer(resultSetType);
        this._resultSetConcurrency = new Integer(resultSetConcurrency);
    }

    public ConnectionPrepareCallCommand(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this._sql = sql;
        this._resultSetType = new Integer(resultSetType);
        this._resultSetConcurrency = new Integer(resultSetConcurrency);
        this._resultSetHoldability = new Integer(resultSetHoldability);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._sql);
        out.writeObject(this._resultSetType);
        out.writeObject(this._resultSetConcurrency);
        out.writeObject(this._resultSetHoldability);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._sql = (String)in.readObject();
        this._resultSetType = (Integer)in.readObject();
        this._resultSetConcurrency = (Integer)in.readObject();
        this._resultSetHoldability = (Integer)in.readObject();
    }

    @Override
    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        String sql = ctx.resolveOrCheckQuery(this._sql);
        if (this._resultSetType != null && this._resultSetConcurrency != null) {
            if (this._resultSetHoldability != null) {
                return ((Connection)target).prepareCall(sql, this._resultSetType, this._resultSetConcurrency, this._resultSetHoldability);
            }
            return ((Connection)target).prepareCall(sql, this._resultSetType, this._resultSetConcurrency);
        }
        return ((Connection)target).prepareCall(sql);
    }

    public String toString() {
        return "ConnectionPrepareStatementCommand";
    }
}

