/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.serial;

import de.simplicit.vjdbc.command.CommandPool;
import de.simplicit.vjdbc.command.DecoratedCommandSink;
import de.simplicit.vjdbc.command.DestroyCommand;
import de.simplicit.vjdbc.command.NextRowPacketCommand;
import de.simplicit.vjdbc.command.ResultSetGetMetaDataCommand;
import de.simplicit.vjdbc.serial.RowPacket;
import de.simplicit.vjdbc.serial.SerialResultSetMetaData;
import de.simplicit.vjdbc.serial.SerializableTransport;
import de.simplicit.vjdbc.serial.UIDEx;
import de.simplicit.vjdbc.util.JavaVersionInfo;
import de.simplicit.vjdbc.util.SQLExceptionHelper;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StreamingResultSet
implements ResultSet,
Externalizable {
    static final long serialVersionUID = 8291019975153433161L;
    private static Log _logger = LogFactory.getLog(StreamingResultSet.class);
    private int[] _columnTypes;
    private String[] _columnNames;
    private String[] _columnLabels;
    private RowPacket _rows;
    private int _rowPacketSize;
    private boolean _forwardOnly;
    private String _charset;
    private boolean _lastPartReached = true;
    private UIDEx _remainingResultSet = null;
    private SerialResultSetMetaData _metaData = null;
    private transient DecoratedCommandSink _commandSink = null;
    private transient int _cursor = -1;
    private transient int _lastReadColumn = 0;
    private transient Object[] _actualRow;
    private transient int _fetchDirection;
    private transient boolean _prefetchMetaData;
    private transient Statement _statement;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._remainingResultSet != null) {
            this.close();
        }
    }

    public StreamingResultSet() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._columnTypes);
        out.writeObject(this._columnNames);
        out.writeObject(this._columnLabels);
        out.writeObject(this._rows);
        out.writeInt(this._rowPacketSize);
        out.writeBoolean(this._forwardOnly);
        out.writeUTF(this._charset);
        out.writeBoolean(this._lastPartReached);
        out.writeObject(this._remainingResultSet);
        out.writeObject(this._metaData);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._columnTypes = (int[])in.readObject();
        this._columnNames = (String[])in.readObject();
        this._columnLabels = (String[])in.readObject();
        this._rows = (RowPacket)in.readObject();
        this._rowPacketSize = in.readInt();
        this._forwardOnly = in.readBoolean();
        this._charset = in.readUTF();
        this._lastPartReached = in.readBoolean();
        this._remainingResultSet = (UIDEx)in.readObject();
        this._metaData = (SerialResultSetMetaData)in.readObject();
        this._cursor = -1;
    }

    public StreamingResultSet(int rowPacketSize, boolean forwardOnly, boolean prefetchMetaData, String charset) {
        this._rowPacketSize = rowPacketSize;
        this._forwardOnly = forwardOnly;
        this._prefetchMetaData = prefetchMetaData;
        this._charset = charset;
    }

    public void setStatement(Statement stmt) {
        this._statement = stmt;
    }

    public void setCommandSink(DecoratedCommandSink sink) {
        this._commandSink = sink;
    }

    public void setRemainingResultSetUID(UIDEx reg) {
        this._remainingResultSet = reg;
    }

    public boolean populate(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        if (this._prefetchMetaData) {
            _logger.debug((Object)"Fetching MetaData of ResultSet");
            this._metaData = new SerialResultSetMetaData(metaData);
        }
        int columnCount = metaData.getColumnCount();
        this._columnTypes = new int[columnCount];
        this._columnNames = new String[columnCount];
        this._columnLabels = new String[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            this._columnTypes[i - 1] = metaData.getColumnType(i);
            this._columnNames[i - 1] = metaData.getColumnName(i).toLowerCase();
            this._columnLabels[i - 1] = metaData.getColumnLabel(i).toLowerCase();
        }
        this._rows = new RowPacket(this._rowPacketSize, this._forwardOnly);
        this._rows.populate(rs);
        this._lastPartReached = this._rows.isLastPart();
        return this._lastPartReached;
    }

    @Override
    public boolean next() throws SQLException {
        boolean result = false;
        if (++this._cursor < this._rows.size()) {
            this._actualRow = this._rows.get(this._cursor);
            result = true;
        } else if (!this._lastPartReached) {
            try {
                SerializableTransport st = (SerializableTransport)this._commandSink.process(this._remainingResultSet, new NextRowPacketCommand());
                RowPacket rsp = (RowPacket)st.getTransportee();
                if (rsp.isLastPart()) {
                    this._lastPartReached = true;
                }
                if (rsp.size() > 0) {
                    this._rows.merge(rsp);
                    this._actualRow = this._rows.get(this._cursor);
                    result = true;
                }
            }
            catch (Exception e) {
                throw SQLExceptionHelper.wrap(e);
            }
        }
        return result;
    }

    @Override
    public void close() throws SQLException {
        this._cursor = -1;
        if (this._remainingResultSet != null) {
            if (this._commandSink != null) {
                this._commandSink.process(this._remainingResultSet, new DestroyCommand(this._remainingResultSet, 7));
            }
            this._remainingResultSet = null;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this._actualRow[this._lastReadColumn] == null;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return this._actualRow[columnIndex].toString();
        }
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            Object value = this._actualRow[columnIndex];
            switch (this._columnTypes[columnIndex]) {
                case -7: {
                    return (Boolean)value;
                }
                case -6: {
                    return (Byte)value != 0;
                }
                case 5: {
                    return (Short)value != 0;
                }
                case 4: {
                    return (Integer)value != 0;
                }
                case -5: {
                    return (Long)value != 0L;
                }
                case 7: {
                    return ((Float)value).floatValue() != 0.0f;
                }
                case 6: 
                case 8: {
                    return (Double)value != 0.0;
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).intValue() != 0;
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        return Integer.parseInt((String)value) != 0;
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException("Can't convert String value '" + value + "' to boolean, must be an integer");
                    }
                }
            }
            if (JavaVersionInfo.use14Api && this._columnTypes[columnIndex] == 16) {
                return (Boolean)value;
            }
            throw new SQLException("Can't convert type to boolean: " + value.getClass());
        }
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            Object value = this._actualRow[columnIndex];
            switch (this._columnTypes[columnIndex]) {
                case -7: {
                    return (Boolean)value != false ? (byte)1 : 0;
                }
                case -6: {
                    return (Byte)value;
                }
                case 5: {
                    return ((Short)value).byteValue();
                }
                case 4: {
                    return ((Integer)value).byteValue();
                }
                case -5: {
                    return ((Long)value).byteValue();
                }
                case 7: {
                    return ((Float)value).byteValue();
                }
                case 6: 
                case 8: {
                    return ((Double)value).byteValue();
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).byteValue();
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        return Byte.parseByte((String)value);
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException("Can't convert String value '" + value + "' to byte");
                    }
                }
            }
            if (JavaVersionInfo.use14Api && this._columnTypes[columnIndex] == 16) {
                return (Boolean)value != false ? (byte)1 : 0;
            }
            throw new SQLException("Can't convert type to byte: " + value.getClass());
        }
        return 0;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            Object value = this._actualRow[columnIndex];
            switch (this._columnTypes[columnIndex]) {
                case -7: {
                    return (Boolean)value != false ? (short)1 : 0;
                }
                case -6: {
                    return ((Byte)value).shortValue();
                }
                case 5: {
                    return (Short)value;
                }
                case 4: {
                    return ((Integer)value).shortValue();
                }
                case -5: {
                    return ((Long)value).shortValue();
                }
                case 7: {
                    return ((Float)value).shortValue();
                }
                case 6: 
                case 8: {
                    return ((Double)value).shortValue();
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).shortValue();
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        return Short.parseShort((String)value);
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException("Can't convert String value '" + value + "' to short");
                    }
                }
            }
            if (JavaVersionInfo.use14Api && this._columnTypes[columnIndex] == 16) {
                return (Boolean)value != false ? (short)1 : 0;
            }
            throw new SQLException("Can't convert type to short: " + value.getClass());
        }
        return 0;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            Object value = this._actualRow[columnIndex];
            switch (this._columnTypes[columnIndex]) {
                case -7: {
                    return (Boolean)value != false ? 1 : 0;
                }
                case -6: {
                    return ((Byte)value).intValue();
                }
                case 5: {
                    return ((Short)value).intValue();
                }
                case 4: {
                    return (Integer)value;
                }
                case -5: {
                    return ((Long)value).intValue();
                }
                case 7: {
                    return ((Float)value).intValue();
                }
                case 6: 
                case 8: {
                    return ((Double)value).intValue();
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).intValue();
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        return Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException("Can't convert String value '" + value + "' to integer");
                    }
                }
            }
            if (JavaVersionInfo.use14Api && this._columnTypes[columnIndex] == 16) {
                return (Boolean)value != false ? 1 : 0;
            }
            throw new SQLException("Can't convert type to integer: " + value.getClass());
        }
        return 0;
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            Object value = this._actualRow[columnIndex];
            switch (this._columnTypes[columnIndex]) {
                case -7: {
                    return (Boolean)value != false ? 1L : 0L;
                }
                case -6: {
                    return ((Byte)value).longValue();
                }
                case 5: {
                    return ((Short)value).longValue();
                }
                case 4: {
                    return ((Integer)value).longValue();
                }
                case -5: {
                    return (Long)value;
                }
                case 7: {
                    return ((Float)value).longValue();
                }
                case 6: 
                case 8: {
                    return ((Double)value).longValue();
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).longValue();
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        return Long.parseLong((String)value);
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException("Can't convert String value '" + value + "' to long");
                    }
                }
            }
            if (JavaVersionInfo.use14Api && this._columnTypes[columnIndex] == 16) {
                return (Boolean)value != false ? 1L : 0L;
            }
            throw new SQLException("Can't convert type to long: " + value.getClass());
        }
        return 0L;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            Object value = this._actualRow[columnIndex];
            switch (this._columnTypes[columnIndex]) {
                case -7: {
                    return (Boolean)value != false ? 1.0f : 0.0f;
                }
                case -6: {
                    return ((Byte)value).floatValue();
                }
                case 5: {
                    return ((Short)value).floatValue();
                }
                case 4: {
                    return ((Integer)value).floatValue();
                }
                case -5: {
                    return ((Long)value).floatValue();
                }
                case 7: {
                    return ((Float)value).floatValue();
                }
                case 6: 
                case 8: {
                    return ((Double)value).floatValue();
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).floatValue();
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        return Float.parseFloat((String)value);
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException("Can't convert String value '" + value + "' to float");
                    }
                }
            }
            if (JavaVersionInfo.use14Api && this._columnTypes[columnIndex] == 16) {
                return (Boolean)value != false ? 1.0f : 0.0f;
            }
            throw new SQLException("Can't convert type to float: " + value.getClass());
        }
        return 0.0f;
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            Object value = this._actualRow[columnIndex];
            switch (this._columnTypes[columnIndex]) {
                case -7: {
                    return (Boolean)value != false ? 1.0 : 0.0;
                }
                case -6: {
                    return ((Byte)value).doubleValue();
                }
                case 5: {
                    return ((Short)value).doubleValue();
                }
                case 4: {
                    return ((Integer)value).doubleValue();
                }
                case -5: {
                    return ((Long)value).doubleValue();
                }
                case 7: {
                    return ((Float)value).doubleValue();
                }
                case 6: 
                case 8: {
                    return (Double)value;
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).doubleValue();
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        return Double.parseDouble((String)value);
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException("Can't convert String value '" + value + "' to double");
                    }
                }
            }
            if (JavaVersionInfo.use14Api && this._columnTypes[columnIndex] == 16) {
                return (Boolean)value != false ? 1.0 : 0.0;
            }
            throw new SQLException("Can't convert type to double: " + value.getClass());
        }
        return 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return this.internalGetBigDecimal(this._actualRow[columnIndex], this._columnTypes[columnIndex], scale);
        }
        return null;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return (byte[])this._actualRow[columnIndex];
        }
        return null;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            switch (this._columnTypes[columnIndex]) {
                case 91: {
                    return (Date)this._actualRow[columnIndex];
                }
                case 92: {
                    return this.getCleanDate(((Time)this._actualRow[columnIndex]).getTime());
                }
                case 93: {
                    return this.getCleanDate(((Timestamp)this._actualRow[columnIndex]).getTime());
                }
            }
            throw new SQLException("Can't convert type to Date: " + this._actualRow[columnIndex].getClass());
        }
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            switch (this._columnTypes[columnIndex]) {
                case 92: {
                    return (Time)this._actualRow[columnIndex];
                }
                case 91: {
                    Date date = (Date)this._actualRow[columnIndex];
                    return this.getCleanTime(date.getTime());
                }
                case 93: {
                    Timestamp timestamp = (Timestamp)this._actualRow[columnIndex];
                    return this.getCleanTime(timestamp.getTime());
                }
            }
            throw new SQLException("Can't convert type to Time: " + this._actualRow[columnIndex].getClass());
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            switch (this._columnTypes[columnIndex]) {
                case 92: {
                    return new Timestamp(((Time)this._actualRow[columnIndex]).getTime());
                }
                case 91: {
                    return new Timestamp(((Date)this._actualRow[columnIndex]).getTime());
                }
                case 93: {
                    return (Timestamp)this._actualRow[columnIndex];
                }
            }
            throw new SQLException("Can't convert type to Timestamp: " + this._actualRow[columnIndex].getClass());
        }
        return null;
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            byte[] bytes;
            Object obj = this._actualRow[columnIndex];
            if (obj instanceof byte[]) {
                bytes = (byte[])obj;
            } else if (obj instanceof String) {
                try {
                    bytes = ((String)obj).getBytes(this._charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw SQLExceptionHelper.wrap(e);
                }
            } else {
                String msg = "StreamingResultSet.getBinaryStream(): Can't convert object of type '" + obj.getClass() + "' to InputStream";
                throw new SQLException(msg);
            }
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.getIndexForName(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.getIndexForName(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.getIndexForName(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.getIndexForName(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.getIndexForName(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.getIndexForName(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.getIndexForName(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.getIndexForName(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.getIndexForName(columnName), scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.getIndexForName(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.getIndexForName(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.getIndexForName(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.getIndexForName(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getAsciiStream");
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new UnsupportedOperationException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.getIndexForName(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this._cursor < 0) {
            throw new SQLException("ResultSet already closed");
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("getCursorName");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this._metaData == null) {
            SerializableTransport st = (SerializableTransport)this._commandSink.process(this._remainingResultSet, new ResultSetGetMetaDataCommand());
            if (st != null) {
                try {
                    this._metaData = (SerialResultSetMetaData)st.getTransportee();
                }
                catch (Exception e) {
                    throw new SQLException("Can't get ResultSetMetaData, reason: " + e.toString());
                }
            } else {
                throw new SQLException("Can't get ResultSetMetaData");
            }
        }
        return this._metaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return this._actualRow[columnIndex];
        }
        return null;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.getIndexForName(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.getIndexForName(columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return new StringReader((String)this._actualRow[columnIndex]);
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.getIndexForName(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return this.internalGetBigDecimal(this._actualRow[columnIndex], this._columnTypes[columnIndex], -1);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.getIndexForName(columnName));
    }

    private BigDecimal internalGetBigDecimal(Object value, int columnType, int scale) throws SQLException {
        BigDecimal result = null;
        if (value != null) {
            switch (columnType) {
                case -7: {
                    result = new BigDecimal((Boolean)value != false ? 1.0 : 0.0);
                    break;
                }
                case -6: {
                    result = new BigDecimal(((Byte)value).doubleValue());
                    break;
                }
                case 5: {
                    result = new BigDecimal(((Short)value).doubleValue());
                    break;
                }
                case 4: {
                    result = new BigDecimal(((Integer)value).doubleValue());
                    break;
                }
                case -5: {
                    result = new BigDecimal(((Long)value).doubleValue());
                    break;
                }
                case 7: {
                    result = new BigDecimal(((Float)value).doubleValue());
                    break;
                }
                case 6: 
                case 8: {
                    result = new BigDecimal((Double)value);
                    break;
                }
                case 2: 
                case 3: {
                    result = (BigDecimal)value;
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    try {
                        result = new BigDecimal(Double.parseDouble((String)value));
                    }
                    catch (NumberFormatException e) {
                        throw new SQLException("Can't convert String value '" + value + "' to double");
                    }
                }
                default: {
                    if (!JavaVersionInfo.use14Api || columnType != 16) break;
                    result = new BigDecimal((Boolean)value != false ? 1.0 : 0.0);
                }
            }
            if (result != null) {
                if (scale >= 0) {
                    result = result.setScale(scale);
                }
            } else {
                throw new SQLException("Can't convert type to BigDecimal: " + value.getClass());
            }
        }
        return result;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this._cursor < 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this._rows.isLastPart() && this._cursor == this._rows.size();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this._cursor == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this._rows.isLastPart() && this._cursor == this._rows.size() - 1;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this._cursor = -1;
        this._actualRow = null;
    }

    @Override
    public void afterLast() throws SQLException {
        while (this.requestNextRowPacket()) {
        }
        this._cursor = this._rows.size();
        this._actualRow = null;
    }

    @Override
    public boolean first() throws SQLException {
        try {
            this._cursor = 0;
            this._actualRow = this._rows.get(this._cursor);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            while (this.requestNextRowPacket()) {
            }
            this._cursor = this._rows.size() - 1;
            this._actualRow = this._rows.get(this._cursor);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public int getRow() throws SQLException {
        return this._cursor + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.setCursor(row - 1);
    }

    @Override
    public boolean relative(int step) throws SQLException {
        return this.setCursor(this._cursor + step);
    }

    @Override
    public boolean previous() throws SQLException {
        if (this._forwardOnly) {
            throw new SQLException("previous() not possible on Forward-Only-ResultSet");
        }
        if (this._cursor > 0) {
            this._actualRow = this._rows.get(--this._cursor);
            return true;
        }
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this._fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getType() throws SQLException {
        return this._forwardOnly ? 1003 : 1004;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException("updateNull");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new UnsupportedOperationException("updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new UnsupportedOperationException("updateByte");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new UnsupportedOperationException("updateShort");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new UnsupportedOperationException("updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new UnsupportedOperationException("updateLong");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new UnsupportedOperationException("updateFloat");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new UnsupportedOperationException("updateDouble");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("updateBigDecimal");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new UnsupportedOperationException("updateString");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("updateBytes");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new UnsupportedOperationException("updateDate");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new UnsupportedOperationException("updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new UnsupportedOperationException("updateCharacterStream");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException("updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new UnsupportedOperationException("updateObject");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new UnsupportedOperationException("updateNull");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new UnsupportedOperationException("updateBoolean");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new UnsupportedOperationException("updateByte");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new UnsupportedOperationException("updateShort");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new UnsupportedOperationException("updateInt");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new UnsupportedOperationException("updateLong");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new UnsupportedOperationException("updateFloat");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new UnsupportedOperationException("updateDouble");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new UnsupportedOperationException("updateBigDecimal");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new UnsupportedOperationException("updateString");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new UnsupportedOperationException("updateBytes");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new UnsupportedOperationException("updateDate");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new UnsupportedOperationException("updateTime");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new UnsupportedOperationException("updateTimestamp");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new UnsupportedOperationException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new UnsupportedOperationException("updateCharacterStream");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new UnsupportedOperationException("updateObject");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new UnsupportedOperationException("updateObject");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException("insertRow");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("updateRow");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("deleteRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("refreshRow");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("cancelRowUpdates");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException("moveToInsertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException("moveToCurrentRow");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this._statement;
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new UnsupportedOperationException("getObject");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return (Ref)this._actualRow[columnIndex];
        }
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return (Blob)this._actualRow[columnIndex];
        }
        return null;
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return (Clob)this._actualRow[columnIndex];
        }
        return null;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return (Array)this._actualRow[columnIndex];
        }
        return null;
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw new UnsupportedOperationException("getObject");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.getIndexForName(colName));
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.getIndexForName(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.getIndexForName(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.getIndexForName(colName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            cal.setTime(this.getDate(columnIndex));
            return (Date)cal.getTime();
        }
        return null;
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.getIndexForName(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            Time time = (Time)this._actualRow[columnIndex];
            cal.setTime(time);
            return (Time)cal.getTime();
        }
        return null;
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.getIndexForName(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(columnIndex);
        if (timestamp != null) {
            cal.setTime(timestamp);
            return (Timestamp)cal.getTime();
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getIndexForName(columnName), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return (URL)this._actualRow[columnIndex];
        }
        return null;
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.getIndexForName(columnName));
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new UnsupportedOperationException("updateRef");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new UnsupportedOperationException("updateRef");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new UnsupportedOperationException("updateBlob");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new UnsupportedOperationException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new UnsupportedOperationException("updateClob");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new UnsupportedOperationException("updateClob");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new UnsupportedOperationException("updateArray");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new UnsupportedOperationException("updateArray");
    }

    private int getIndexForName(String name) throws SQLException {
        int i;
        int result = -1;
        String nameLowercase = name.toLowerCase();
        for (i = 0; i < this._columnNames.length; ++i) {
            if (!this._columnNames[i].equals(nameLowercase)) continue;
            result = i;
            break;
        }
        if (result < 0) {
            for (i = 0; i < this._columnLabels.length; ++i) {
                if (!this._columnLabels[i].equals(nameLowercase)) continue;
                result = i;
                break;
            }
        }
        if (result < 0) {
            throw new SQLException("Unknown column " + name);
        }
        this._lastReadColumn = result;
        return result + 1;
    }

    private boolean preGetCheckNull(int index) {
        this._lastReadColumn = index;
        boolean wasNull = this._actualRow[this._lastReadColumn] == null;
        return !wasNull;
    }

    private boolean requestNextRowPacket() throws SQLException {
        if (!this._lastPartReached) {
            try {
                SerializableTransport st = (SerializableTransport)this._commandSink.process(this._remainingResultSet, new NextRowPacketCommand());
                RowPacket rsp = (RowPacket)st.getTransportee();
                if (rsp.isLastPart()) {
                    this._lastPartReached = true;
                }
                if (rsp.size() > 0) {
                    this._rows.merge(rsp);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                throw SQLExceptionHelper.wrap(e);
            }
        }
        return false;
    }

    private boolean setCursor(int row) throws SQLException {
        if (row >= 0) {
            if (row < this._rows.size()) {
                this._cursor = row;
                this._actualRow = this._rows.get(this._cursor);
                return true;
            }
            while (this.requestNextRowPacket()) {
                if (row >= this._rows.size()) continue;
                this._cursor = row;
                this._actualRow = this._rows.get(this._cursor);
                return true;
            }
            return false;
        }
        return false;
    }

    private Date getCleanDate(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis());
    }

    private Time getCleanTime(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(14, 0);
        return new Time(cal.getTimeInMillis());
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        return (RowId)this._commandSink.process(this._remainingResultSet, CommandPool.getReflectiveCommand(7, "getRowId", new Object[]{new Integer(parameterIndex)}, 2));
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return (RowId)this._commandSink.process(this._remainingResultSet, CommandPool.getReflectiveCommand(7, "getRowId", new Object[]{parameterName}, 3));
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        throw new UnsupportedOperationException("setRowId");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new UnsupportedOperationException("updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new UnsupportedOperationException("updateRowId");
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._commandSink.processWithIntResult(this._remainingResultSet, CommandPool.getReflectiveCommand(7, "getHoldability"));
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._cursor < 0;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new UnsupportedOperationException("updateNString");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new UnsupportedOperationException("updateNString");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException("updateNClob");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return (NClob)this._actualRow[columnIndex];
        }
        return null;
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.getIndexForName(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return (SQLXML)this._actualRow[columnIndex];
        }
        return null;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.getIndexForName(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("updateSQLXML");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new UnsupportedOperationException("updateSQLXML");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return this._actualRow[columnIndex].toString();
        }
        return null;
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.getIndexForName(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        if (this.preGetCheckNull(--columnIndex)) {
            return new StringReader((String)this._actualRow[columnIndex]);
        }
        return null;
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.getIndexForName(columnLabel));
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new UnsupportedOperationException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new UnsupportedOperationException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("updateCharacterStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new UnsupportedOperationException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new UnsupportedOperationException("updateNClob");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("updateNCharacterStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("updateBinaryStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("updateCharacterStream");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new UnsupportedOperationException("updateBinaryStream");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("updateBlob");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException("updateBlob");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("updateClob");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("updateNClob");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new UnsupportedOperationException("updateNClob");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(StreamingResultSet.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }
}

