/*
 * Decompiled with CFR 0.152.
 */
package net.sf.farrago.jdbc;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import net.sf.farrago.release.FarragoReleaseProperties;
import org.eigenbase.util14.ConnectStringParser;

public abstract class FarragoAbstractJdbcDriver
implements Driver {
    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public abstract String getUrlPrefix();

    public String getBaseUrl() {
        FarragoReleaseProperties props = FarragoReleaseProperties.instance();
        return props.jdbcUrlBase.get();
    }

    public String getClientUrl() {
        return this.getBaseUrl() + "client_rmi";
    }

    @Override
    public int getMajorVersion() {
        FarragoReleaseProperties props = FarragoReleaseProperties.instance();
        return props.jdbcDriverVersionMajor.get();
    }

    @Override
    public int getMinorVersion() {
        FarragoReleaseProperties props = FarragoReleaseProperties.instance();
        return props.jdbcDriverVersionMinor.get();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        if (!url.startsWith(this.getUrlPrefix())) {
            return false;
        }
        String suffix = url.substring(this.getUrlPrefix().length());
        return !suffix.startsWith("rmi:");
    }

    public boolean acceptsUrlWithHostPort() {
        return false;
    }

    public void register() {
        try {
            DriverManager.registerDriver(this);
        }
        catch (SQLException e) {
            System.out.println("Error occurred while registering JDBC driver " + this + ": " + e.toString());
        }
    }

    public Properties applyDefaultConnectionProps(Properties info) {
        Properties props = this.copyProperties(this.getDefaultConnectionProps(), null);
        return this.copyProperties(info, props);
    }

    public Properties getDefaultConnectionProps() {
        String processId;
        Properties props = new Properties();
        String userName = System.getProperty("user.name");
        if (userName != null) {
            props.setProperty("clientUserName", userName);
        }
        if ((processId = System.getProperty("process.id")) != null) {
            props.setProperty("clientProcessId", processId);
        }
        return props;
    }

    private Properties copyProperties(Properties src, Properties dest) {
        if (dest == null) {
            dest = new Properties();
        }
        Enumeration<?> enumer = src.propertyNames();
        while (enumer.hasMoreElements()) {
            Object key = enumer.nextElement();
            Object val = src.get(key);
            if (val == null) {
                if (key instanceof String) {
                    val = src.getProperty((String)key);
                }
                if (val == null) continue;
            }
            dest.put(key, val);
        }
        return dest;
    }

    public String parseConnectionParams(String connectionURI, Properties info) throws SQLException {
        if (connectionURI == null) {
            return null;
        }
        int i = connectionURI.indexOf(59);
        if (i < 0) {
            return connectionURI;
        }
        String uri = connectionURI.substring(0, i);
        String params = connectionURI.substring(i + 1);
        ConnectStringParser.parse(params, info);
        return uri;
    }
}

