/*
 * Decompiled with CFR 0.152.
 */
package net.sf.farrago.jdbc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eigenbase.util.EigenbaseContextException;
import org.eigenbase.util.EigenbaseException;
import org.eigenbase.util14.EigenbaseParserException;
import org.eigenbase.util14.EigenbaseValidatorException;

public class FarragoJdbcUtil {
    private static final ThreadLocal threadChecker = new ThreadLocal(){

        protected Object initialValue() {
            return new SerializationChecker();
        }
    };

    public static SQLException newSqlException(Throwable ex, Logger tracer) {
        SQLException sqlExcn;
        String message = ex.getMessage();
        tracer.severe(message);
        tracer.throwing("FarragoJdbcUtil", "newSqlException(ex)", ex);
        Throwable cause = ex.getCause();
        if (ex instanceof EigenbaseException) {
            String stmt = null;
            if (ex instanceof EigenbaseContextException) {
                stmt = ((EigenbaseContextException)ex).getOriginalStatement();
            }
            if (cause instanceof EigenbaseValidatorException) {
                String causeMessage = cause.getMessage();
                sqlExcn = new FarragoSqlException(message + ": " + causeMessage, ex, stmt, null);
                cause = cause.getCause();
            } else {
                sqlExcn = new FarragoSqlException(message, ex, stmt, null);
            }
        } else {
            sqlExcn = ex instanceof SQLException ? (SQLException)ex : new FarragoSqlException(ex.getClass().getName() + ": " + message, ex, null, null);
        }
        sqlExcn.setStackTrace(ex.getStackTrace());
        if (cause == null) {
            return sqlExcn;
        }
        if (ex instanceof EigenbaseParserException) {
            return sqlExcn;
        }
        SQLException sqlCause = FarragoJdbcUtil.newSqlException(cause, tracer);
        sqlCause.setNextException(sqlExcn);
        return sqlCause;
    }

    public static SQLException newSqlException(String message, Logger tracer) {
        SQLException ex = new SQLException(message);
        tracer.severe(message);
        tracer.throwing("FarragoJdbcUtil", "newSqlException(msg)", ex);
        return ex;
    }

    public static String findInputString(Throwable ex) {
        Object valObj;
        Method meth;
        Class<?> clazz = ex.getClass();
        try {
            meth = clazz.getMethod("getOriginalStatement", null);
            valObj = meth.invoke((Object)ex, (Object[])null);
            if (valObj != null) {
                return (String)valObj;
            }
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        try {
            String query;
            meth = clazz.getMethod("getNextException", null);
            valObj = meth.invoke((Object)ex, (Object[])null);
            if (valObj != null && (Throwable)valObj != ex && (query = FarragoJdbcUtil.findInputString((Throwable)valObj)) != null) {
                return query;
            }
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        try {
            meth = clazz.getMethod("getOriginalThrowable", null);
            valObj = meth.invoke((Object)ex, (Object[])null);
            if (valObj != null && (Throwable)valObj != ex) {
                return FarragoJdbcUtil.findInputString((Throwable)valObj);
            }
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public static class FarragoSqlException
    extends SQLException {
        private static final long serialVersionUID = -2302810435386763566L;
        private final Throwable original;
        private final String originalStatement;

        public FarragoSqlException(String reason, Throwable original, String originalStatement, Throwable cause) {
            super(reason);
            this.initCause(cause);
            this.original = original;
            this.originalStatement = originalStatement;
        }

        public Throwable getOriginalThrowable() {
            return this.original;
        }

        public String getOriginalStatement() {
            return this.originalStatement;
        }

        private Object writeReplace() {
            Throwable serializableCause;
            SQLException serializableNext;
            Throwable serializableOriginal;
            boolean needNewException = false;
            SerializationChecker checker = (SerializationChecker)threadChecker.get();
            if (this.original != null && this.original != this && !checker.isSerializable(this.original)) {
                needNewException = true;
                serializableOriginal = checker.makeSerializable(this.original);
            } else {
                serializableOriginal = this.original;
            }
            SQLException next = this.getNextException();
            if (next != null && next != this && !checker.isSerializable(next)) {
                needNewException = true;
                serializableNext = (SQLException)checker.makeSerializable(next);
            } else {
                serializableNext = next;
            }
            Throwable cause = this.getCause();
            if (cause != null && cause != this && !checker.isSerializable(cause)) {
                needNewException = true;
                serializableCause = checker.makeSerializable(cause);
            } else {
                serializableCause = cause;
            }
            if (needNewException) {
                FarragoSqlException fse = new FarragoSqlException(this.getMessage(), serializableOriginal, this.originalStatement, serializableCause);
                fse.setNextException(serializableNext);
                return fse;
            }
            return this;
        }
    }

    private static class SerializationChecker {
        private static final Pattern NON_SERIALIAZABLE_CLASSES = Pattern.compile("org\\.eigenbase\\.sql\\..*|.*\\.parser\\.impl\\.[^.]*");
        private final Set active = new HashSet();
        private final boolean rmiClassLoader = false;

        private SerializationChecker() {
        }

        Throwable makeSerializable(Throwable throwable) {
            if (this.isSerializable(throwable)) {
                return throwable;
            }
            Throwable cause = throwable.getCause();
            if (cause == throwable) {
                cause = null;
            }
            if (cause != null) {
                cause = this.makeSerializable(cause);
            }
            String message = throwable.getClass().getName() + ": " + throwable.getMessage();
            Throwable serializable = throwable instanceof RuntimeException ? new RuntimeException(message, cause) : (throwable instanceof Exception ? new Exception(message, cause) : (throwable instanceof Error ? new Error(message, cause) : new Throwable(message, cause)));
            serializable.setStackTrace(throwable.getStackTrace());
            return serializable;
        }

        boolean isSerializable(Object o) {
            String className = o.getClass().getName();
            if (NON_SERIALIAZABLE_CLASSES.matcher(className).matches()) {
                return false;
            }
            if (!this.active.add(o)) {
                return true;
            }
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new ByteArrayOutputStream());
                oos.writeObject(o);
                boolean bl = true;
                return bl;
            }
            catch (NotSerializableException e) {
                if (!(o instanceof EigenbaseParserException) && o instanceof Serializable) {
                    System.out.println("Warning: Object [" + o + "] of class " + o.getClass() + " implements Serializable but is not serializable. " + "Error is as follows:");
                    e.printStackTrace(System.out);
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                throw new RuntimeException("Error while testing serializability", e);
            }
            finally {
                this.active.remove(o);
            }
        }
    }
}

