/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.table;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.swing.JDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelEvent;
import org.pentaho.reporting.libraries.designtime.swing.background.CancelListener;
import org.pentaho.reporting.ui.datasources.table.Messages;
import org.pentaho.reporting.ui.datasources.table.SheetSelectorDialog;
import org.pentaho.reporting.ui.datasources.table.TableDataSourceEditor;

public class ImportFromFileTask
implements Runnable,
CancelListener {
    private static final Log logger = LogFactory.getLog(ImportFromFileTask.class);
    private File selectedFile;
    private boolean useFirstRowAsHeader;
    private TableDataSourceEditor parent;

    public ImportFromFileTask(File selectedFile, boolean useFirstRowAsHeader, TableDataSourceEditor parent) {
        this.parent = parent;
        if (selectedFile == null) {
            throw new NullPointerException();
        }
        this.selectedFile = selectedFile;
        this.useFirstRowAsHeader = useFirstRowAsHeader;
    }

    @Override
    public void run() {
        this.importFromFile(this.selectedFile, this.useFirstRowAsHeader);
    }

    public void cancelProcessing(CancelEvent event) {
        Thread.currentThread().interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromFile(File file, boolean firstRowIsHeader) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(Math.max(8192, (int)file.length()));
        try {
            try (FileInputStream fin = new FileInputStream(file);){
                IOUtils.getInstance().copyStreams((InputStream)new BufferedInputStream(fin), (OutputStream)bout);
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            Workbook workbook = WorkbookFactory.create((InputStream)new ByteArrayInputStream(bout.toByteArray()));
            int sheetIndex = 0;
            if (workbook.getNumberOfSheets() > 1) {
                SheetSelectorDialog selectorDialog = new SheetSelectorDialog(workbook, (JDialog)((Object)this.parent));
                if (selectorDialog.performSelection()) {
                    sheetIndex = selectorDialog.getSelectedIndex();
                } else {
                    return;
                }
            }
            TypedTableModel tableModel = new TypedTableModel();
            Sheet sheet = workbook.getSheetAt(sheetIndex);
            Iterator rowIterator = sheet.rowIterator();
            if (firstRowIsHeader && rowIterator.hasNext()) {
                Row headerRow = (Row)rowIterator.next();
                short cellCount = headerRow.getLastCellNum();
                for (short colIdx = 0; colIdx < cellCount; colIdx = (short)(colIdx + 1)) {
                    Cell cell = headerRow.getCell((int)colIdx);
                    if (cell == null) continue;
                    while (colIdx > tableModel.getColumnCount()) {
                        tableModel.addColumn(Messages.getString("TableDataSourceEditor.Column", String.valueOf(tableModel.getColumnCount())), Object.class);
                    }
                    RichTextString string = cell.getRichStringCellValue();
                    if (string != null) {
                        tableModel.addColumn(string.getString(), Object.class);
                        continue;
                    }
                    tableModel.addColumn(Messages.getString("TableDataSourceEditor.Column", String.valueOf(colIdx)), Object.class);
                }
            }
            Object[] rowData = null;
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                short cellCount = row.getLastCellNum();
                if (cellCount == -1) continue;
                if (rowData == null || rowData.length != cellCount) {
                    rowData = new Object[cellCount];
                }
                for (short colIdx = 0; colIdx < cellCount; colIdx = (short)(colIdx + 1)) {
                    String dataFormatString;
                    CellStyle hssfCellStyle;
                    short dataFormat;
                    RichTextString string;
                    Cell cell = row.getCell((int)colIdx);
                    Object value = cell != null ? (cell.getCellType() == 1 ? ((string = cell.getRichStringCellValue()) != null ? string.getString() : null) : (cell.getCellType() == 0 ? (this.isDateFormat(dataFormat = (hssfCellStyle = cell.getCellStyle()).getDataFormat(), dataFormatString = hssfCellStyle.getDataFormatString()) ? cell.getDateCellValue() : Double.valueOf(cell.getNumericCellValue())) : (cell.getCellType() == 4 ? Boolean.valueOf(cell.getBooleanCellValue()) : cell.getStringCellValue()))) : null;
                    if (value != null && !"".equals(value)) {
                        while (colIdx >= tableModel.getColumnCount()) {
                            tableModel.addColumn(Messages.getString("TableDataSourceEditor.Column", String.valueOf(tableModel.getColumnCount())), Object.class);
                        }
                    }
                    rowData[colIdx] = value;
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                tableModel.addRow(rowData);
            }
            int colCount = tableModel.getColumnCount();
            int rowCount = tableModel.getRowCount();
            for (int col = 0; col < colCount; ++col) {
                Class<Object> type = null;
                for (int row = 0; row < rowCount; ++row) {
                    Object value = tableModel.getValueAt(row, col);
                    if (value == null) continue;
                    if (type == null) {
                        type = value.getClass();
                        continue;
                    }
                    if (type == Object.class || type.isInstance(value)) continue;
                    type = Object.class;
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (type == null) continue;
                tableModel.setColumnType(col, type);
            }
            this.parent.importComplete(tableModel);
        }
        catch (Exception e) {
            this.parent.importFailed(e);
            logger.error((Object)"Failed to import spreadsheet", (Throwable)e);
        }
    }

    private boolean isDateFormat(short knownFormat, String dataFormat) {
        if ("GENERAL".equalsIgnoreCase(dataFormat)) {
            return false;
        }
        switch (knownFormat) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 45: 
            case 46: 
            case 47: {
                return true;
            }
        }
        boolean inFormatQuote = false;
        boolean inQuote = false;
        int maybeElapsedHour = 0;
        char[] chars = dataFormat.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '[') {
                inFormatQuote = true;
                maybeElapsedHour = 0;
                continue;
            }
            if (inFormatQuote) {
                if (c == ']') {
                    if (maybeElapsedHour != true) continue;
                    return true;
                }
                if (c == 'h' && maybeElapsedHour == 0) {
                    maybeElapsedHour = 2;
                    continue;
                }
                if (c == 's' && maybeElapsedHour == 0) {
                    maybeElapsedHour = 2;
                    continue;
                }
                if (c == 'm' && maybeElapsedHour == 0) {
                    maybeElapsedHour = 2;
                    continue;
                }
                maybeElapsedHour = 1;
                continue;
            }
            if (!inQuote && c == '\"') {
                inQuote = true;
                continue;
            }
            if (inQuote) {
                if (c != '\"') continue;
                inQuote = false;
                continue;
            }
            if (c != 'm' && c != 'd' && c != 'y' && c != 'h' && c != 's' && c != 'A' && c != 'a' && c != 'P' && c != 'p') continue;
            return true;
        }
        return false;
    }
}

