/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;
import org.pentaho.reporting.ui.datasources.table.Messages;
import org.pentaho.reporting.ui.datasources.table.TypedHeaderInformation;

public class TypedHeaderCellEditor
implements TableCellEditor {
    private EventListenerList eventListenerList;
    private JPanel editorPanel;
    private JTextField nameField = new JTextField();
    private JButton typePopupButton;
    private TypedHeaderInformation value;
    private Class type;
    private JTable table;
    private int editingColumn;

    public TypedHeaderCellEditor() {
        this.nameField.addActionListener(new DefaultTextActionHandler());
        this.typePopupButton = new EllipsisButton((Action)new ShowPopupAction());
        this.editorPanel = new JPanel(new BorderLayout());
        this.editorPanel.add((Component)this.nameField, "Center");
        this.editorPanel.add((Component)this.typePopupButton, "East");
        this.eventListenerList = new EventListenerList();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editingColumn = column;
        this.table = table;
        if (value instanceof TypedHeaderInformation) {
            TypedHeaderInformation headerInformation = (TypedHeaderInformation)value;
            this.nameField.setText(headerInformation.getName());
            this.type = headerInformation.getType();
            this.value = headerInformation;
        } else {
            this.value = null;
            this.type = Object.class;
            this.nameField.setText(null);
        }
        return this.editorPanel;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.value == null) {
            return "<null>";
        }
        return this.value;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)anEvent;
            return mouseEvent.getClickCount() >= 2 && mouseEvent.getButton() == 1;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.value = new TypedHeaderInformation(this.type, this.nameField.getText());
        int proceedConversion = 0;
        if (!this.isTypeConversionSafe()) {
            proceedConversion = JOptionPane.showConfirmDialog(this.table, Messages.getString("TypedHeaderCellEditor.TypeConversionMessage"), Messages.getString("TypedHeaderCellEditor.Warning"), 0);
        }
        if (proceedConversion == 0) {
            this.fireEditingStopped();
        }
        return true;
    }

    private boolean isTypeConversionSafe() {
        boolean result = true;
        for (int rowIndex = 0; rowIndex < this.table.getModel().getRowCount(); ++rowIndex) {
            Object newValue;
            Object currentValue = this.table.getModel().getValueAt(rowIndex, this.editingColumn);
            if (currentValue == null || (newValue = ConverterRegistry.convert((Object)currentValue, (Class)this.type, null)) != null) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.eventListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.eventListenerList.remove(CellEditorListener.class, l);
    }

    public class ShowPopupAction
    extends AbstractAction {
        public ShowPopupAction() {
            this.putValue("Name", "..");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu menu = new JPopupMenu();
            menu.add(new SelectTypeAction(String.class));
            menu.add(new SelectTypeAction(Boolean.class));
            menu.add(new SelectTypeAction(Number.class));
            menu.add(new SelectTypeAction(BigDecimal.class));
            menu.add(new SelectTypeAction(BigInteger.class));
            menu.add(new SelectTypeAction(Double.class));
            menu.add(new SelectTypeAction(Float.class));
            menu.add(new SelectTypeAction(Integer.class));
            menu.add(new SelectTypeAction(Long.class));
            menu.add(new SelectTypeAction(Short.class));
            menu.add(new SelectTypeAction(Byte.class));
            menu.add(new SelectTypeAction(java.util.Date.class));
            menu.add(new SelectTypeAction(Date.class));
            menu.add(new SelectTypeAction(Time.class));
            menu.add(new SelectTypeAction(Timestamp.class));
            menu.add(new SelectTypeAction(Object.class));
            Object source = e.getSource();
            if (source instanceof Component) {
                Component c = (Component)source;
                menu.show(c, 0, c.getHeight());
            } else {
                JButton parent = TypedHeaderCellEditor.this.typePopupButton;
                menu.show(parent, 0, 0);
            }
        }
    }

    private class SelectTypeAction
    extends AbstractAction {
        private Class type;

        private SelectTypeAction(Class type) {
            this.type = type;
            this.putValue("Name", type.getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TypedHeaderCellEditor.this.type = this.type;
            TypedHeaderCellEditor.this.stopCellEditing();
        }
    }

    private class DefaultTextActionHandler
    implements ActionListener {
        private DefaultTextActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TypedHeaderCellEditor.this.stopCellEditing();
        }
    }
}

