/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca;

import com.googlecode.jsendnsca.Level;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.utils.ByteArrayUtils;
import java.util.zip.CRC32;

class PassiveCheckBytesBuilder {
    private static final short NSCA_VERSION = 3;
    private static final int PLUGIN_OUTPUT_SIZE = 512;
    private static final int HOST_NAME_SIZE = 64;
    private static final int SERVICE_NAME_SIZE = 128;
    private final byte[] bytes = new byte[720];
    private int currentOffset = 0;

    public PassiveCheckBytesBuilder() {
        ByteArrayUtils.writeShort(this.bytes, (short)3, this.currentOffset);
        this.currentOffset += 8;
    }

    public PassiveCheckBytesBuilder withLevel(Level level) {
        ByteArrayUtils.writeShort(this.bytes, (short)level.ordinal(), this.currentOffset);
        this.currentOffset += 2;
        return this;
    }

    public PassiveCheckBytesBuilder withTimeStamp(int value) {
        ByteArrayUtils.writeInteger(this.bytes, value, this.currentOffset);
        this.currentOffset += 4;
        return this;
    }

    public PassiveCheckBytesBuilder withHostname(String hostname) {
        this.writeFixedString(hostname, 63);
        this.skipBytes(1);
        return this;
    }

    public PassiveCheckBytesBuilder withServiceName(String serviceName) {
        this.writeFixedString(serviceName, 127);
        this.skipBytes(1);
        return this;
    }

    public PassiveCheckBytesBuilder withMessage(String message) {
        this.writeFixedString(message, 511);
        this.skipBytes(1);
        return this;
    }

    public PassiveCheckBytesBuilder skipBytes(int numberToSkip) {
        this.currentOffset += numberToSkip;
        return this;
    }

    public PassiveCheckBytesBuilder writeCRC() {
        CRC32 crc = new CRC32();
        crc.update(this.bytes);
        ByteArrayUtils.writeInteger(this.bytes, (int)crc.getValue(), 4);
        return this;
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    public PassiveCheckBytesBuilder encrypt(byte[] initVector, NagiosSettings nagiosSettings) {
        nagiosSettings.getEncryptor().encrypt(this.bytes, initVector, nagiosSettings.getPassword());
        return this;
    }

    private void writeFixedString(String value, int fixedSize) {
        ByteArrayUtils.writeFixedString(this.bytes, value, this.currentOffset, fixedSize);
        this.currentOffset += fixedSize;
    }
}

