/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.util;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Add;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Divide;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.EqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.GTOrEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.GreaterThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.LTOrEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.LessThanExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Mod;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Multiply;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.NotEqualToExpr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POAnd;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POBinCond;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POCast;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POIsNull;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POMapLookUp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONegative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PONot;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POOr;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORegexp;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserComparisonFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.Subtract;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCombinerPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCross;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODemux;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POJoinPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMultiQueryPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PONative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POOptimizedForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPartialAgg;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPartitionRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPreCombinerLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class PlanHelper {
    private static final Log log = LogFactory.getLog(new PlanHelper().getClass());

    private PlanHelper() {
    }

    public static String makeStoreTmpPath(String orig) {
        Path path = new Path(orig);
        URI uri = path.toUri();
        uri.normalize();
        String pathStr = uri.getPath();
        if (path.isAbsolute()) {
            return new Path("abs" + pathStr).toString();
        }
        return new Path("rel/" + pathStr).toString();
    }

    public static <C extends PhysicalOperator> boolean containsPhysicalOperator(PhysicalPlan plan, Class<C> opClass) throws VisitorException {
        OpFinder<C> finder = new OpFinder<C>(plan, opClass);
        finder.visit();
        return finder.planContainsOp();
    }

    public static <C extends PhysicalOperator> LinkedList<C> getPhysicalOperators(PhysicalPlan plan, Class<C> opClass) throws VisitorException {
        OpFinder<C> finder = new OpFinder<C>(plan, opClass);
        finder.visit();
        return finder.getFoundOps();
    }

    private static class OpFinder<C extends PhysicalOperator>
    extends PhyPlanVisitor {
        final Class<C> opClass;
        private LinkedList<C> foundOps = Lists.newLinkedList();

        public OpFinder(PhysicalPlan plan, Class<C> opClass) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.opClass = opClass;
        }

        public LinkedList<C> getFoundOps() {
            return this.foundOps;
        }

        public boolean planContainsOp() {
            return !this.foundOps.isEmpty();
        }

        private void visit(PhysicalOperator op) {
            if (this.opClass.isAssignableFrom(op.getClass())) {
                this.foundOps.add(op);
            }
        }

        @Override
        public void visitLoad(POLoad ld) throws VisitorException {
            super.visitLoad(ld);
            this.visit(ld);
        }

        @Override
        public void visitStore(POStore st) throws VisitorException {
            super.visitStore(st);
            this.visit(st);
        }

        @Override
        public void visitNative(PONative nat) throws VisitorException {
            super.visitNative(nat);
            this.visit(nat);
        }

        @Override
        public void visitFilter(POFilter fl) throws VisitorException {
            super.visitFilter(fl);
            this.visit(fl);
        }

        @Override
        public void visitCollectedGroup(POCollectedGroup mg) throws VisitorException {
            super.visitCollectedGroup(mg);
            this.visit(mg);
        }

        @Override
        public void visitLocalRearrange(POLocalRearrange lr) throws VisitorException {
            super.visitLocalRearrange(lr);
            this.visit(lr);
        }

        @Override
        public void visitGlobalRearrange(POGlobalRearrange gr) throws VisitorException {
            super.visitGlobalRearrange(gr);
            this.visit(gr);
        }

        @Override
        public void visitPackage(POPackage pkg) throws VisitorException {
            super.visitPackage(pkg);
            this.visit(pkg);
        }

        @Override
        public void visitCombinerPackage(POCombinerPackage pkg) throws VisitorException {
            super.visitCombinerPackage(pkg);
            this.visit(pkg);
        }

        @Override
        public void visitMultiQueryPackage(POMultiQueryPackage pkg) throws VisitorException {
            super.visitMultiQueryPackage(pkg);
            this.visit(pkg);
        }

        @Override
        public void visitPOForEach(POForEach nfe) throws VisitorException {
            super.visitPOForEach(nfe);
            this.visit(nfe);
        }

        @Override
        public void visitUnion(POUnion un) throws VisitorException {
            super.visitUnion(un);
            this.visit(un);
        }

        @Override
        public void visitSplit(POSplit spl) throws VisitorException {
            super.visitSplit(spl);
            this.visit(spl);
        }

        @Override
        public void visitDemux(PODemux demux) throws VisitorException {
            super.visitDemux(demux);
            this.visit(demux);
        }

        @Override
        public void visitDistinct(PODistinct distinct) throws VisitorException {
            super.visitDistinct(distinct);
            this.visit(distinct);
        }

        @Override
        public void visitSort(POSort sort) throws VisitorException {
            super.visitSort(sort);
            this.visit(sort);
        }

        @Override
        public void visitConstant(ConstantExpression cnst) throws VisitorException {
            super.visitConstant(cnst);
            this.visit(cnst);
        }

        @Override
        public void visitProject(POProject proj) throws VisitorException {
            super.visitProject(proj);
            this.visit(proj);
        }

        @Override
        public void visitGreaterThan(GreaterThanExpr grt) throws VisitorException {
            super.visitGreaterThan(grt);
            this.visit(grt);
        }

        @Override
        public void visitLessThan(LessThanExpr lt) throws VisitorException {
            super.visitLessThan(lt);
            this.visit(lt);
        }

        @Override
        public void visitGTOrEqual(GTOrEqualToExpr gte) throws VisitorException {
            super.visitGTOrEqual(gte);
            this.visit(gte);
        }

        @Override
        public void visitLTOrEqual(LTOrEqualToExpr lte) throws VisitorException {
            super.visitLTOrEqual(lte);
            this.visit(lte);
        }

        @Override
        public void visitEqualTo(EqualToExpr eq) throws VisitorException {
            super.visitEqualTo(eq);
            this.visit(eq);
        }

        @Override
        public void visitNotEqualTo(NotEqualToExpr eq) throws VisitorException {
            super.visitNotEqualTo(eq);
            this.visit(eq);
        }

        @Override
        public void visitRegexp(PORegexp re) throws VisitorException {
            super.visitRegexp(re);
            this.visit(re);
        }

        @Override
        public void visitIsNull(POIsNull isNull) throws VisitorException {
            super.visitIsNull(isNull);
            this.visit(isNull);
        }

        @Override
        public void visitAdd(Add add) throws VisitorException {
            super.visitAdd(add);
            this.visit(add);
        }

        @Override
        public void visitSubtract(Subtract sub) throws VisitorException {
            super.visitSubtract(sub);
            this.visit(sub);
        }

        @Override
        public void visitMultiply(Multiply mul) throws VisitorException {
            super.visitMultiply(mul);
            this.visit(mul);
        }

        @Override
        public void visitDivide(Divide dv) throws VisitorException {
            super.visitDivide(dv);
            this.visit(dv);
        }

        @Override
        public void visitMod(Mod mod) throws VisitorException {
            super.visitMod(mod);
            this.visit(mod);
        }

        @Override
        public void visitAnd(POAnd and) throws VisitorException {
            super.visitAnd(and);
            this.visit(and);
        }

        @Override
        public void visitOr(POOr or) throws VisitorException {
            super.visitOr(or);
            this.visit(or);
        }

        @Override
        public void visitNot(PONot not) throws VisitorException {
            super.visitNot(not);
            this.visit(not);
        }

        @Override
        public void visitBinCond(POBinCond binCond) {
            super.visitBinCond(binCond);
            this.visit(binCond);
        }

        @Override
        public void visitNegative(PONegative negative) {
            super.visitNegative(negative);
            this.visit(negative);
        }

        @Override
        public void visitUserFunc(POUserFunc userFunc) throws VisitorException {
            super.visitUserFunc(userFunc);
            this.visit(userFunc);
        }

        @Override
        public void visitComparisonFunc(POUserComparisonFunc compFunc) throws VisitorException {
            super.visitComparisonFunc(compFunc);
            this.visit(compFunc);
        }

        @Override
        public void visitMapLookUp(POMapLookUp mapLookUp) {
            super.visitMapLookUp(mapLookUp);
            this.visit(mapLookUp);
        }

        @Override
        public void visitJoinPackage(POJoinPackage joinPackage) throws VisitorException {
            super.visitJoinPackage(joinPackage);
            this.visit(joinPackage);
        }

        @Override
        public void visitCast(POCast cast) {
            super.visitCast(cast);
            this.visit(cast);
        }

        @Override
        public void visitLimit(POLimit lim) throws VisitorException {
            super.visitLimit(lim);
            this.visit(lim);
        }

        @Override
        public void visitCross(POCross cross) throws VisitorException {
            super.visitCross(cross);
            this.visit(cross);
        }

        @Override
        public void visitFRJoin(POFRJoin join) throws VisitorException {
            super.visitFRJoin(join);
            this.visit(join);
        }

        @Override
        public void visitMergeJoin(POMergeJoin join) throws VisitorException {
            super.visitMergeJoin(join);
            this.visit(join);
        }

        @Override
        public void visitMergeCoGroup(POMergeCogroup mergeCoGrp) throws VisitorException {
            super.visitMergeCoGroup(mergeCoGrp);
            this.visit(mergeCoGrp);
        }

        @Override
        public void visitStream(POStream stream) throws VisitorException {
            super.visitStream(stream);
            this.visit(stream);
        }

        @Override
        public void visitSkewedJoin(POSkewedJoin sk) throws VisitorException {
            super.visitSkewedJoin(sk);
            this.visit(sk);
        }

        @Override
        public void visitPartitionRearrange(POPartitionRearrange pr) throws VisitorException {
            super.visitPartitionRearrange(pr);
            this.visit(pr);
        }

        @Override
        public void visitPOOptimizedForEach(POOptimizedForEach optimizedForEach) throws VisitorException {
            super.visitPOOptimizedForEach(optimizedForEach);
            this.visit(optimizedForEach);
        }

        @Override
        public void visitPreCombinerLocalRearrange(POPreCombinerLocalRearrange preCombinerLocalRearrange) {
            super.visitPreCombinerLocalRearrange(preCombinerLocalRearrange);
            this.visit(preCombinerLocalRearrange);
        }

        @Override
        public void visitPartialAgg(POPartialAgg poPartialAgg) {
            super.visitPartialAgg(poPartialAgg);
            this.visit(poPartialAgg);
        }
    }
}

