/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.Map;
import org.apache.pig.FilterFunc;
import org.apache.pig.TerminatingAccumulator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

public class IsEmpty
extends FilterFunc
implements TerminatingAccumulator<Boolean> {
    private boolean isEmpty = true;

    @Override
    public Boolean exec(Tuple input) throws IOException {
        Object values = input.get(0);
        if (values instanceof DataBag) {
            return ((DataBag)values).size() == 0L;
        }
        if (values instanceof Map) {
            return ((Map)values).size() == 0;
        }
        int errCode = 2102;
        String msg = "Cannot test a " + DataType.findTypeName(values) + " for emptiness.";
        throw new ExecException(msg, errCode, 4);
    }

    @Override
    public boolean isFinished() {
        return !this.isEmpty;
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        this.isEmpty &= this.exec(b).booleanValue();
    }

    @Override
    public void cleanup() {
        this.isEmpty = true;
    }

    @Override
    public Boolean getValue() {
        return this.isEmpty;
    }
}

