/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigHadoopLogger;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigLogger;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.DefaultTuple;
import org.apache.pig.data.FileList;
import org.apache.pig.data.InterSedes;
import org.apache.pig.data.InterSedesFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.BagFormat;
import org.apache.pig.impl.util.SpillableMemoryManager;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public abstract class DefaultAbstractBag
implements DataBag {
    private static final Log log = LogFactory.getLog(DataBag.class);
    private static final int SPILL_REGISTER_THRESHOLD = 102400;
    private static PigLogger pigLogger = PhysicalOperator.getPigLogger();
    private static InterSedes sedes = InterSedesFactory.getInterSedesInstance();
    protected Collection<Tuple> mContents;
    protected FileList mSpillFiles;
    protected long mSize = 0L;
    protected int mLastContentsSize = -1;
    protected long avgTupleSize = 0L;
    private boolean spillableRegistered = false;
    public static final Tuple startBag = new StartBag();
    public static final Tuple endBag = new EndBag();
    protected static final int MAX_SPILL_FILES = 100;

    @Override
    public long size() {
        return this.mSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Tuple t) {
        Collection<Tuple> collection = this.mContents;
        synchronized (collection) {
            ++this.mSize;
            this.mContents.add(t);
        }
        this.markSpillableIfNecessary();
    }

    protected void markSpillableIfNecessary() {
        if (!this.spillableRegistered && this.getMemorySize() >= 102400L) {
            SpillableMemoryManager.getInstance().registerSpillable(this);
            this.spillableRegistered = true;
        }
    }

    @Override
    public void addAll(DataBag b) {
        this.addAll((Iterable<Tuple>)b);
    }

    public void addAll(Collection<Tuple> c) {
        this.addAll((Iterable<Tuple>)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Iterable<Tuple> iterable) {
        Collection<Tuple> collection = this.mContents;
        synchronized (collection) {
            for (Tuple t : iterable) {
                this.add(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMemorySize() {
        int j = 0;
        int numInMem = 0;
        Collection<Tuple> collection = this.mContents;
        synchronized (collection) {
            numInMem = this.mContents.size();
            if (this.avgTupleSize != 0L && (this.mLastContentsSize == numInMem || this.mLastContentsSize > 100 && numInMem > 100)) {
                return this.totalSizeFromAvgTupleSize(this.avgTupleSize, numInMem);
            }
            Iterator<Tuple> i = this.mContents.iterator();
            for (j = 0; i.hasNext() && j < 100; ++j) {
                this.avgTupleSize += i.next().getMemorySize();
            }
        }
        this.mLastContentsSize = numInMem;
        this.avgTupleSize = j != 0 ? (this.avgTupleSize /= (long)j) : 0L;
        return this.totalSizeFromAvgTupleSize(this.avgTupleSize, numInMem);
    }

    private long totalSizeFromAvgTupleSize(long avgTupleSize, int numInMem) {
        long used = avgTupleSize * (long)numInMem;
        int bag_fix_size = 84;
        long mFields_size = this.roundToEight(4 + numInMem * 4);
        mFields_size = Math.max(40L, mFields_size);
        used += (long)bag_fix_size + mFields_size;
        if (this.mSpillFiles != null) {
            used += this.roundToEight(36 + this.mSpillFiles.size() * 4);
            if (this.mSpillFiles.size() > 0) {
                long approx_per_entry_size = this.roundToEight(((File)this.mSpillFiles.get(0)).toString().length() * 2 + 38);
                used += (long)this.mSpillFiles.size() * approx_per_entry_size;
            }
        }
        return used;
    }

    private long roundToEight(long i) {
        return 8L * ((i + 7L) / 8L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Collection<Tuple> collection = this.mContents;
        synchronized (collection) {
            this.mContents.clear();
            if (this.mSpillFiles != null) {
                for (int i = 0; i < this.mSpillFiles.size(); ++i) {
                    boolean res = ((File)this.mSpillFiles.get(i)).delete();
                    if (res) continue;
                    this.warn("DefaultAbstractBag.clear: failed to delete " + this.mSpillFiles.get(i), PigWarning.DELETE_FAILED, null);
                }
                this.mSpillFiles.clear();
            }
            this.mSize = 0L;
        }
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        if (other instanceof DataBag) {
            DataBag otherClone;
            Iterator<Tuple> i;
            DataBag thisClone;
            DataBag bOther = (DataBag)other;
            if (this.size() != bOther.size()) {
                if (this.size() > bOther.size()) {
                    return 1;
                }
                return -1;
            }
            BagFactory factory = BagFactory.getInstance();
            if (this.isSorted() || this.isDistinct()) {
                thisClone = this;
            } else {
                thisClone = factory.newSortedBag(null);
                i = this.iterator();
                while (i.hasNext()) {
                    thisClone.add(i.next());
                }
            }
            if (((DataBag)other).isSorted() || ((DataBag)other).isDistinct()) {
                otherClone = bOther;
            } else {
                otherClone = factory.newSortedBag(null);
                i = bOther.iterator();
                while (i.hasNext()) {
                    otherClone.add(i.next());
                }
            }
            Iterator<Tuple> thisIt = thisClone.iterator();
            Iterator<Tuple> otherIt = otherClone.iterator();
            while (thisIt.hasNext() && otherIt.hasNext()) {
                Tuple otherT;
                Tuple thisT = thisIt.next();
                int c = thisT.compareTo(otherT = otherIt.next());
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
        return DataType.compare(this, other);
    }

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public void write(DataOutput out) throws IOException {
        sedes.writeDatum(out, this);
    }

    public void readFields(DataInput in) throws IOException {
        long size = in.readLong();
        for (long i = 0L; i < size; ++i) {
            Object o = sedes.readDatum(in);
            this.add((Tuple)o);
            continue;
        }
    }

    @Override
    public void markStale(boolean stale) {
    }

    public String toString() {
        return BagFormat.format(this);
    }

    public int hashCode() {
        int hash = 1;
        Iterator<Tuple> i = this.iterator();
        while (i.hasNext()) {
            hash = 37 * hash + i.next().hashCode();
        }
        return hash;
    }

    protected DataOutputStream getSpillFile() throws IOException {
        String tmpDirName;
        File tmpDir;
        if (this.mSpillFiles == null) {
            this.mSpillFiles = new FileList(1);
        }
        if (!(tmpDir = new File(tmpDirName = System.getProperties().getProperty("java.io.tmpdir"))).exists()) {
            log.info((Object)("Temporary directory doesn't exists. Trying to create: " + tmpDir.getAbsolutePath()));
            if (tmpDir.mkdir()) {
                log.info((Object)("Successfully created temporary directory: " + tmpDir.getAbsolutePath()));
            } else if (tmpDir.exists()) {
                log.info((Object)("Temporary directory already exists: " + tmpDir.getAbsolutePath()));
            } else {
                int errCode = 2111;
                String msg = "Unable to create temporary directory: " + tmpDir.getAbsolutePath();
                throw new ExecException(msg, errCode, 4);
            }
        }
        File f = File.createTempFile("pigbag", null);
        f.deleteOnExit();
        this.mSpillFiles.add(f);
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
    }

    protected void reportProgress() {
        if (PhysicalOperator.getReporter() != null) {
            PhysicalOperator.getReporter().progress();
        }
    }

    protected void warn(String msg, Enum warningEnum, Exception e) {
        pigLogger = PhysicalOperator.getPigLogger();
        if (pigLogger != null) {
            pigLogger.warn(this, msg, warningEnum);
        } else {
            log.warn((Object)msg, (Throwable)e);
        }
    }

    protected void incSpillCount(Enum counter) {
        this.incSpillCount(counter, 1L);
    }

    protected void incSpillCount(Enum counter, long numRecsSpilled) {
        PigStatusReporter reporter = PigStatusReporter.getInstance();
        if (reporter != null && reporter.getCounter(counter) != null) {
            reporter.getCounter(counter).increment(numRecsSpilled);
        } else {
            PigHadoopLogger.getInstance().warn(this, "Spill counter incremented", counter);
        }
    }

    public static class EndBag
    extends BagDelimiterTuple {
        private static final long serialVersionUID = 1L;
    }

    public static class StartBag
    extends BagDelimiterTuple {
        private static final long serialVersionUID = 1L;
    }

    public static abstract class BagDelimiterTuple
    extends DefaultTuple {
    }
}

