/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.pig.PigStreamingBase;
import org.apache.pig.PigToStream;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.WritableByteArray;

public abstract class InputHandler {
    protected PigToStream serializer;
    private PigStreamingBase newSerializer;
    private OutputStream out;
    protected boolean alreadyClosed = false;

    public abstract InputType getInputType();

    public void putNext(Tuple t) throws IOException {
        if (this.newSerializer != null) {
            WritableByteArray buf = this.newSerializer.serializeToBytes(t);
            this.out.write(buf.getData(), 0, buf.getLength());
        } else {
            this.out.write(this.serializer.serialize(t));
        }
    }

    public synchronized void close(Process process) throws IOException {
        if (!this.alreadyClosed) {
            this.alreadyClosed = true;
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    public void bindTo(OutputStream os) throws IOException {
        this.out = os;
        if (this.serializer instanceof PigStreamingBase) {
            this.newSerializer = (PigStreamingBase)this.serializer;
        }
    }

    public static enum InputType {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }
}

