/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jruby;

import java.io.IOException;
import org.apache.pig.AccumulatorEvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.scripting.jruby.JrubyScriptEngine;
import org.apache.pig.scripting.jruby.PigJrubyLibrary;
import org.apache.pig.scripting.jruby.RubyDataBag;
import org.apache.pig.scripting.jruby.RubySchema;
import org.jruby.Ruby;
import org.jruby.embed.ScriptingContainer;
import org.jruby.runtime.builtin.IRubyObject;

public class JrubyAccumulatorEvalFunc
extends AccumulatorEvalFunc<Object> {
    private Object methodReceiver;
    private Object classObject;
    private boolean isInitialized = false;
    private String path;
    private String methodName;
    private static final ScriptingContainer rubyEngine = JrubyScriptEngine.rubyEngine;
    private static final Ruby ruby = rubyEngine.getProvider().getRuntime();

    private JrubyAccumulatorEvalFunc() {
    }

    public JrubyAccumulatorEvalFunc(String path, String methodName) {
        this.path = path;
        this.methodName = methodName;
    }

    private void initialize() {
        this.classObject = JrubyScriptEngine.RubyFunctions.getFunctions("accumulator", this.path).get(this.methodName);
        this.methodReceiver = rubyEngine.callMethod(this.classObject, "new", new Object[0]);
        this.isInitialized = true;
    }

    @Override
    public void accumulate(Tuple b) throws IOException {
        if (!this.isInitialized) {
            this.initialize();
        }
        RubyDataBag db = new RubyDataBag(ruby, ruby.getClass("DataBag"), (DataBag)b.get(0));
        rubyEngine.callMethod(this.methodReceiver, "exec", (Object)db, IRubyObject.class);
    }

    @Override
    public void cleanup() {
        this.isInitialized = false;
        this.methodReceiver = null;
    }

    @Override
    public Object getValue() {
        IRubyObject rubyResult = (IRubyObject)rubyEngine.callMethod(this.methodReceiver, "get", IRubyObject.class);
        try {
            return PigJrubyLibrary.rubyToPig(rubyResult);
        }
        catch (ExecException e) {
            throw new RuntimeException("Unable to convert result from Ruby to Pig: " + rubyResult, e);
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        if (!this.isInitialized) {
            this.initialize();
        }
        RubySchema rs = PigJrubyLibrary.pigToRuby(ruby, input);
        return PigJrubyLibrary.rubyToPig((RubySchema)((Object)rubyEngine.callMethod(this.classObject, "get_output_schema", (Object)rs, RubySchema.class)));
    }
}

