/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.counters;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public class PigCounterHelper {
    private final Map<Pair<String, String>, Long> counterStringMap_ = Maps.newHashMap();
    private final Map<Enum<?>, Long> counterEnumMap_ = Maps.newHashMap();

    public void incrCounter(String group, String counterName, long incr) {
        Pair<String, String> key;
        Counter counter;
        PigStatusReporter reporter = PigStatusReporter.getInstance();
        if (reporter != null && (counter = reporter.getCounter(group, counterName)) != null) {
            counter.increment(incr);
            if (this.counterStringMap_.size() > 0) {
                for (Map.Entry<Pair<String, String>, Long> entry : this.counterStringMap_.entrySet()) {
                    reporter.getCounter((String)entry.getKey().first, (String)entry.getKey().second).increment(entry.getValue().longValue());
                }
                this.counterStringMap_.clear();
            }
            return;
        }
        Long currentValue = this.counterStringMap_.get(key = new Pair<String, String>(group, counterName));
        this.counterStringMap_.put(key, (currentValue == null ? 0L : currentValue) + incr);
    }

    public void incrCounter(Enum<?> key, long incr) {
        PigStatusReporter reporter = PigStatusReporter.getInstance();
        if (reporter != null && reporter.getCounter(key) != null) {
            reporter.getCounter(key).increment(incr);
            if (this.counterEnumMap_.size() > 0) {
                for (Map.Entry<Enum<?>, Long> entry : this.counterEnumMap_.entrySet()) {
                    reporter.getCounter(entry.getKey()).increment(entry.getValue().longValue());
                }
                this.counterEnumMap_.clear();
            }
        } else {
            Long currentValue = this.counterEnumMap_.get(key);
            this.counterEnumMap_.put(key, (currentValue == null ? 0L : currentValue) + incr);
        }
    }
}

