/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XMLTokener;

public class XML {
    public static final Character AMP = new Character('&');
    public static final Character APOS = new Character('\'');
    public static final Character BANG = new Character('!');
    public static final Character EQ = new Character('=');
    public static final Character GT = new Character('>');
    public static final Character LT = new Character('<');
    public static final Character QUEST = new Character('?');
    public static final Character QUOT = new Character('\"');
    public static final Character SLASH = new Character('/');
    public static final String TYPE_ATTRIB = "jsonType";
    public static final String ARRAY_ATTRIB = "jsonIsArray";
    public static final String ISNULL_ATTRIB = "isNull";

    public static String escape(String string) {
        StringBuffer sb = new StringBuffer();
        int len = string.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static void noSpace(String string) throws JSONException {
        int length = string.length();
        if (length == 0) {
            throw new JSONException("Empty string.");
        }
        for (int i = 0; i < length; ++i) {
            if (!Character.isWhitespace(string.charAt(i))) continue;
            throw new JSONException("'" + string + "' contains a space character.");
        }
    }

    private static boolean parse(XMLTokener x, JSONObject context, String name, boolean typed) throws JSONException {
        String s;
        JSONObject o = null;
        Object t = x.nextToken();
        if (t == BANG) {
            char c = x.next();
            if (c == '-') {
                if (x.next() == '-') {
                    x.skipPast("-->");
                    return false;
                }
                x.back();
            } else if (c == '[') {
                t = x.nextToken();
                if (t.equals("CDATA") && x.next() == '[') {
                    String s2 = x.nextCDATA();
                    if (s2.length() > 0) {
                        context.accumulate("content", s2);
                    }
                    return false;
                }
                throw x.syntaxError("Expected 'CDATA['");
            }
            int i = 1;
            do {
                if ((t = x.nextMeta()) == null) {
                    throw x.syntaxError("Missing '>' after '<!'.");
                }
                if (t == LT) {
                    ++i;
                    continue;
                }
                if (t != GT) continue;
                --i;
            } while (i > 0);
            return false;
        }
        if (t == QUEST) {
            x.skipPast("?>");
            return false;
        }
        if (t == SLASH) {
            t = x.nextToken();
            if (name == null) {
                throw x.syntaxError("Mismatched close tag" + t);
            }
            if (!t.equals(name)) {
                throw x.syntaxError("Mismatched " + name + " and " + t);
            }
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped close tag");
            }
            return true;
        }
        if (t instanceof Character) {
            throw x.syntaxError("Misshaped tag");
        }
        String n = (String)t;
        t = null;
        o = new JSONObject();
        while (true) {
            if (t == null) {
                t = x.nextToken();
            }
            if (!(t instanceof String)) break;
            s = (String)t;
            t = x.nextToken();
            if (t == EQ) {
                t = x.nextToken();
                if (!(t instanceof String)) {
                    throw x.syntaxError("Missing value");
                }
                o.accumulate(s, t);
                t = null;
                continue;
            }
            o.accumulate(s, "");
        }
        if (t == SLASH) {
            if (x.nextToken() != GT) {
                throw x.syntaxError("Misshaped tag");
            }
            String isNull = (String)o.remove(ISNULL_ATTRIB);
            if ("true".equals(isNull)) {
                context.accumulate(n, JSONObject.NULL);
            } else if (typed) {
                String type = (String)o.remove(TYPE_ATTRIB);
                String isArr = (String)o.remove(ARRAY_ATTRIB);
                if (isArr != null && isArr.equals("true")) {
                    if (type != null && type.equals("string")) {
                        context.append(n, "");
                    } else {
                        context.append(n, o);
                    }
                } else if (type != null && type.equals("string")) {
                    context.accumulate(n, "");
                } else {
                    context.accumulate(n, o);
                }
            } else {
                context.accumulate(n, o);
            }
            return false;
        }
        if (t == GT) {
            while (true) {
                if ((t = x.nextContent()) == null) {
                    if (n != null) {
                        throw x.syntaxError("Unclosed tag " + n);
                    }
                    return false;
                }
                if (t instanceof String) {
                    s = (String)t;
                    if (s.length() <= 0) continue;
                    o.accumulate("content", s);
                    continue;
                }
                if (t == LT && XML.parse(x, o, n, typed)) break;
            }
            String isArr = null;
            if (typed) {
                String type = (String)o.remove(TYPE_ATTRIB);
                isArr = (String)o.remove(ARRAY_ATTRIB);
            }
            if (isArr != null && isArr.equals("true")) {
                if (o.length() == 0) {
                    context.append(n, "");
                } else if (o.length() == 1 && o.opt("content") != null) {
                    context.append(n, o.opt("content"));
                } else {
                    context.append(n, o);
                }
            } else if (o.length() == 0) {
                context.accumulate(n, "");
            } else if (o.length() == 1 && o.opt("content") != null) {
                context.accumulate(n, o.opt("content"));
            } else {
                context.accumulate(n, o);
            }
            return false;
        }
        throw x.syntaxError("Misshaped tag");
    }

    public static JSONObject toJSONObject(String string) throws JSONException {
        return XML.toJSONObject(string, false);
    }

    public static JSONObject toJSONObject(String string, boolean typed) throws JSONException {
        JSONObject o = new JSONObject();
        XMLTokener x = new XMLTokener(string);
        while (x.more() && x.skipPast("<")) {
            XML.parse(x, o, null, typed);
        }
        return o;
    }

    public static String toString(Object o) throws JSONException {
        return XML.toString(o, null);
    }

    public static String toString(Object o, String tagName) throws JSONException {
        return XML.toString(o, tagName, false, false);
    }

    public static String toString(Object o, String tagName, boolean typed) throws JSONException {
        return XML.toString(o, tagName, typed, false);
    }

    private static String toString(Object o, String tagName, boolean typed, boolean isArray) throws JSONException {
        String s;
        StringBuffer b = new StringBuffer();
        if (o instanceof JSONObject) {
            if (tagName != null) {
                b.append('<');
                b.append(tagName);
                if (typed) {
                    b.append(" jsonType=\"object\"");
                    if (isArray) {
                        b.append(" jsonIsArray=\"" + isArray + "\"");
                    }
                    b.append(">");
                } else {
                    b.append('>');
                }
            }
            JSONObject jo = (JSONObject)o;
            Iterator keys = jo.keys();
            while (keys.hasNext()) {
                int i;
                int len;
                JSONArray ja;
                String k = keys.next().toString();
                Object v = jo.get(k);
                String s2 = v instanceof String ? (String)v : null;
                if (k.equals("content")) {
                    if (v instanceof JSONArray) {
                        ja = (JSONArray)v;
                        len = ja.length();
                        for (i = 0; i < len; ++i) {
                            if (i > 0) {
                                b.append('\n');
                            }
                            b.append(XML.escape(ja.get(i).toString()));
                        }
                        continue;
                    }
                    b.append(XML.escape(v.toString()));
                    continue;
                }
                if (v instanceof JSONArray) {
                    ja = (JSONArray)v;
                    len = ja.length();
                    for (i = 0; i < len; ++i) {
                        b.append(XML.toString(ja.get(i), k, typed, true));
                    }
                    continue;
                }
                if (v.equals("")) {
                    b.append('<');
                    b.append(k);
                    if (typed) {
                        b.append(" jsonType=\"string\"");
                        if (isArray) {
                            b.append(" jsonIsArray=\"" + isArray + "\"");
                        }
                        b.append("/>");
                        continue;
                    }
                    b.append("/>");
                    continue;
                }
                b.append(XML.toString(v, k, typed, false));
            }
            if (tagName != null) {
                b.append("</");
                b.append(tagName);
                b.append('>');
            }
            return b.toString();
        }
        if (o instanceof JSONArray) {
            JSONArray ja = (JSONArray)o;
            int len = ja.length();
            for (int i = 0; i < len; ++i) {
                b.append(XML.toString(ja.opt(i), tagName == null ? "array" : tagName, typed, true));
            }
            return b.toString();
        }
        boolean valueIsNull = o == null || o == JSONObject.NULL;
        String string = s = valueIsNull ? "" : XML.escape(o.toString());
        if (typed) {
            return tagName == null ? "\"" + s + "\"" : (valueIsNull || s.length() == 0 ? "<" + tagName + (valueIsNull ? " isNull=\"true\"" : "") + "/>" : "<" + tagName + " " + TYPE_ATTRIB + "=\"string\"" + (isArray ? " jsonIsArray=\"" + isArray + "\"" : "") + ">" + s + "</" + tagName + ">");
        }
        return tagName == null ? "\"" + s + "\"" : (valueIsNull || s.length() == 0 ? "<" + tagName + (valueIsNull ? " isNull=\"true\"" : "") + "/>" : "<" + tagName + ">" + s + "</" + tagName + ">");
    }
}

