/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.mapr520;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.hive.jdbc.HiveDriver;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.HadoopConfigurationFileSystemManager;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.common.CommonHadoopShim;
import org.pentaho.hadoop.shim.common.ShimUtils;
import org.pentaho.hadoop.shim.mapr520.ConfigurationProxyV2;
import org.pentaho.hadoop.shim.mapr520.MapR5DistributedCacheUtilImpl;
import org.pentaho.hdfs.vfs.MapRFileProvider;

public class HadoopShim
extends CommonHadoopShim {
    protected static final String SUPER_USER = "authentication.superuser.provider";
    protected static final String PROVIDER_LIST = "authentication.provider.list";
    protected static final String DEFAULT_CLUSTER = "/";
    protected static final String MFS_SCHEME = "maprfs://";
    protected static final String[] EMPTY_CONNECTION_INFO = new String[2];

    @Override
    public String[] getNamenodeConnectionInfo(Configuration c) {
        return EMPTY_CONNECTION_INFO;
    }

    @Override
    public String[] getJobtrackerConnectionInfo(Configuration c) {
        return EMPTY_CONNECTION_INFO;
    }

    @Override
    public void configureConnectionInformation(String namenodeHost, String namenodePort, String jobtrackerHost, String jobtrackerPort, Configuration conf, List<String> logMessages) throws Exception {
        if (namenodeHost == null || namenodeHost.length() == 0) {
            namenodeHost = DEFAULT_CLUSTER;
            logMessages.add("Using MapR default cluster for filesystem");
        } else if (namenodePort == null || namenodePort.trim().length() == 0) {
            logMessages.add("Using MapR CLDB named cluster: " + namenodeHost + " for filesystem");
            namenodeHost = "/mapr/" + namenodeHost;
        } else {
            logMessages.add("Using filesystem at " + namenodeHost + ":" + namenodePort);
            namenodeHost = namenodeHost + ":" + namenodePort;
        }
        if (jobtrackerHost == null || jobtrackerHost.trim().length() == 0) {
            jobtrackerHost = DEFAULT_CLUSTER;
            logMessages.add("Using MapR default cluster for job tracker");
        } else if (jobtrackerPort == null || jobtrackerPort.trim().length() == 0) {
            logMessages.add("Using MapR CLDB named cluster: " + jobtrackerHost + " for job tracker");
            jobtrackerHost = "/mapr/" + jobtrackerHost;
        } else {
            logMessages.add("Using job tracker at " + jobtrackerHost + ":" + jobtrackerPort);
            jobtrackerHost = jobtrackerHost + ":" + jobtrackerPort;
        }
        String fsDefaultName = MFS_SCHEME + namenodeHost;
        String jobTracker = MFS_SCHEME + jobtrackerHost;
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
    }

    @Override
    public Configuration createConfiguration() {
        ConfigurationProxyV2 result;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            result = new ConfigurationProxyV2();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create configuration for new mapreduce api: ", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        ShimUtils.asConfiguration(result).addResource("hbase-site.xml");
        return result;
    }

    @Override
    public void onLoad(HadoopConfiguration config, HadoopConfigurationFileSystemManager fsm) throws Exception {
        fsm.addProvider(config, "maprfs", config.getIdentifier(), (FileProvider)new MapRFileProvider());
        this.setDistributedCacheUtil(new MapR5DistributedCacheUtilImpl(config));
    }

    static {
        JDBC_DRIVER_MAP.put("hive2", HiveDriver.class);
    }
}

