/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.IconRowHeader;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RTextArea;

public class Gutter
extends JComponent {
    private RTextArea textArea;
    private LineNumberList lineNumberList;
    private IconRowHeader iconArea;
    private TextAreaListener listener = new TextAreaListener();

    public Gutter(RTextArea rTextArea) {
        this.setTextArea(rTextArea);
        this.setLayout(new BorderLayout());
        if (this.textArea != null) {
            this.setLineNumbersEnabled(true);
        }
        this.setBorder(new GutterBorder(0, 0, 0, 1));
    }

    public GutterIconInfo addLineTrackingIcon(int n, Icon icon) throws BadLocationException {
        int n2 = this.textArea.getLineStartOffset(n);
        return this.addOffsetTrackingIcon(n2, icon);
    }

    public GutterIconInfo addOffsetTrackingIcon(int n, Icon icon) throws BadLocationException {
        return this.iconArea.addOffsetTrackingIcon(n, icon);
    }

    public Icon getBookmarkIcon() {
        return this.iconArea.getBookmarkIcon();
    }

    public GutterIconInfo[] getBookmarks() {
        return this.iconArea.getBookmarks();
    }

    public Color getBorderColor() {
        return ((GutterBorder)this.getBorder()).getColor();
    }

    public Color getLineNumberColor() {
        return this.lineNumberList.getForeground();
    }

    public Font getLineNumberFont() {
        return this.lineNumberList.getFont();
    }

    public boolean getLineNumbersEnabled() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != this.lineNumberList) continue;
            return true;
        }
        return false;
    }

    public Object[] getTrackingIcons(Point point) throws BadLocationException {
        int n = this.textArea.viewToModel(new Point(0, point.y));
        int n2 = this.textArea.getLineOfOffset(n);
        return this.iconArea.getTrackingIcons(n2);
    }

    public boolean isBookmarkingEnabled() {
        return this.iconArea.isBookmarkingEnabled();
    }

    public boolean isIconRowHeaderEnabled() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != this.iconArea) continue;
            return true;
        }
        return false;
    }

    public void removeTrackingIcon(GutterIconInfo gutterIconInfo) {
        this.iconArea.removeTrackingIcon(gutterIconInfo);
    }

    public void removeAllTrackingIcons() {
        this.iconArea.removeAllTrackingIcons();
    }

    public void setBookmarkIcon(Icon icon) {
        this.iconArea.setBookmarkIcon(icon);
    }

    public void setBookmarkingEnabled(boolean bl) {
        this.iconArea.setBookmarkingEnabled(bl);
        if (bl && !this.isIconRowHeaderEnabled()) {
            this.setIconRowHeaderEnabled(true);
        }
    }

    public void setBorderColor(Color color) {
        ((GutterBorder)this.getBorder()).setColor(color);
        this.repaint();
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation.isLeftToRight()) {
            ((GutterBorder)this.getBorder()).setEdges(0, 0, 0, 1);
        } else {
            ((GutterBorder)this.getBorder()).setEdges(0, 1, 0, 0);
        }
        super.setComponentOrientation(componentOrientation);
    }

    void setIconRowHeaderEnabled(boolean bl) {
        if (this.iconArea != null) {
            if (bl) {
                this.add((Component)this.iconArea, "Before");
            } else {
                this.remove(this.iconArea);
            }
            this.revalidate();
        }
    }

    public void setLineNumberColor(Color color) {
        this.lineNumberList.setForeground(color);
    }

    public void setLineNumberFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font cannot be null");
        }
        this.lineNumberList.setFont(font);
    }

    void setLineNumbersEnabled(boolean bl) {
        if (this.lineNumberList != null) {
            if (bl) {
                this.add(this.lineNumberList);
            } else {
                this.remove(this.lineNumberList);
            }
            this.revalidate();
        }
    }

    void setTextArea(RTextArea rTextArea) {
        if (this.textArea != null) {
            this.listener.uninstall();
        }
        if (this.lineNumberList == null) {
            this.lineNumberList = new LineNumberList(rTextArea);
        } else {
            this.lineNumberList.setTextArea(rTextArea);
        }
        if (this.iconArea == null) {
            this.iconArea = new IconRowHeader(rTextArea);
        } else {
            this.iconArea.setTextArea(rTextArea);
        }
        if (rTextArea != null) {
            this.listener.install(rTextArea);
        }
        this.textArea = rTextArea;
    }

    public boolean toggleBookmark(int n) throws BadLocationException {
        return this.iconArea.toggleBookmark(n);
    }

    private class TextAreaListener
    extends ComponentAdapter
    implements DocumentListener,
    PropertyChangeListener {
        private boolean installed;

        private TextAreaListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Gutter.this.revalidate();
        }

        protected void handleDocumentEvent(DocumentEvent documentEvent) {
            for (int i = 0; i < Gutter.this.getComponentCount(); ++i) {
                AbstractGutterComponent abstractGutterComponent = (AbstractGutterComponent)Gutter.this.getComponent(i);
                abstractGutterComponent.handleDocumentEvent(documentEvent);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        public void install(RTextArea rTextArea) {
            if (this.installed) {
                this.uninstall();
            }
            rTextArea.addComponentListener(this);
            rTextArea.getDocument().addDocumentListener(this);
            rTextArea.addPropertyChangeListener(this);
            this.installed = true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("font".equals(string) || "RSTA.syntaxScheme".equals(string)) {
                for (int i = 0; i < Gutter.this.getComponentCount(); ++i) {
                    AbstractGutterComponent abstractGutterComponent = (AbstractGutterComponent)Gutter.this.getComponent(i);
                    abstractGutterComponent.lineHeightsChanged();
                }
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        public void uninstall() {
            if (this.installed) {
                Gutter.this.textArea.removeComponentListener(this);
                Gutter.this.textArea.getDocument().removeDocumentListener(this);
                this.installed = false;
            }
        }
    }

    private static class GutterBorder
    extends EmptyBorder {
        private Color color = new Color(221, 221, 221);

        public GutterBorder(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        public Color getColor() {
            return this.color;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.color);
            if (this.left == 1) {
                graphics.drawLine(0, 0, 0, n4);
            } else {
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4);
            }
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setEdges(int n, int n2, int n3, int n4) {
            this.top = n;
            this.left = n2;
            this.bottom = n3;
            this.right = n4;
        }
    }
}

