/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.reporting.ui;

import com.debortoliwines.openerp.api.Field;
import com.debortoliwines.openerp.api.FieldCollection;
import com.debortoliwines.openerp.api.ObjectAdapter;
import com.debortoliwines.openerp.api.Session;
import com.debortoliwines.openerp.reporting.di.OpenERPFieldInfo;
import javax.swing.tree.DefaultMutableTreeNode;

public class OpenERPChildTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 3495864713177401698L;
    private boolean areChildrenDefined = false;
    private Session session;
    private OpenERPFieldInfo fieldInfo;

    public OpenERPChildTreeNode(Session session, OpenERPFieldInfo fieldInfo) {
        this.session = session;
        this.fieldInfo = fieldInfo;
    }

    @Override
    public boolean isLeaf() {
        return this.fieldInfo.getRelatedChildModelName().length() == 0;
    }

    @Override
    public int getChildCount() {
        if (!this.areChildrenDefined) {
            this.defineChildNodes();
        }
        return super.getChildCount();
    }

    private void defineChildNodes() {
        this.areChildrenDefined = true;
        try {
            ObjectAdapter adapter = new ObjectAdapter(this.session, this.fieldInfo.getRelatedChildModelName());
            FieldCollection fields = adapter.getFields();
            fields.SortByName();
            for (Field field : fields) {
                this.add(new OpenERPChildTreeNode(this.session, new OpenERPFieldInfo(this.fieldInfo.getRelatedChildModelName(), 1, field.getName(), field.getName(), this.fieldInfo, field.getType(), field.getRelation(), 0, 0)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public OpenERPFieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    @Override
    public String toString() {
        return this.fieldInfo.getFieldName() + (this.fieldInfo.getRelatedChildModelName().length() > 0 ? " (" + this.fieldInfo.getRelatedChildModelName() + ")" : "");
    }
}

