/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3.vfs;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.jets3t.service.security.AWSCredentials;

public class S3FileUtil {
    public static FileObject resolveFile(String fileUri, UserAuthenticator userAuthenticator) throws FileSystemException {
        FileSystemOptions opts = null;
        if (VFS.getManager().getBaseFile() != null) {
            opts = VFS.getManager().getBaseFile().getFileSystem().getFileSystemOptions();
        }
        if (opts == null) {
            opts = new FileSystemOptions();
        }
        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, userAuthenticator);
        FileObject file = S3FileUtil.resolveFile(fileUri, opts);
        return file;
    }

    public static FileObject resolveFile(String fileUri, String username, String password) throws FileSystemException {
        StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator(null, username, password);
        return S3FileUtil.resolveFile(fileUri, (UserAuthenticator)userAuthenticator);
    }

    public static FileObject resolveFile(String fileUri, AWSCredentials credentials) throws FileSystemException {
        return S3FileUtil.resolveFile(fileUri, credentials.getAccessKey(), credentials.getSecretKey());
    }

    public static FileObject resolveFile(String fileUri, FileSystemOptions opts) throws FileSystemException {
        FileObject file = VFS.getManager().resolveFile(fileUri, opts);
        return file;
    }
}

