/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.clients;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroupXmlWriter;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.clients.Query;
import org.pentaho.di.trans.dataservice.clients.TransMutators;
import org.pentaho.di.trans.dataservice.resolvers.DataServiceResolver;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

public class AnnotationsQueryService
implements Query.Service {
    private MetastoreLocator metastoreLocator;
    private DataServiceResolver resolver;

    public AnnotationsQueryService(MetastoreLocator metastoreLocator, DataServiceResolver resolver) {
        this.metastoreLocator = metastoreLocator;
        this.resolver = resolver;
    }

    @Override
    public Query prepareQuery(String sql, int maxRows, Map<String, String> parameters) throws KettleException {
        String prefix = "show annotations from ";
        if (sql.startsWith(prefix.toLowerCase())) {
            return new AnnotationsQuery(sql.substring(prefix.length()));
        }
        return null;
    }

    class AnnotationsQuery
    implements Query {
        private String serviceName;

        public AnnotationsQuery(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            try {
                ModelAnnotationGroup modelAnnotations = (ModelAnnotationGroup)this.prepareExecution().getExtensionDataMap().get("KEY_MODEL_ANNOTATIONS");
                this.writeAnnotations(outputStream, modelAnnotations);
            }
            catch (KettleException | MetaStoreException e) {
                String msg = "Error while executing 'show annotations from " + this.serviceName + "'";
                throw new IOException(msg);
            }
        }

        private void writeAnnotations(OutputStream outputStream, ModelAnnotationGroup modelAnnotations) throws IOException, KettleFileException {
            ModelAnnotationGroupXmlWriter writer = new ModelAnnotationGroupXmlWriter(modelAnnotations);
            DataOutputStream dos = new DataOutputStream(outputStream);
            DataServiceExecutor.writeMetadata(dos, this.serviceName, "", "", "", "");
            RowMeta rowMeta = new RowMeta();
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("annotations"));
            rowMeta.writeMeta(dos);
            Object[] row = new Object[]{writer.getXML().trim()};
            rowMeta.writeData(dos, row);
        }

        private Trans prepareExecution() throws MetaStoreException, KettleException {
            DataServiceMeta dataService = AnnotationsQueryService.this.resolver.getDataService(this.serviceName);
            if (dataService == null) {
                throw new MetaStoreException("Unable to load dataservice " + this.serviceName);
            }
            TransMeta serviceTrans = dataService.getServiceTrans();
            TransMutators.disableAllUnrelatedHops(dataService.getStepname(), serviceTrans, false);
            Trans trans = this.getTrans(serviceTrans);
            IMetaStore ms = AnnotationsQueryService.this.metastoreLocator.getMetastore();
            if (ms == null) {
                ms = MetaStoreConst.openLocalPentahoMetaStore();
            }
            trans.setMetaStore(ms);
            if (serviceTrans.getTransHopSteps(false).size() > 0) {
                trans.prepareExecution(new String[0]);
            }
            return trans;
        }

        Trans getTrans(TransMeta serviceTrans) {
            return new Trans(serviceTrans);
        }

        @Override
        public List<Trans> getTransList() {
            return Collections.emptyList();
        }
    }
}

