/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.execution;

import java.util.concurrent.TimeUnit;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.RowAdapter;

class DefaultTransWiringRowAdapter
extends RowAdapter {
    public static final String PASSING_ALONG_ROW = "Passing along row: ";
    public static final String ROW_BUFFER_IS_FULL_TRYING_AGAIN = "Row buffer is full, trying again";
    private final Trans serviceTrans;
    private final Trans genTrans;
    private final RowProducer rowProducer;

    public DefaultTransWiringRowAdapter(Trans serviceTrans, Trans genTrans, RowProducer rowProducer) {
        this.serviceTrans = serviceTrans;
        this.genTrans = genTrans;
        this.rowProducer = rowProducer;
    }

    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        LogChannelInterface log = this.serviceTrans.getLogChannel();
        try {
            if (log.isRowLevel()) {
                log.logRowlevel(PASSING_ALONG_ROW + rowMeta.getString(row));
            }
        }
        catch (KettleValueException kettleValueException) {
            // empty catch block
        }
        try {
            Object[] rowData = rowMeta.cloneRow(row);
            while (!this.rowProducer.putRowWait(rowMeta, rowData, 1L, TimeUnit.SECONDS) && this.genTrans.isRunning()) {
                if (!log.isRowLevel()) continue;
                log.logRowlevel(ROW_BUFFER_IS_FULL_TRYING_AGAIN);
            }
        }
        catch (KettleValueException e) {
            throw new KettleStepException((Throwable)e);
        }
    }
}

