/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.cache;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Set;
import javax.cache.Cache;
import org.pentaho.di.core.annotations.CarteServlet;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceCacheFactory;
import org.pentaho.di.www.BaseCartePlugin;
import org.pentaho.di.www.CarteRequestHandler;

@CarteServlet(id="ds_clearServiceCache", name="PDI Data Service: ServiceCache reset", description="Clear a data service Cache")
public class ResetCacheServlet
extends BaseCartePlugin {
    private static final String NAME_PARAMETER = "name";
    private final ServiceCacheFactory factory;
    private static final String CONTEXT_PATH = "/clearDataServiceCache";

    public ResetCacheServlet(ServiceCacheFactory factory) {
        this.factory = factory;
    }

    public String getContextPath() {
        return CONTEXT_PATH;
    }

    public void handleRequest(CarteRequestHandler.CarteRequest request) throws IOException {
        Collection names = (Collection)request.getParameters().get(NAME_PARAMETER);
        if (names == null || names.isEmpty()) {
            request.respond(400).withMessage("name not specified");
            return;
        }
        ImmutableSet cacheSet = FluentIterable.from((Iterable)names).transform((Function)new Function<String, Cache>(){

            public Cache apply(String name) {
                return (Cache)ResetCacheServlet.this.factory.getCache(name).orNull();
            }
        }).filter(Predicates.notNull()).toSet();
        for (Cache cache : cacheSet) {
            cache.clear();
        }
        request.respond(200).with(MediaType.PLAIN_TEXT_UTF_8.toString(), new CarteRequestHandler.WriterResponse((Set)cacheSet){
            final /* synthetic */ Set val$cacheSet;
            {
                this.val$cacheSet = set;
            }

            public void write(PrintWriter writer) throws IOException {
                if (this.val$cacheSet.isEmpty()) {
                    writer.println("No matching caches to flush.");
                }
                for (Cache cache : this.val$cacheSet) {
                    writer.println("Cleared cache: " + cache.getName());
                }
                writer.println("Done");
            }
        });
    }
}

