/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.cache.ui;

import com.google.common.collect.ImmutableList;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceCache;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceCacheFactory;
import org.pentaho.di.trans.dataservice.ui.BindingConverters;
import org.pentaho.di.trans.dataservice.ui.controller.AbstractController;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceModel;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulTextbox;

public class ServiceCacheController
extends AbstractController {
    private static final String NAME = "serviceCacheCtrl";
    private final ServiceCacheFactory factory;

    public ServiceCacheController(ServiceCacheFactory factory) {
        this.factory = factory;
        this.setName(NAME);
    }

    public void initBindings(DataServiceModel model) {
        this.initBindings(this.locateServiceCacheMeta(model));
    }

    public void initBindings(PushDownOptimizationMeta meta) {
        ServiceCache serviceCache = (ServiceCache)meta.getType();
        BindingFactory bindingFactory = this.getBindingFactory();
        XulCheckbox checkbox = (XulCheckbox)this.getElementById("service-cache-checkbox");
        XulTextbox ttl = (XulTextbox)this.getElementById("service-cache-ttl");
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        checkbox.setChecked(meta.isEnabled());
        bindingFactory.createBinding((Object)checkbox, "checked", (Object)meta, "enabled", new BindingConvertor[0]);
        try {
            ttl.setValue(serviceCache.getConfiguredTimeToLive());
        }
        catch (Exception e) {
            this.getLogChannel().logError("Unable to set default TTL", (Throwable)e);
        }
        bindingFactory.createBinding((Object)ttl, "value", (Object)serviceCache, "timeToLive", new BindingConvertor[0]);
        ttl.setDisabled(!meta.isEnabled());
        bindingFactory.createBinding((Object)checkbox, "checked", (Object)ttl, "disabled", new BindingConvertor[]{BindingConverters.not()});
    }

    protected PushDownOptimizationMeta locateServiceCacheMeta(DataServiceModel model) {
        PushDownOptimizationMeta meta;
        ImmutableList<PushDownOptimizationMeta> cacheOptimizations = model.getPushDownOptimizations(this.factory.getType());
        if (cacheOptimizations.isEmpty()) {
            meta = new PushDownOptimizationMeta();
            meta.setStepName(model.getServiceStep());
            meta.setType(this.factory.createPushDown());
            model.add(meta);
        } else {
            meta = (PushDownOptimizationMeta)cacheOptimizations.get(0);
        }
        if (cacheOptimizations.size() > 1) {
            model.removeAll(cacheOptimizations.subList(1, cacheOptimizations.size()));
        }
        return meta;
    }
}

