/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.mongod;

import com.mongodb.QueryBuilder;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.jdbc.ThinUtil;

public enum MongoFunc {
    LT(2){

        @Override
        public void affirm(QueryBuilder queryBuilder, String attribute, Object value) {
            queryBuilder.and(attribute).lessThan(value);
        }
    }
    ,
    LTE(3){

        @Override
        public void affirm(QueryBuilder queryBuilder, String attribute, Object value) {
            queryBuilder.and(attribute).lessThanEquals(value);
        }
    }
    ,
    GT(4){

        @Override
        public void affirm(QueryBuilder queryBuilder, String attribute, Object value) {
            queryBuilder.and(attribute).greaterThan(value);
        }
    }
    ,
    GTE(5){

        @Override
        public void affirm(QueryBuilder queryBuilder, String attribute, Object value) {
            queryBuilder.and(attribute).greaterThanEquals(value);
        }
    }
    ,
    EQ(0){

        @Override
        public void affirm(QueryBuilder queryBuilder, String attribute, Object value) {
            queryBuilder.and(attribute).is(value);
        }

        @Override
        public void negate(QueryBuilder queryBuilder, String attribute, Object value) {
            NEQ.affirm(queryBuilder, attribute, value);
        }
    }
    ,
    NEQ(1){

        @Override
        public void affirm(QueryBuilder queryBuilder, String attribute, Object value) {
            queryBuilder.and(attribute).notEquals(value);
        }

        @Override
        public void negate(QueryBuilder queryBuilder, String attribute, Object value) {
            EQ.affirm(queryBuilder, attribute, value);
        }
    }
    ,
    IN(9){

        @Override
        public void affirm(QueryBuilder queryBuilder, String attribute, Object value) {
            queryBuilder.and(attribute).in(value);
        }

        @Override
        public void negate(QueryBuilder queryBuilder, String attribute, Object value) {
            queryBuilder.and(attribute).notIn(value);
        }
    }
    ,
    LIKE(13){

        @Override
        public void affirm(QueryBuilder queryBuilder, String attribute, Object value) {
            queryBuilder.and(attribute).regex(ThinUtil.like((String)value.toString()));
        }
    };

    private final int kettleFuncCode;
    private static final Map<Integer, MongoFunc> kettleToMongo;

    private MongoFunc(int kettleFuncCode) {
        this.kettleFuncCode = kettleFuncCode;
    }

    public static MongoFunc getMongoFunc(int kettleFuncCode) {
        return kettleToMongo.get(kettleFuncCode);
    }

    public abstract void affirm(QueryBuilder var1, String var2, Object var3);

    public void negate(QueryBuilder queryBuilder, String attribute, Object value) {
        this.affirm(queryBuilder.not(), attribute, value);
    }

    static {
        kettleToMongo = new HashMap<Integer, MongoFunc>();
        for (MongoFunc func : MongoFunc.values()) {
            kettleToMongo.put(func.kettleFuncCode, func);
        }
    }
}

